#ifndef HKISAPI_H_
#define HKISAPI_H_

#include "../yc_type.h"

/*
############################################################
<?xml version="1.0" encoding="UTF-8"?>
<ResponseStatus version="2.0" xmlns="http://www.std-cgi.com/ver20/XMLSchema">
    <requestURL>/ISAPI/PTZCtrl/channels/1/zoomFocus</requestURL>
    <statusCode>4</statusCode>
    <statusString>Invalid Operation</statusString>
    <subStatusCode>methodNotAllowed</subStatusCode>
</ResponseStatus>

############################################################
/ISAPI/PTZCtrl/channels/1/zoomFocus
<ZoomFocus version="2.0" xmlns="http://www.std-cgi.com/ver20/XMLSchema">
    <pqrsZoom>0</pqrsZoom>
    <mnstFocus>28957</mnstFocus>
</ZoomFocus>

############################################################
/ISAPI/Image/channels/1/color
<?xml version="1.0" encoding="UTF-8"?>
<Color version="2.0" xmlns="http://www.std-cgi.com/ver20/XMLSchema">
    <brightnessLevel>52</brightnessLevel>
    <contrastLevel>49</contrastLevel>
    <saturationLevel>50</saturationLevel>
</Color>

############################################################
/ISAPI/Image/channels/1/exposure
<?xml version="1.0" encoding="UTF-8"?>
<Exposure version="2.0" xmlns="http://www.std-cgi.com/ver20/XMLSchema">
    <ExposureType>auto</ExposureType>
</Exposure>

############################################################
/ISAPI/Image/channels/1/iris
<?xml version="1.0" encoding="UTF-8"?>
<Iris version="2.0" xmlns="http://www.std-cgi.com/ver20/XMLSchema">
    <IrisLevel>160</IrisLevel>
    <maxIrisLevelLimit>100</maxIrisLevelLimit>
    <minIrisLevelLimit>0</minIrisLevelLimit>
</Iris>

############################################################
/ISAPI/Image/channels/1/SupplementLight
<?xml version="1.0" encoding="UTF-8"?>
<SupplementLight version="2.0" xmlns="http://www.hikvision.com/ver20/XMLSchema">
    <supplementLightMode>close</supplementLightMode>
    <mixedLightBrightnessRegulatMode>manual</mixedLightBrightnessRegulatMode>
    <whiteLightBrightness>0</whiteLightBrightness>
    <irLightBrightness>100</irLightBrightness>
</SupplementLight>
*/

struct _HKISAPIContext;
typedef struct _HKISAPIContext HKISAPIContext;

#define ConstHKISAPIRaw_DataSizeMax		1024
#define ConstHKISAPIBin_DataSizeMax		1024
struct HKISAPIConfig {
    char url[128];
    char username[32];
    char password[32];

    u16 timeout;
    u16 pad;
};

//
struct HKISAPIRaw {
    char isapi[128];//url: /ISAPI/*
    s32 mode;//0 get, 1 put

    //
    s32 reqSize;
    s32 respSizeMax;
    s32 respSizeReturn;
    char req[ConstHKISAPIRaw_DataSizeMax];
    char resp[ConstHKISAPIRaw_DataSizeMax];
};

struct HKISAPIRaw2 {
    char isapi[128];//url: /ISAPI/*
    s32 mode;//0 get, 1 put

    //
    s32 reqSize;
    s32 respSizeMax;
    s32 respSizeReturn;
    char* req;
    char* resp;
};

//
enum HKISAPIBinType {
    HKISAPIBinType_ZoomFocus = 0,
    HKISAPIBinType_Color,
    HKISAPIBinType_Exposure,
    HKISAPIBinType_Iris,
    HKISAPIBinType_FocusConfiguration,
    HKISAPIBinType_SupplementLight,
    HKISAPIBinType_XXXEnd,
};

struct HKISAPI_ResponseStatus {
    char requestURL[128];
    s32 statusCode;//0,1 ok; x bad
    char statusString[64];
    char subStatusCode[64];
};

struct HKISAPI_ZoomFocus {
    s32 pqrsZoom;
    s32 mnstFocus;
};

struct HKISAPI_Color {
    s32 brightnessLevel;//0,100
    s32 contrastLevel;//0,100
    s32 saturationLevel;//0,100
};

struct HKISAPI_Exposure {
    char ExposureType[64];//manual,auto,IrisFirst,ShutterFirst
};

struct HKISAPI_Iris {
    s32 IrisLevel;//160,200,240,280,340,400,480,560,680,960,1100,1400,1600,1900,2200
};

struct HKISAPI_FocusConfiguration {
    char focusStyle[32];//AUTO,MANUAL,SEMIAUTOMATIC
    s32 focusLimited;//10,30,100,150,300,600,1000,2000,65535
};

struct HKISAPI_SupplementLight {
    char supplementLightMode[32];//close, colorVuWhiteLight
    char mixedLightBrightnessRegulatMode[32];//manual, auto
    s32 whiteLightBrightness;//[0,100]
    s32 irLightBrightness;//[0,100]
};

struct HKISAPIBin {
    s32 type;//url: type2url
    s32 mode;//0 get, 1 put
    s32 reqSize;
    s32 respSizeReturn;

    //
    union {
        u8 pad[ConstHKISAPIBin_DataSizeMax];
        HKISAPI_ZoomFocus ZoomFocus;
        HKISAPI_Color Color;
        HKISAPI_Exposure Exposure;
        HKISAPI_Iris Iris;
        HKISAPI_FocusConfiguration FocusConfiguration;
        HKISAPI_SupplementLight SupplementLight;
    }req;

    union {
        u8 pad[ConstHKISAPIBin_DataSizeMax];
        HKISAPI_ResponseStatus ResponseStatus;
        HKISAPI_ZoomFocus ZoomFocus;
        HKISAPI_Color Color;
        HKISAPI_Exposure Exposure;
        HKISAPI_Iris Iris;
        HKISAPI_FocusConfiguration FocusConfiguration;
        HKISAPI_SupplementLight SupplementLight;
    }resp;
};

extern "C" {
    SDK_API HKISAPIContext* hkisapiCreate();
    SDK_API void hkisapiFree(HKISAPIContext** pp);
    SDK_API s32 hkisapiSetConfig(HKISAPIContext* context, HKISAPIConfig* config);

    //
    SDK_API s32 hkisapiExecuteRaw(HKISAPIContext* context, HKISAPIRaw* raw);
    SDK_API s32 hkisapiExecuteRaw2(HKISAPIContext* context, HKISAPIRaw2* raw2);
    SDK_API s32 hkisapiExecuteBin(HKISAPIContext* context, HKISAPIBin* bin);
}

#endif