#ifndef HKMVS_TYPES_H
#define HKMVS_TYPES_H

#include "../yc_type.h"

/****************************************************************basic**********************************************************************************************/
#define IN
#define OUT
typedef long long          int64_t;

// Indicate if pixel is monochrome or RGB
#define MV_GVSP_PIX_MONO                                0x01000000 
#define MV_GVSP_PIX_RGB                                 0x02000000 // deprecated in version 1.1
#define MV_GVSP_PIX_COLOR                               0x02000000
#define MV_GVSP_PIX_CUSTOM                              0x80000000
#define MV_GVSP_PIX_COLOR_MASK                          0xFF000000

// Indicate effective number of bits occupied by the pixel (including padding).
// This can be used to compute amount of memory required to store an image.
#define MV_PIXEL_BIT_COUNT(n)                           ((n) << 16)

#define MV_GVSP_PIX_EFFECTIVE_PIXEL_SIZE_MASK           0x00FF0000
#define MV_GVSP_PIX_EFFECTIVE_PIXEL_SIZE_SHIFT          16

// Pixel ID: lower 16-bit of the pixel formats
#define MV_GVSP_PIX_ID_MASK                             0x0000FFFF
#define MV_GVSP_PIX_COUNT                               0x46 // next Pixel ID available

enum MvGvspPixelType
{
	// Undefined pixel type
	PixelType_Gvsp_Undefined = 0xFFFFFFFF,

	// Mono buffer format defines
	PixelType_Gvsp_Mono1p = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(1) | 0x0037),
	PixelType_Gvsp_Mono2p = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(2) | 0x0038),
	PixelType_Gvsp_Mono4p = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(4) | 0x0039),
	PixelType_Gvsp_Mono8 = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(8) | 0x0001),
	PixelType_Gvsp_Mono8_Signed = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(8) | 0x0002),
	PixelType_Gvsp_Mono10 = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(16) | 0x0003),
	PixelType_Gvsp_Mono10_Packed = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(12) | 0x0004),
	PixelType_Gvsp_Mono12 = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(16) | 0x0005),
	PixelType_Gvsp_Mono12_Packed = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(12) | 0x0006),
	PixelType_Gvsp_Mono14 = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(16) | 0x0025),
	PixelType_Gvsp_Mono16 = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(16) | 0x0007),

	// Bayer buffer format defines 
	PixelType_Gvsp_BayerGR8 = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(8) | 0x0008),
	PixelType_Gvsp_BayerRG8 = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(8) | 0x0009),
	PixelType_Gvsp_BayerGB8 = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(8) | 0x000A),
	PixelType_Gvsp_BayerBG8 = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(8) | 0x000B),
	PixelType_Gvsp_BayerGR10 = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(16) | 0x000C),
	PixelType_Gvsp_BayerRG10 = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(16) | 0x000D),
	PixelType_Gvsp_BayerGB10 = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(16) | 0x000E),
	PixelType_Gvsp_BayerBG10 = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(16) | 0x000F),
	PixelType_Gvsp_BayerGR12 = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(16) | 0x0010),
	PixelType_Gvsp_BayerRG12 = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(16) | 0x0011),
	PixelType_Gvsp_BayerGB12 = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(16) | 0x0012),
	PixelType_Gvsp_BayerBG12 = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(16) | 0x0013),
	PixelType_Gvsp_BayerGR10_Packed = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(12) | 0x0026),
	PixelType_Gvsp_BayerRG10_Packed = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(12) | 0x0027),
	PixelType_Gvsp_BayerGB10_Packed = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(12) | 0x0028),
	PixelType_Gvsp_BayerBG10_Packed = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(12) | 0x0029),
	PixelType_Gvsp_BayerGR12_Packed = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(12) | 0x002A),
	PixelType_Gvsp_BayerRG12_Packed = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(12) | 0x002B),
	PixelType_Gvsp_BayerGB12_Packed = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(12) | 0x002C),
	PixelType_Gvsp_BayerBG12_Packed = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(12) | 0x002D),
	PixelType_Gvsp_BayerGR16 = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(16) | 0x002E),
	PixelType_Gvsp_BayerRG16 = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(16) | 0x002F),
	PixelType_Gvsp_BayerGB16 = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(16) | 0x0030),
	PixelType_Gvsp_BayerBG16 = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(16) | 0x0031),

	// RGB Packed buffer format defines 
	PixelType_Gvsp_RGB8_Packed = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(24) | 0x0014),
	PixelType_Gvsp_BGR8_Packed = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(24) | 0x0015),
	PixelType_Gvsp_RGBA8_Packed = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(32) | 0x0016),
	PixelType_Gvsp_BGRA8_Packed = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(32) | 0x0017),
	PixelType_Gvsp_RGB10_Packed = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(48) | 0x0018),
	PixelType_Gvsp_BGR10_Packed = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(48) | 0x0019),
	PixelType_Gvsp_RGB12_Packed = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(48) | 0x001A),
	PixelType_Gvsp_BGR12_Packed = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(48) | 0x001B),
	PixelType_Gvsp_RGB16_Packed = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(48) | 0x0033),
	PixelType_Gvsp_BGR16_Packed = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(48) | 0x004B),
	PixelType_Gvsp_RGBA16_Packed = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(64) | 0x0064),
	PixelType_Gvsp_BGRA16_Packed = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(64) | 0x0051),
	PixelType_Gvsp_RGB10V1_Packed = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(32) | 0x001C),
	PixelType_Gvsp_RGB10V2_Packed = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(32) | 0x001D),
	PixelType_Gvsp_RGB12V1_Packed = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(36) | 0X0034),
	PixelType_Gvsp_RGB565_Packed = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(16) | 0x0035),
	PixelType_Gvsp_BGR565_Packed = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(16) | 0X0036),

	// YUV Packed buffer format defines 
	PixelType_Gvsp_YUV411_Packed = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(12) | 0x001E),
	PixelType_Gvsp_YUV422_Packed = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(16) | 0x001F),
	PixelType_Gvsp_YUV422_YUYV_Packed = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(16) | 0x0032),
	PixelType_Gvsp_YUV444_Packed = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(24) | 0x0020),
	PixelType_Gvsp_YCBCR8_CBYCR = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(24) | 0x003A),
	PixelType_Gvsp_YCBCR422_8 = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(16) | 0x003B),
	PixelType_Gvsp_YCBCR422_8_CBYCRY = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(16) | 0x0043),
	PixelType_Gvsp_YCBCR411_8_CBYYCRYY = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(12) | 0x003C),
	PixelType_Gvsp_YCBCR601_8_CBYCR = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(24) | 0x003D),
	PixelType_Gvsp_YCBCR601_422_8 = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(16) | 0x003E),
	PixelType_Gvsp_YCBCR601_422_8_CBYCRY = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(16) | 0x0044),
	PixelType_Gvsp_YCBCR601_411_8_CBYYCRYY = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(12) | 0x003F),
	PixelType_Gvsp_YCBCR709_8_CBYCR = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(24) | 0x0040),
	PixelType_Gvsp_YCBCR709_422_8 = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(16) | 0x0041),
	PixelType_Gvsp_YCBCR709_422_8_CBYCRY = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(16) | 0x0045),
	PixelType_Gvsp_YCBCR709_411_8_CBYYCRYY = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(12) | 0x0042),

	// RGB Planar buffer format defines 
	PixelType_Gvsp_RGB8_Planar = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(24) | 0x0021),
	PixelType_Gvsp_RGB10_Planar = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(48) | 0x0022),
	PixelType_Gvsp_RGB12_Planar = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(48) | 0x0023),
	PixelType_Gvsp_RGB16_Planar = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(48) | 0x0024),

	// 自定义的图片格式
	PixelType_Gvsp_Jpeg = (MV_GVSP_PIX_CUSTOM | MV_PIXEL_BIT_COUNT(24) | 0x0001),

	PixelType_Gvsp_Coord3D_ABC32f = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(96) | 0x00C0),//0x026000C0
	PixelType_Gvsp_Coord3D_ABC32f_Planar = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(96) | 0x00C1),//0x026000C1

	// 该值被废弃，请参考PixelType_Gvsp_Coord3D_AC32f_64; the value is discarded
	PixelType_Gvsp_Coord3D_AC32f = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(40) | 0x00C2),
	// 该值被废弃; the value is discarded    (已放入Chunkdata)
	PixelType_Gvsp_COORD3D_DEPTH_PLUS_MASK = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(28) | 0x0001),

	PixelType_Gvsp_Coord3D_ABC32 = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(96) | 0x3001),//0x82603001
	PixelType_Gvsp_Coord3D_AB32f = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(64) | 0x3002),//0x82403002
	PixelType_Gvsp_Coord3D_AB32 = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(64) | 0x3003),//0x82403003
	PixelType_Gvsp_Coord3D_AC32f_64 = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(64) | 0x00C2),//0x024000C2
	PixelType_Gvsp_Coord3D_AC32f_Planar = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(64) | 0x00C3),//0x024000C3
	PixelType_Gvsp_Coord3D_AC32 = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(64) | 0x3004),//0x82403004
	PixelType_Gvsp_Coord3D_A32f = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(32) | 0x00BD),//0x012000BD
	PixelType_Gvsp_Coord3D_A32 = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(32) | 0x3005),//0x81203005
	PixelType_Gvsp_Coord3D_C32f = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(32) | 0x00BF),//0x012000BF
	PixelType_Gvsp_Coord3D_C32 = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(32) | 0x3006),//0x81203006
	PixelType_Gvsp_Coord3D_ABC16 = (MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(48) | 0x00B9),//0x023000B9
	PixelType_Gvsp_Coord3D_C16 = (MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(16) | 0x00B8),//0x011000B8

	//无损压缩像素格式定义
	PixelType_Gvsp_HB_Mono8 = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(8) | 0x0001),
	PixelType_Gvsp_HB_Mono10 = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(16) | 0x0003),
	PixelType_Gvsp_HB_Mono10_Packed = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(12) | 0x0004),
	PixelType_Gvsp_HB_Mono12 = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(16) | 0x0005),
	PixelType_Gvsp_HB_Mono12_Packed = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(12) | 0x0006),
	PixelType_Gvsp_HB_Mono16 = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(16) | 0x0007),
	PixelType_Gvsp_HB_BayerGR8 = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(8) | 0x0008),
	PixelType_Gvsp_HB_BayerRG8 = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(8) | 0x0009),
	PixelType_Gvsp_HB_BayerGB8 = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(8) | 0x000A),
	PixelType_Gvsp_HB_BayerBG8 = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(8) | 0x000B),
	PixelType_Gvsp_HB_BayerGR10 = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(16) | 0x000C),
	PixelType_Gvsp_HB_BayerRG10 = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(16) | 0x000D),
	PixelType_Gvsp_HB_BayerGB10 = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(16) | 0x000E),
	PixelType_Gvsp_HB_BayerBG10 = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(16) | 0x000F),
	PixelType_Gvsp_HB_BayerGR12 = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(16) | 0x0010),
	PixelType_Gvsp_HB_BayerRG12 = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(16) | 0x0011),
	PixelType_Gvsp_HB_BayerGB12 = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(16) | 0x0012),
	PixelType_Gvsp_HB_BayerBG12 = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(16) | 0x0013),
	PixelType_Gvsp_HB_BayerGR10_Packed = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(12) | 0x0026),
	PixelType_Gvsp_HB_BayerRG10_Packed = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(12) | 0x0027),
	PixelType_Gvsp_HB_BayerGB10_Packed = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(12) | 0x0028),
	PixelType_Gvsp_HB_BayerBG10_Packed = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(12) | 0x0029),
	PixelType_Gvsp_HB_BayerGR12_Packed = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(12) | 0x002A),
	PixelType_Gvsp_HB_BayerRG12_Packed = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(12) | 0x002B),
	PixelType_Gvsp_HB_BayerGB12_Packed = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(12) | 0x002C),
	PixelType_Gvsp_HB_BayerBG12_Packed = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_MONO | MV_PIXEL_BIT_COUNT(12) | 0x002D),
	PixelType_Gvsp_HB_YUV422_Packed = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(16) | 0x001F),
	PixelType_Gvsp_HB_YUV422_YUYV_Packed = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(16) | 0x0032),
	PixelType_Gvsp_HB_RGB8_Packed = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(24) | 0x0014),
	PixelType_Gvsp_HB_BGR8_Packed = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(24) | 0x0015),
	PixelType_Gvsp_HB_RGBA8_Packed = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(32) | 0x0016),
	PixelType_Gvsp_HB_BGRA8_Packed = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(32) | 0x0017),
	PixelType_Gvsp_HB_RGB16_Packed = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(48) | 0x0033),
	PixelType_Gvsp_HB_BGR16_Packed = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(48) | 0x004B),
	PixelType_Gvsp_HB_RGBA16_Packed = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(64) | 0x0064),
	PixelType_Gvsp_HB_BGRA16_Packed = (MV_GVSP_PIX_CUSTOM | MV_GVSP_PIX_COLOR | MV_PIXEL_BIT_COUNT(64) | 0x0051),

};

/// \~chinese GigE设备信息              \~english GigE device info
typedef struct _MV_GIGE_DEVICE_INFO_
{
	unsigned int        nIpCfgOption;                               ///< [OUT] \~chinese IP配置选项             \~english IP Configuration Options
	unsigned int        nIpCfgCurrent;                              ///< [OUT] \~chinese 当前IP配置             \~english IP Configuration:bit31-static bit30-dhcp bit29-lla
	unsigned int        nCurrentIp;                                 ///< [OUT] \~chinese 当前IP地址             \~english Current Ip
	unsigned int        nCurrentSubNetMask;                         ///< [OUT] \~chinese 当前子网掩码           \~english Curtent Subnet Mask
	unsigned int        nDefultGateWay;                             ///< [OUT] \~chinese 当前网关               \~english Current Gateway
	unsigned char       chManufacturerName[32];                     ///< [OUT] \~chinese 制造商名称             \~english Manufacturer Name
	unsigned char       chModelName[32];                            ///< [OUT] \~chinese 型号名称               \~english Model Name
	unsigned char       chDeviceVersion[32];                        ///< [OUT] \~chinese 设备版本               \~english Device Version 
	unsigned char       chManufacturerSpecificInfo[48];             ///< [OUT] \~chinese 制造商的具体信息       \~english Manufacturer Specific Information
	unsigned char       chSerialNumber[16];                         ///< [OUT] \~chinese 序列号                 \~english Serial Number
	unsigned char       chUserDefinedName[16];                      ///< [OUT] \~chinese 用户自定义名称         \~english User Defined Name 
	unsigned int        nNetExport;                                 ///< [OUT] \~chinese 网口IP地址             \~english NetWork IP Address

	unsigned int        nReserved[4];                               ///<       \~chinese 预留                   \~english Reserved

}MV_GIGE_DEVICE_INFO;

///< \~chinese 最大的数据信息大小       \~english Maximum data information size
#define INFO_MAX_BUFFER_SIZE            64

/// \~chinese USB设备信息               \~english USB device info
typedef struct _MV_USB3_DEVICE_INFO_
{
	unsigned char       CrtlInEndPoint;                             ///< [OUT] \~chinese 控制输入端点           \~english Control input endpoint
	unsigned char       CrtlOutEndPoint;                            ///< [OUT] \~chinese 控制输出端点           \~english Control output endpoint
	unsigned char       StreamEndPoint;                             ///< [OUT] \~chinese 流端点                 \~english Flow endpoint
	unsigned char       EventEndPoint;                              ///< [OUT] \~chinese 事件端点               \~english Event endpoint
	unsigned short      idVendor;                                   ///< [OUT] \~chinese 供应商ID号             \~english Vendor ID Number
	unsigned short      idProduct;                                  ///< [OUT] \~chinese 产品ID号               \~english Device ID Number
	unsigned int        nDeviceNumber;                              ///< [OUT] \~chinese 设备索引号             \~english Device Number
	unsigned char       chDeviceGUID[INFO_MAX_BUFFER_SIZE];         ///< [OUT] \~chinese 设备GUID号             \~english Device GUID Number
	unsigned char       chVendorName[INFO_MAX_BUFFER_SIZE];         ///< [OUT] \~chinese 供应商名字             \~english Vendor Name
	unsigned char       chModelName[INFO_MAX_BUFFER_SIZE];          ///< [OUT] \~chinese 型号名字               \~english Model Name
	unsigned char       chFamilyName[INFO_MAX_BUFFER_SIZE];         ///< [OUT] \~chinese 家族名字               \~english Family Name
	unsigned char       chDeviceVersion[INFO_MAX_BUFFER_SIZE];      ///< [OUT] \~chinese 设备版本               \~english Device Version
	unsigned char       chManufacturerName[INFO_MAX_BUFFER_SIZE];   ///< [OUT] \~chinese 制造商名字             \~english Manufacturer Name
	unsigned char       chSerialNumber[INFO_MAX_BUFFER_SIZE];       ///< [OUT] \~chinese 序列号                 \~english Serial Number
	unsigned char       chUserDefinedName[INFO_MAX_BUFFER_SIZE];    ///< [OUT] \~chinese 用户自定义名字         \~english User Defined Name
	unsigned int        nbcdUSB;                                    ///< [OUT] \~chinese 支持的USB协议          \~english Support USB Protocol
	unsigned int        nDeviceAddress;                             ///< [OUT] \~chinese 设备地址               \~english Device Address

	unsigned int        nReserved[2];                               ///<       \~chinese 预留                   \~english Reserved

}MV_USB3_DEVICE_INFO;

/// \~chinese CameraLink设备信息        \~english CameraLink device info
typedef struct _MV_CamL_DEV_INFO_
{
	unsigned char       chPortID[INFO_MAX_BUFFER_SIZE];             ///< [OUT] \~chinese 端口号                 \~english Port ID
	unsigned char       chModelName[INFO_MAX_BUFFER_SIZE];          ///< [OUT] \~chinese 型号名字               \~english Model Name
	unsigned char       chFamilyName[INFO_MAX_BUFFER_SIZE];         ///< [OUT] \~chinese 名称                   \~english Family Name
	unsigned char       chDeviceVersion[INFO_MAX_BUFFER_SIZE];      ///< [OUT] \~chinese 设备版本               \~english Device Version
	unsigned char       chManufacturerName[INFO_MAX_BUFFER_SIZE];   ///< [OUT] \~chinese 制造商名字             \~english Manufacturer Name
	unsigned char       chSerialNumber[INFO_MAX_BUFFER_SIZE];       ///< [OUT] \~chinese 序列号                 \~english Serial Number

	unsigned int        nReserved[38];                              ///<       \~chinese 预留                   \~english Reserved

}MV_CamL_DEV_INFO;

///< \~chinese 设备传输层协议类型       \~english Device Transport Layer Protocol Type
#define MV_UNKNOW_DEVICE                0x00000000                  ///< \~chinese 未知设备类型，保留意义       \~english Unknown Device Type, Reserved 
#define MV_GIGE_DEVICE                  0x00000001                  ///< \~chinese GigE设备                     \~english GigE Device
#define MV_1394_DEVICE                  0x00000002                  ///< \~chinese 1394-a/b 设备                \~english 1394-a/b Device
#define MV_USB_DEVICE                   0x00000004                  ///< \~chinese USB 设备                     \~english USB Device
#define MV_CAMERALINK_DEVICE            0x00000008                  ///< \~chinese CameraLink设备               \~english CameraLink Device

/// \~chinese 设备信息                  \~english Device info
typedef struct _MV_CC_DEVICE_INFO_
{
	unsigned short          nMajorVer;                              ///< [OUT] \~chinese 主要版本               \~english Major Version
	unsigned short          nMinorVer;                              ///< [OUT] \~chinese 次要版本               \~english Minor Version
	unsigned int            nMacAddrHigh;                           ///< [OUT] \~chinese 高MAC地址              \~english High MAC Address
	unsigned int            nMacAddrLow;                            ///< [OUT] \~chinese 低MAC地址              \~english Low MAC Address
	unsigned int            nTLayerType;                            ///< [OUT] \~chinese 设备传输层协议类型     \~english Device Transport Layer Protocol Type

	unsigned int            nReserved[4];                           ///<       \~chinese 预留                   \~english Reserved

	union
	{
		MV_GIGE_DEVICE_INFO stGigEInfo;                             ///< [OUT] \~chinese GigE设备信息           \~english GigE Device Info
		MV_USB3_DEVICE_INFO stUsb3VInfo;                            ///< [OUT] \~chinese USB设备信息            \~english USB Device Info
		MV_CamL_DEV_INFO    stCamLInfo;                             ///< [OUT] \~chinese CameraLink设备信息     \~english CameraLink Device Info
		// more ...
	}SpecialInfo;

}MV_CC_DEVICE_INFO;

///< \~chinese 最多支持的传输层实例个数 \~english The maximum number of supported transport layer instances
#define MV_MAX_TLS_NUM                  8
///< \~chinese 最大支持的设备个数       \~english The maximum number of supported devices
#define MV_MAX_DEVICE_NUM               256

/// \~chinese 设备信息列表              \~english Device Information List
typedef struct _MV_CC_DEVICE_INFO_LIST_
{
	unsigned int        nDeviceNum;                                 ///< [OUT] \~chinese 在线设备数量           \~english Online Device Number
	MV_CC_DEVICE_INFO* pDeviceInfo[MV_MAX_DEVICE_NUM];             ///< [OUT] \~chinese 支持最多256个设备      \~english Support up to 256 devices

}MV_CC_DEVICE_INFO_LIST;

/// \~chinese 设备的访问模式            \~english Device Access Mode
#define MV_ACCESS_Exclusive                     1                   /// \~chinese 独占权限，其他APP只允许读CCP寄存器                    \~english Exclusive authority, other APP is only allowed to read the CCP register
#define MV_ACCESS_ExclusiveWithSwitch           2                   /// \~chinese 可以从5模式下抢占权限，然后以独占权限打开             \~english You can seize the authority from the 5 mode, and then open with exclusive authority
#define MV_ACCESS_Control                       3                   /// \~chinese 控制权限，其他APP允许读所有寄存器                     \~english Control authority, allows other APP reading all registers
#define MV_ACCESS_ControlWithSwitch             4                   /// \~chinese 可以从5的模式下抢占权限，然后以控制权限打开           \~english You can seize the authority from the 5 mode, and then open with control authority
#define MV_ACCESS_ControlSwitchEnable           5                   /// \~chinese 以可被抢占的控制权限打开                              \~english Open with seized control authority
#define MV_ACCESS_ControlSwitchEnableWithKey    6                   /// \~chinese 可以从5的模式下抢占权限，然后以可被抢占的控制权限打开 \~english You can seize the authority from the 5 mode, and then open with seized control authority
#define MV_ACCESS_Monitor                       7                   /// \~chinese 读模式打开设备，适用于控制权限下                      \~english Open with read mode and is available under control authority

/// \~chinese Chunk内容                 \~english The content of ChunkData
typedef struct _MV_CHUNK_DATA_CONTENT_
{
	unsigned char* pChunkData;                                 ///< [OUT] \~chinese Chunk数据              \~english Chunk Data
	unsigned int        nChunkID;                                   ///< [OUT] \~chinese Chunk ID               \~english Chunk ID
	unsigned int        nChunkLen;                                  ///< [OUT] \~chinese Chunk的长度            \~english Chunk Length

	unsigned int        nReserved[8];                               ///<       \~chinese 预留                   \~english Reserved

}MV_CHUNK_DATA_CONTENT;

/// \~chinese 输出帧的信息              \~english Output Frame Information
typedef struct _MV_FRAME_OUT_INFO_EX_
{
	unsigned short          nWidth;                                 ///< [OUT] \~chinese 图像宽                 \~english Image Width
	unsigned short          nHeight;                                ///< [OUT] \~chinese 图像高                 \~english Image Height
	enum MvGvspPixelType    enPixelType;                            ///< [OUT] \~chinese 像素格式               \~english Pixel Type

	unsigned int            nFrameNum;                              ///< [OUT] \~chinese 帧号                   \~english Frame Number
	unsigned int            nDevTimeStampHigh;                      ///< [OUT] \~chinese 时间戳高32位           \~english Timestamp high 32 bits
	unsigned int            nDevTimeStampLow;                       ///< [OUT] \~chinese 时间戳低32位           \~english Timestamp low 32 bits
	unsigned int            nReserved0;                             ///< [OUT] \~chinese 保留，8字节对齐        \~english Reserved, 8-byte aligned
	int64_t                 nHostTimeStamp;                         ///< [OUT] \~chinese 主机生成的时间戳       \~english Host-generated timestamp

	unsigned int            nFrameLen;                              ///< [OUT] \~chinese 帧的长度               \~english The Length of Frame

	/// \~chinese 设备水印时标      \~english Device frame-specific time scale
	unsigned int            nSecondCount;                           ///< [OUT] \~chinese 秒数                   \~english The Seconds
	unsigned int            nCycleCount;                            ///< [OUT] \~chinese 周期数                 \~english The Count of Cycle
	unsigned int            nCycleOffset;                           ///< [OUT] \~chinese 周期偏移量             \~english The Offset of Cycle

	float                   fGain;                                  ///< [OUT] \~chinese 增益                   \~english Gain
	float                   fExposureTime;                          ///< [OUT] \~chinese 曝光时间               \~english Exposure Time
	unsigned int            nAverageBrightness;                     ///< [OUT] \~chinese 平均亮度               \~english Average brightness

	/// \~chinese 白平衡相关        \~english White balance
	unsigned int            nRed;                                   ///< [OUT] \~chinese 红色                   \~english Red
	unsigned int            nGreen;                                 ///< [OUT] \~chinese 绿色                   \~english Green
	unsigned int            nBlue;                                  ///< [OUT] \~chinese 蓝色                   \~english Blue

	unsigned int            nFrameCounter;                          ///< [OUT] \~chinese 总帧数                 \~english Frame Counter
	unsigned int            nTriggerIndex;                          ///< [OUT] \~chinese 触发计数               \~english Trigger Counting

	unsigned int            nInput;                                 ///< [OUT] \~chinese 输入                   \~english Input
	unsigned int            nOutput;                                ///< [OUT] \~chinese 输出                   \~english Output

	/// \~chinese ROI区域           \~english ROI Region
	unsigned short          nOffsetX;                               ///< [OUT] \~chinese 水平偏移量             \~english OffsetX
	unsigned short          nOffsetY;                               ///< [OUT] \~chinese 垂直偏移量             \~english OffsetY
	unsigned short          nChunkWidth;                            ///< [OUT] \~chinese Chunk宽                \~english The Width of Chunk
	unsigned short          nChunkHeight;                           ///< [OUT] \~chinese Chunk高                \~english The Height of Chunk

	unsigned int            nLostPacket;                            ///< [OUT] \~chinese 本帧丢包数             \~english Lost Packet Number In This Frame

	unsigned int            nUnparsedChunkNum;                      ///< [OUT] \~chinese 未解析的Chunkdata个数  \~english Unparsed Chunk Number
	union
	{
		MV_CHUNK_DATA_CONTENT* pUnparsedChunkContent;              ///< [OUT] \~chinese 未解析的Chunk          \~english Unparsed Chunk Content
		int64_t                 nAligning;                          ///< [OUT] \~chinese 校准                   \~english Aligning
	}UnparsedChunkList;

	unsigned int            nReserved[36];                          ///<       \~chinese 预留                   \~english Reserved

}MV_FRAME_OUT_INFO_EX;

/****************************************************************config**********************************************************************************************/

/// \~chinese 最大XML符号数             \~english Max XML Symbolic Number 
#define MV_MAX_XML_SYMBOLIC_NUM         64
/// \~chinese 枚举类型值                \~english Enumeration Value
typedef struct _MVCC_ENUMVALUE_T
{
	unsigned int        nCurValue;                                  ///< [OUT] \~chinese 当前值                 \~english Current Value
	unsigned int        nSupportedNum;                              ///< [OUT] \~chinese 数据的有效数据个数     \~english Number of valid data
	unsigned int        nSupportValue[MV_MAX_XML_SYMBOLIC_NUM];     ///< [OUT] \~chinese 支持的枚举值           \~english Support Value 

	unsigned int        nReserved[4];                               ///<       \~chinese 预留                   \~english Reserved

}MVCC_ENUMVALUE;

/// \~chinese Int类型值                 \~english Int Value
typedef struct _MVCC_INTVALUE_T
{
	unsigned int        nCurValue;                                  ///< [OUT] \~chinese 当前值                 \~english Current Value
	unsigned int        nMax;                                       ///< [OUT] \~chinese 最大值                 \~english Max
	unsigned int        nMin;                                       ///< [OUT] \~chinese 最小值                 \~english Min
	unsigned int        nInc;                                       ///< [OUT] \~chinese                        \~english Inc

	unsigned int        nReserved[4];                               ///<       \~chinese 预留                   \~english Reserved

}MVCC_INTVALUE;

/// \~chinese Int类型值Ex               \~english Int Value Ex
typedef struct _MVCC_INTVALUE_EX_T
{
	int64_t             nCurValue;                                  ///< [OUT] \~chinese 当前值                 \~english Current Value
	int64_t             nMax;                                       ///< [OUT] \~chinese 最大值                 \~english Max
	int64_t             nMin;                                       ///< [OUT] \~chinese 最小值                 \~english Min
	int64_t             nInc;                                       ///< [OUT] \~chinese Inc                    \~english Inc

	unsigned int        nReserved[16];                              ///<       \~chinese 预留                   \~english Reserved

}MVCC_INTVALUE_EX;

/// \~chinese Float类型值               \~english Float Value
typedef struct _MVCC_FLOATVALUE_T
{
	float               fCurValue;                                  ///< [OUT] \~chinese 当前值                 \~english Current Value
	float               fMax;                                       ///< [OUT] \~chinese 最大值                 \~english Max
	float               fMin;                                       ///< [OUT] \~chinese 最小值                 \~english Min

	unsigned int        nReserved[4];                               ///<       \~chinese 预留                   \~english Reserved

}MVCC_FLOATVALUE;

/// \~chinese String类型值              \~english String Value
typedef struct _MVCC_STRINGVALUE_T
{
	char                chCurValue[256];                            ///< [OUT] \~chinese 当前值                 \~english Current Value

	int64_t             nMaxLength;                                 ///< [OUT] \~chinese 最大长度               \~english MaxLength
	unsigned int        nReserved[2];                               ///<       \~chinese 预留                   \~english Reserved

}MVCC_STRINGVALUE;

/// \~chinese 录像格式定义              \~english Record Format Type
typedef enum _MV_RECORD_FORMAT_TYPE_
{
	MV_FormatType_Undefined = 0,                        ///< \~chinese 未定义的录像格式             \~english Undefined Recode Format Type
	MV_FormatType_AVI = 1,                        ///< \~chinese AVI录像格式                  \~english AVI Recode Format Type

}MV_RECORD_FORMAT_TYPE;

/// \~chinese 录像参数                  \~english Record Parameters
typedef struct _MV_CC_RECORD_PARAM_T_
{
	enum MvGvspPixelType    enPixelType;                            ///< [IN]  \~chinese 输入数据的像素格式     \~english Pixel Type

	unsigned short          nWidth;                                 ///< [IN]  \~chinese 图像宽(2的倍数)        \~english Width
	unsigned short          nHeight;                                ///< [IN]  \~chinese 图像高(2的倍数)        \~english Height

	float                   fFrameRate;                             ///< [IN]  \~chinese 帧率fps(大于1/16)      \~english The Rate of Frame
	unsigned int            nBitRate;                               ///< [IN]  \~chinese 码率kbps(128-16*1024)  \~english The Rate of Bitrate

	MV_RECORD_FORMAT_TYPE   enRecordFmtType;                        ///< [IN]  \~chinese 录像格式               \~english Recode Format Type

	char* strFilePath;                            ///< [IN]  \~chinese 录像文件存放路径(如果路径中存在中文，需转成utf-8)  \~english File Path

	unsigned int            nRes[8];                                ///<       \~chinese 预留                   \~english Reserved

}MV_CC_RECORD_PARAM;

/// \~chinese 传入的图像数据            \~english Input Data
typedef struct _MV_CC_INPUT_FRAME_INFO_T_
{
	unsigned char* pData;                                      ///< [IN]  \~chinese 图像数据指针           \~english Record Data
	unsigned int        nDataLen;                                   ///< [IN]  \~chinese 图像大小               \~english The Length of Record Data

	unsigned int        nRes[8];                                    ///<       \~chinese 预留                   \~english Reserved

}MV_CC_INPUT_FRAME_INFO;

/// \~chinese 像素转换结构体            \~english Pixel convert structure
typedef struct _MV_PIXEL_CONVERT_PARAM_T_
{
	unsigned short          nWidth;                                 ///< [IN]  \~chinese 图像宽                 \~english Width
	unsigned short          nHeight;                                ///< [IN]  \~chinese 图像高                 \~english Height

	enum MvGvspPixelType    enSrcPixelType;                         ///< [IN]  \~chinese 源像素格式             \~english Source pixel format
	unsigned char* pSrcData;                               ///< [IN]  \~chinese 输入数据缓存           \~english Input data buffer
	unsigned int            nSrcDataLen;                            ///< [IN]  \~chinese 输入数据长度           \~english Input data length

	enum MvGvspPixelType    enDstPixelType;                         ///< [IN]  \~chinese 目标像素格式           \~english Destination pixel format
	unsigned char* pDstBuffer;                             ///< [OUT] \~chinese 输出数据缓存           \~english Output data buffer
	unsigned int            nDstLen;                                ///< [OUT] \~chinese 输出数据长度           \~english Output data length
	unsigned int            nDstBufferSize;                         ///< [IN]  \~chinese 提供的输出缓冲区大小   \~english Provided output buffer size

	unsigned int            nRes[4];                                ///<       \~chinese 预留                   \~english Reserved

}MV_CC_PIXEL_CONVERT_PARAM;

/****************************************************************funcs**********************************************************************************************/
//
typedef void(__stdcall* callback_onFrame)(unsigned char* pData, MV_FRAME_OUT_INFO_EX* pFrameInfo, void* pUser);
typedef void(__stdcall* callback_onFrame2)(unsigned char* pData, MV_FRAME_OUT_INFO_EX* pFrameInfo, void* bgraData, void* pUser);
typedef void(__stdcall* callback_onException)(unsigned int nMsgType, void* pUser);

typedef int(__stdcall* func_MV_CC_EnumDevices)(IN unsigned int nTLayerType, IN OUT MV_CC_DEVICE_INFO_LIST* pstDevList);
typedef int(__stdcall* func_MV_CC_CreateHandle)(OUT void** handle, IN const MV_CC_DEVICE_INFO* pstDevInfo);
typedef int(__stdcall* func_MV_CC_OpenDevice)(IN void* handle, IN unsigned int nAccessMode, IN unsigned short nSwitchoverKey);

typedef int(__stdcall* func_MV_CC_RegisterImageCallBackEx)(void* handle, callback_onFrame cb, void* pUser);
typedef int(__stdcall* func_MV_CC_RegisterExceptionCallBack)(IN void* handle, callback_onException cb, void* pUser);

typedef int(__stdcall* func_MV_CC_StartGrabbing)(IN void* handle);
typedef int(__stdcall* func_MV_CC_StopGrabbing)(IN void* handle);
typedef int(__stdcall* func_MV_CC_CloseDevice)(IN void* handle);
typedef int(__stdcall* func_MV_CC_DestroyHandle)(IN void* handle);

typedef int(__stdcall* func_MV_CC_IsDeviceConnected)(IN void* handle);

//
typedef int(__stdcall* func_MV_CC_GetIntValueEx)(IN void* handle, IN const char* strKey, OUT MVCC_INTVALUE_EX* pstIntValue);
typedef int(__stdcall* func_MV_CC_SetIntValueEx)(IN void* handle, IN const char* strKey, IN int64_t nValue);

typedef int(__stdcall* func_MV_CC_GetFloatValue)(IN void* handle, IN const char* strKey, OUT MVCC_FLOATVALUE* pstFloatValue);
typedef int(__stdcall* func_MV_CC_SetFloatValue)(IN void* handle, IN const char* strKey, IN float fValue);

typedef int(__stdcall* func_MV_CC_GetStringValue)(IN void* handle, IN const char* strKey, OUT MVCC_STRINGVALUE* pstStringValue);
typedef int(__stdcall* func_MV_CC_SetStringValue)(IN void* handle, IN const char* strKey, IN const char* strValue);

typedef int(__stdcall* func_MV_CC_GetBoolValue)(IN void* handle, IN const char* strKey, OUT bool* pbValue);
typedef int(__stdcall* func_MV_CC_SetBoolValue)(IN void* handle, IN const char* strKey, IN bool bValue);

typedef int(__stdcall* func_MV_CC_GetEnumValue)(IN void* handle, IN const char* strKey, OUT MVCC_ENUMVALUE* pstEnumValue);
typedef int(__stdcall* func_MV_CC_SetEnumValue)(IN void* handle, IN const char* strKey, IN unsigned int nValue);

typedef int(__stdcall* func_MV_CC_SetCommandValue)(IN void* handle, IN const char* strKey);

//
typedef int(__stdcall* func_MV_CC_StartRecord)(IN void* handle, IN MV_CC_RECORD_PARAM* pstRecordParam);
typedef int(__stdcall* func_MV_CC_InputOneFrame)(IN void* handle, IN MV_CC_INPUT_FRAME_INFO* pstInputFrameInfo);
typedef int(__stdcall* func_MV_CC_StopRecord)(IN void* handle);

typedef int(__stdcall* func_MV_CC_ConvertPixelType)(IN void* handle, IN OUT MV_CC_PIXEL_CONVERT_PARAM* pstCvtParam);

#endif