#ifndef HKNET_H
#define HKNET_H

#include "HKNET_Types.h"
typedef void(__stdcall* HKSerialDataCallBack)(u8* data, u32 dataSize, void* userData);

enum HKDataType {
    //RealDataCallBack
    HKDataType_SYSHEAD = 1,
    HKDataType_STREAMDATA = 2,

    //DecCallback
    HKDataType_YV12 = 3,
    HKDataType_AUDIO8 = 100,
    HKDataType_AUDIO16 = 101,
};

struct HKFrame {
    u8* raw;
    s32 rawSize;
    s32 rawType;
    u8* bgra;
    u8* y;
};
typedef void(__stdcall* HKPreviewDataCallBack)(HKFrame* frame, void* userData);

struct HKPreviewInfo {
    /*
    if cb=nullptr, hk demux-decode-display-mux
    else custom demux-decode-display-mux
    */
    void* hwnd;
    void* userData;
    HKPreviewDataCallBack cb;

    //config
    u16 timeout;//ms, 1000-10000
    u8 cvtBGRA;
    u8 copyY;
    u8 pad[8];

    //output
    u16 width;
    u16 height;
};

struct _HKContext;
typedef struct _HKContext HKContext;
extern "C" {
	//
	SDK_API s32 hkStaticInit(const char* libDir);
	SDK_API void hkStaticFree();

	//
	SDK_API HKContext* hkCreate();
	SDK_API void hkFree(HKContext** pp);

	//
	SDK_API s32 hkLogin(HKContext* context, char* ip, char* username, char* password);
	SDK_API s32 hkLogout(HKContext* context);
    SDK_API NET_DVR_DEVICEINFO_V30* hkDeviceInfo(HKContext* context);

	//
	SDK_API s32 hkGetDVRConfig(HKContext* context, u32 cmd, s32 channel, void* outBuffer, u32 outBufferSize, u32* bytesReturned);
	SDK_API s32 hkSetDVRConfig(HKContext* context, u32 cmd, s32 channel, void* inBuffer, u32 inBufferSize);
    SDK_API s32 hkSTDXMLConfig(HKContext* context, NET_DVR_XML_CONFIG_INPUT* lpInputParam, NET_DVR_XML_CONFIG_OUTPUT* lpOutputParam);
    SDK_API s32 hkSaveJPG(HKContext* context, s32 channel, NET_DVR_JPEGPARA* param, char* fn);

	/*
	hkSerialStart(context, NULL, NULL) enable xptz
	*/
	SDK_API s32 hkSerialStart(HKContext* context, HKSerialDataCallBack cb, void* cbData);
	SDK_API s32 hkSerialStop(HKContext* context);
	SDK_API s32 hkSerialSend(HKContext* context, u8* data, u32 dataSize);
	SDK_API s32 hkSerialSendWaitRecv(HKContext* context, u8* req, u32 reqSize, u8* resp, u32& respSize, s32 timeout);
    SDK_API s32 hkPtzControl(HKContext* context, s32 act, s32 arg);
    SDK_API s32 hkPtzControl_Stop(HKContext* context, s32 act, s32 arg);
    SDK_API s32 hkPtzControl_GetPtz(HKContext* context, s32& pan, s32& tilt, s32& zoom, s32 timeout);
    SDK_API s32 hkPtzControl_SetPtz(HKContext* context, s32 pan, s32 tilt, s32 zoom);

    /*
    */
    SDK_API s32 hkVoiceTalkStart(HKContext* context);
    SDK_API s32 hkVoiceTalkSetVolumn(HKContext* context, s32 volumn);
    SDK_API s32 hkVoiceTalkStop(HKContext* context);

    /*
    */
    SDK_API s32 hkPreviewStart(HKContext* context, HKPreviewInfo* previewInfo);
    SDK_API s32 hkPreviewStop(HKContext* context);
    SDK_API s32 hkPreviewBeginSave(HKContext* context, char* fn);
    SDK_API s32 hkPreviewEndSave(HKContext* context);
}

#endif
