#ifndef HKNET_TYPES_H
#define HKNET_TYPES_H

#include "../yc_type.h"

/*******************************************************************************************************
* 
*
*
*
********************************************************************************************************/
typedef unsigned long       DWORD;
typedef int                 BOOL;
typedef unsigned char       BYTE;
typedef BYTE* PBYTE;
typedef unsigned short      WORD;
typedef float               FLOAT;
typedef long                LONG;

#ifndef CALLBACK
#define CALLBACK    __stdcall
#endif

enum HKConsts {
    NAME_LEN = 32,
    SERIALNO_LEN = 48,
    DEV_TYPE_NAME_LEN = 24,
    InvalidChannel = -1,

    Ptz_LightPowerOn = 2,
    Ptz_WiperPowerOn = 3,
    Ptz_FanPowerOn = 4,
    Ptz_HeaterPowerOn = 5,

    Ptz_AuxPowerOn1 = 6,
    Ptz_AuxPowerOn2 = 7,

    Ptz_SetPreset = 8,
    Ptz_ClearPreset = 9,

    Ptz_ZoomIn = 11,
    Ptz_ZoomOut = 12,

    Ptz_FocusNear = 13,
    Ptz_FocusFar = 14,

    Ptz_IrisOpen = 15,
    Ptz_IrisClose = 16,

    Ptz_Up = 21,
    Ptz_Down = 22,
    Ptz_Left = 23,
    Ptz_Right = 24,

    Ptz_LeftUp = 25,
    Ptz_RightUp = 26,
    Ptz_LeftDown = 27,
    Ptz_RightDown = 28,

    Ptz_Auto = 29,
    Ptz_GotoPreset = 39,

    //
    Port = 8000,
    Size_SerialNumber = 48,

    //
    NET_DVR_SET_PTZPOS = 292,
    NET_DVR_GET_PTZPOS = 293,
    NET_DVR_GET_PTZSCOPE = 294,

    NET_DVR_GET_CCDPARAMCFG = 1067,
    NET_DVR_SET_CCDPARAMCFG = 1068,

    NET_DVR_GET_DEVICECFG_V40 = 1100,
    NET_DVR_SET_DEVICECFG_V40 = 1101,

    NET_DVR_GET_EXTERNALDEVICE = 3723,
    NET_DVR_GET_SUPPLEMENTLIGHT = 3728,

    NET_DVR_SET_EXTERNALDEVICE = 3724,
    NET_DVR_SET_SUPPLEMENTLIGHT = 3729,
};

typedef struct {
    BYTE sSerialNumber[SERIALNO_LEN];  //序列号
    BYTE byAlarmInPortNum;                //报警输入个数
    BYTE byAlarmOutPortNum;                //报警输出个数
    BYTE byDiskNum;                    //硬盘个数
    BYTE byDVRType;                    //设备类型, 1:DVR 2:ATM DVR 3:DVS ......
    BYTE byChanNum;                    //模拟通道个数
    BYTE byStartChan;                    //起始通道号,例如DVS-1,DVR - 1
    BYTE byAudioChanNum;                //语音通道数
    BYTE byIPChanNum;                    //最大数字通道个数，低位  
    BYTE byZeroChanNum;            //零通道编码个数 //2010-01-16
    BYTE byMainProto;            //主码流传输协议类型 0-private, 1-rtsp,2-同时支持private和rtsp
    BYTE bySubProto;                //子码流传输协议类型0-private, 1-rtsp,2-同时支持private和rtsp
    BYTE bySupport;        //能力，位与结果为0表示不支持，1表示支持，
    //bySupport & 0x1, 表示是否支持智能搜索
    //bySupport & 0x2, 表示是否支持备份
    //bySupport & 0x4, 表示是否支持压缩参数能力获取
    //bySupport & 0x8, 表示是否支持多网卡
    //bySupport & 0x10, 表示支持远程SADP
    //bySupport & 0x20, 表示支持Raid卡功能
    //bySupport & 0x40, 表示支持IPSAN 目录查找
    //bySupport & 0x80, 表示支持rtp over rtsp
    BYTE bySupport1;        // 能力集扩充，位与结果为0表示不支持，1表示支持
    //bySupport1 & 0x1, 表示是否支持snmp v30
    //bySupport1 & 0x2, 支持区分回放和下载
    //bySupport1 & 0x4, 是否支持布防优先级    
    //bySupport1 & 0x8, 智能设备是否支持布防时间段扩展
    //bySupport1 & 0x10, 表示是否支持多磁盘数（超过33个）
    //bySupport1 & 0x20, 表示是否支持rtsp over http    
    //bySupport1 & 0x80, 表示是否支持车牌新报警信息2012-9-28, 且还表示是否支持NET_DVR_IPPARACFG_V40结构体
    BYTE bySupport2; /*能力，位与结果为0表示不支持，非0表示支持
                     bySupport2 & 0x1, 表示解码器是否支持通过URL取流解码
                     bySupport2 & 0x2,  表示支持FTPV40
                     bySupport2 & 0x4,  表示支持ANR
                     bySupport2 & 0x8,  表示支持CCD的通道参数配置
                     bySupport2 & 0x10,  表示支持布防报警回传信息（仅支持抓拍机报警 新老报警结构）
                     bySupport2 & 0x20,  表示是否支持单独获取设备状态子项
    bySupport2 & 0x40,  表示是否是码流加密设备*/
    WORD wDevType;              //设备型号
    BYTE bySupport3; //能力集扩展，位与结果为0表示不支持，1表示支持
    //bySupport3 & 0x1, 表示是否支持批量配置多码流参数
    // bySupport3 & 0x4 表示支持按组配置， 具体包含 通道图像参数、报警输入参数、IP报警输入、输出接入参数、
    // 用户参数、设备工作状态、JPEG抓图、定时和时间抓图、硬盘盘组管理 
    //bySupport3 & 0x8为1 表示支持使用TCP预览、UDP预览、多播预览中的"延时预览"字段来请求延时预览（后续都将使用这种方式请求延时预览）。而当bySupport3 & 0x8为0时，将使用 "私有延时预览"协议。
    //bySupport3 & 0x10 表示支持"获取报警主机主要状态（V40）"。
    //bySupport3 & 0x20 表示是否支持通过DDNS域名解析取流

    BYTE byMultiStreamProto;//是否支持多码流,按位表示,0-不支持,1-支持,bit1-码流3,bit2-码流4,bit7-主码流，bit-8子码流
    BYTE byStartDChan;        //起始数字通道号,0表示无效
    BYTE byStartDTalkChan;    //起始数字对讲通道号，区别于模拟对讲通道号，0表示无效
    BYTE byHighDChanNum;        //数字通道个数，高位
    BYTE bySupport4;        //能力集扩展，位与结果为0表示不支持，1表示支持
    //bySupport4 & 0x4表示是否支持拼控统一接口
    // bySupport4 & 0x80 支持设备上传中心报警使能。表示判断调用接口是 NET_DVR_PDC_RULE_CFG_V42还是 NET_DVR_PDC_RULE_CFG_V41
    BYTE byLanguageType;// 支持语种能力,按位表示,每一位0-不支持,1-支持  
    //  byLanguageType 等于0 表示 老设备
    //  byLanguageType & 0x1表示支持中文
    //  byLanguageType & 0x2表示支持英文
    BYTE byVoiceInChanNum;   //音频输入通道数 
    BYTE byStartVoiceInChanNo; //音频输入起始通道号 0表示无效
    BYTE  bySupport5;  //按位表示,0-不支持,1-支持,bit0-支持多码流
    //bySupport5 &0x01表示支持wEventTypeEx ,兼容dwEventType 的事件类型（支持行为事件扩展）--先占住，防止冲突
    //bySupport5 &0x04表示是否支持使用扩展的场景模式接口
    /*
       bySupport5 &0x08 设备返回该值表示是否支持计划录像类型V40接口协议(DVR_SET_RECORDCFG_V40/ DVR_GET_RECORDCFG_V40)(在该协议中设备支持类型类型13的配置)
       之前的部分发布的设备，支持录像类型13，则配置录像类型13。如果不支持，统一转换成录像类型3兼容处理。SDK通过命令探测处理)
    */
    BYTE  bySupport6;   //能力，按位表示，0-不支持,1-支持
    //bySupport6 0x1  表示设备是否支持压缩 
    //bySupport6 0x2 表示是否支持流ID方式配置流来源扩展命令，DVR_SET_STREAM_SRC_INFO_V40
    //bySupport6 0x4 表示是否支持事件搜索V40接口
    //bySupport6 0x8 表示是否支持扩展智能侦测配置命令
    //bySupport6 0x40表示图片查询结果V40扩展
    BYTE  byMirrorChanNum;    //镜像通道个数，<录播主机中用于表示导播通道>
    WORD wStartMirrorChanNo;  //起始镜像通道号
    BYTE bySupport7;   //能力,按位表示,0-不支持,1-支持
    // bySupport7 & 0x1  表示设备是否支持 INTER_VCA_RULECFG_V42 扩展
    // bySupport7 & 0x2  表示设备是否支持 IPC HVT 模式扩展
    // bySupport7 & 0x04  表示设备是否支持 返回锁定时间
    // bySupport7 & 0x08  表示设置云台PTZ位置时，是否支持带通道号
    // bySupport7 & 0x10  表示设备是否支持双系统升级备份
    // bySupport7 & 0x20  表示设备是否支持 OSD字符叠加 V50
    // bySupport7 & 0x40  表示设备是否支持 主从跟踪（从摄像机）
    // bySupport7 & 0x80  表示设备是否支持 报文加密
    BYTE  byRes2;        //保留
}NET_DVR_DEVICEINFO_V30, * LPNET_DVR_DEVICEINFO_V30;

typedef struct {
    DWORD    dwSize;     // 结构体大小
    BYTE     sDVRName[NAME_LEN];      // 设备名称 
    DWORD    dwDVRID;    // 设备ID号，用于遥控器，v1.4的设备号范围为(0~99), v1.5及以上版本的设备号为(1~255) 
    DWORD    dwRecycleRecord;   // 是否循环录像：0－不是，1－是
    BYTE     sSerialNumber[SERIALNO_LEN];    // 只读，不可修改）设备序列号
    DWORD    dwSoftwareVersion;    //（只读，不可修改）软件版本号：
    // dwSoftwareVersion V3.0以上版本支持的设备最高8位为主版本号，次高8位为次版本号，低16位为修复版本号，例如：0x05050000表示V5.5.0；
    // dwSoftwareVersion V3.0以下版本支持的设备高16位表示主版本，低16位表示次版本
    DWORD    dwSoftwareBuildDate;  // （只读，不可修改）软件生成日期，高16位表示年份（需要加2000），次8位表示月份，最后8位表示日期，例如：0x0011090e表示build20170914
    DWORD    dwDSPSoftwareVersion; // （只读，不可修改）DSP软件版本，高16位是主版本，低16位是次版本 
    DWORD    dwDSPSoftwareBuildDate; // （只读，不可修改）DSP软件生成日期，高16位表示年份（需要加2000），次8位表示月份，最后8位表示日期
    DWORD    dwPanelVersion;       // （只读，不可修改）前面板版本，高16位是主版本，低16位是次版本
    DWORD    dwHardwareVersion;    // （只读，不可修改）硬件版本，高16位是主版本，低16位是次版本
    BYTE     byAlarmInPortNum;     // （只读，不可修改）设备模拟报警输入个数
    BYTE     byAlarmOutPortNum;    // （只读，不可修改）设备模拟报警输出个数 
    BYTE     byRS232Num;           // （只读，不可修改）设备232串口个数 
    BYTE     byRS485Num;           // （只读，不可修改）设备485串口个数 
    BYTE     byNetworkPortNum;     // （只读，不可修改）网络口个数 
    BYTE     byDiskCtrlNum;        // （只读，不可修改）硬盘控制器个数 
    BYTE     byDiskNum;            // （只读，不可修改）硬盘个数 
    BYTE     byDVRType;            // （只读，不可修改）设备类型
    BYTE     byChanNum;            // （只读，不可修改）设备模拟通道个数 
    BYTE     byStartChan;          // （只读，不可修改）模拟通道的起始通道号 
    BYTE     byDecordChans;        // （只读，不可修改）设备解码路数 
    BYTE     byVGANum;             // （只读，不可修改）VGA口的个数 
    BYTE     byUSBNum;             // （只读，不可修改）USB口的个数 
    BYTE     byAuxoutNum;          // （只读，不可修改）辅口的个数 
    BYTE     byAudioNum;           // （只读，不可修改）语音口的个数 
    BYTE     byIPChanNum;          // （只读，不可修改）最大数字通道低8位，高8位见byHighIPChanNum 
    BYTE     byZeroChanNum;        // （只读，不可修改）零通道编码个数 
    BYTE     bySupport;            // （只读，不可修改）能力，位与结果为0表示不支持，1表示支持
    // bySupport & 0x1，表示是否支持智能搜索
    // bySupport & 0x2，表示是否支持备份
    // bySupport & 0x4，表示是否支持压缩参数能力获取
    // bySupport & 0x8，表示是否支持双网卡
    // bySupport & 0x10，表示支持远程SADP
    // bySupport & 0x20，表示支持Raid卡功能
    // bySupport & 0x40，表示支持IPSAN搜索
    // bySupport & 0x80，表示支持rtp over rtsp
    BYTE     byEsataUseage;        // Esata的默认用途，0-默认备份，1-默认录像 
    BYTE     byIPCPlug;            // 0-关闭即插即用，1-打开即插即用 
    BYTE     byStorageMode;        // 存储模式：0-盘组模式，1-磁盘配额，2-抽帧模式， 3-自动 
    BYTE     bySupport1;           // （只读，不可修改）能力集扩充，位与结果：0表示不支持，1表示支持
    // bySupport1 & 0x1, 表示是否支持snmp v30
    // bySupport1 & 0x2, 支持区分回放和下载
    WORD     wDevType;             // （只读，不可修改）设备型号，见下文列表 
    BYTE     byDevTypeName[DEV_TYPE_NAME_LEN];  // （只读，不可修改）设备型号名称 
    BYTE     bySupport2;           // （只读，不可修改）能力集扩充，位与结果：0表示不支持，1表示支持
    // bySupport2 & 0x1, 表示是否支持是否支持扩展的OSD字符叠加(终端和抓拍机扩展区分)
    BYTE     byAnalogAlarmInPortNum;// （只读，不可修改）模拟报警输入个数 
    BYTE     byStartAlarmInNo;     // （只读，不可修改）模拟报警输入起始号 
    BYTE     byStartAlarmOutNo;    // （只读，不可修改）模拟报警输出起始号 
    BYTE     byStartIPAlarmInNo;   // （只读，不可修改）IP报警输入起始号，0表示参数无效 
    BYTE     byStartIPAlarmOutNo;  // （只读，不可修改）IP报警输出起始号，0表示参数无效 
    BYTE     byHighIPChanNum;      // （只读，不可修改）最大数字通道高8位，低8位见byIPChanNum 
    BYTE     byEnableRemotePowerOn;// 是否启用在设备休眠的状态下远程开机功能：0- 不启用，1- 启用 
    WORD     wDevClass;            // 设备大类，判断设备是属于哪个产品线：0-保留，1~50表示DVR，51~100表示DVS，101~150表示NVR，151~200表示IPC，65534表示其他类型 
    BYTE     byRes2[6];
}NET_DVR_DEVICECFG_V40, * LPNET_DVR_DEVICECFG_V40;

//球机位置信息
typedef struct {
    WORD wAction;//获取时该字段无效
    WORD wPanPos;//水平参数
    WORD wTiltPos;//垂直参数
    WORD wZoomPos;//变倍参数
}NET_DVR_PTZPOS, * LPNET_DVR_PTZPOS;

typedef    struct    tagNET_DVR_STD_CONFIG {
    void* lpCondBuffer;        //[in]条件参数(结构体格式),例如通道号等.可以为NULL
    DWORD        dwCondSize;            //[in] lpCondBuffer指向的内存大小
    void* lpInBuffer;            //[in]输入参数(结构体格式),设置时不为NULL，获取时为NULL
    DWORD        dwInSize;            //[in] lpInBuffer指向的内存大小
    void* lpOutBuffer;        //[out]输出参数(结构体格式),获取时不为NULL,设置时为NULL
    DWORD        dwOutSize;            //[in] lpOutBuffer指向的内存大小
    void* lpStatusBuffer;        //[out]返回的状态参数(XML格式),获取成功时不会赋值,如果不需要,可以置NULL
    DWORD        dwStatusSize;        //[in] lpStatusBuffer指向的内存大小
    void* lpXmlBuffer;    //[in/out]byDataType = 1时有效,xml格式数据
    DWORD       dwXmlSize;      //[in/out]lpXmlBuffer指向的内存大小,获取时同时作为输入和输出参数，获取成功后会修改会实际长度，设置时表示实际长度，而不是整个内存大小
    BYTE        byDataType;     //[in]输入/输出参数类型,0-使用结构体类型lpInBuffer/lpOutBuffer有效,1-使用XML类型lpXmlBuffer有效
    BYTE        byRes[23];
}NET_DVR_STD_CONFIG, * LPNET_DVR_STD_CONFIG;

//视频参数配置
typedef struct tagNET_DVR_VIDEOEFFECT {
    BYTE byBrightnessLevel; /*0-100*/
    BYTE byContrastLevel; /*0-100*/
    BYTE bySharpnessLevel; /*0-100*/
    BYTE bySaturationLevel; /*0-100*/
    BYTE byHueLevel; /*0-100,（保留）*/
    BYTE byEnableFunc; //使能，按位表示，bit0-SMART IR(防过曝)，bit1-低照度,bit2-强光抑制使能，0-否，1-是
    BYTE byLightInhibitLevel; //强光抑制等级，[1-3]表示等级
    BYTE byGrayLevel; //灰度值域，0-[0-255]，1-[16-235]
}NET_DVR_VIDEOEFFECT, * LPNET_DVR_VIDEOEFFECT;

//增益配置
typedef struct tagNET_DVR_GAIN {
    BYTE byGainLevel; /*增益：0-100*/
    BYTE byGainUserSet; /*用户自定义增益；0-100，对于抓拍机，是CCD模式下的抓拍增益*/
    BYTE byRes[2];
    DWORD dwMaxGainValue;/*最大增益值，单位dB*/
}NET_DVR_GAIN, * LPNET_DVR_GAIN;

//白平衡配置
typedef struct tagNET_DVR_WHITEBALANCE {
    BYTE byWhiteBalanceMode; /*0-手动白平衡（MWB）,1-自动白平衡1（AWB1）,2-自动白平衡2 (AWB2),3-自动控制改名为锁定白平衡(Locked WB)，
                             4-室外(Indoor)，5-室内(Outdoor)6-日光灯(Fluorescent Lamp)，7-钠灯(Sodium Lamp)，
                             8-自动跟踪(Auto-Track)9-一次白平衡(One Push)，10-室外自动(Auto-Outdoor)，
                             11-钠灯自动 (Auto-Sodiumlight)，12-水银灯(Mercury Lamp)，13-自动白平衡(Auto)，
    14-白炽灯 (IncandescentLamp)，15-暖光灯(Warm Light Lamp)，16-自然光(Natural Light) */
    BYTE byWhiteBalanceModeRGain; /*手动白平衡时有效，手动白平衡 R增益*/
    BYTE byWhiteBalanceModeBGain; /*手动白平衡时有效，手动白平衡 B增益*/
    BYTE byRes[5];
}NET_DVR_WHITEBALANCE, * LPNET_DVR_WHITEBALANCE;

//曝光控制
typedef struct tagNET_DVR_EXPOSURE {
    BYTE  byExposureMode; /*0 手动曝光 1自动曝光*/
    BYTE  byAutoApertureLevel; /* 自动光圈灵敏度, 0-10 */
    BYTE  byRes[2];
    DWORD dwVideoExposureSet; /* 自定义视频曝光时间（单位us）*//*注:自动曝光时该值为曝光最慢值 新增20-1s(1000000us)*/
    DWORD dwExposureUserSet; /* 自定义曝光时间,在抓拍机上应用时，CCD模式时是抓拍快门速度*/
    DWORD dwRes;
} NET_DVR_EXPOSURE, * LPNET_DVR_EXPOSURE;

//宽动态配置
typedef struct tagNET_DVR_WDR {
    BYTE byWDREnabled; /*宽动态：0 dsibale  1 enable 2 auto*/
    BYTE byWDRLevel1; /*0-F*/
    BYTE byWDRLevel2; /*0-F*/
    BYTE byWDRContrastLevel; /*0-100*/
    BYTE byRes[16];
} NET_DVR_WDR, * LPNET_DVR_WDR;

typedef struct tagNET_DVR_WDR_CFG {
    DWORD  dwSize;   //结构体大小
    NET_DVR_WDR  struWDR; //配置信息
}NET_DVR_WDR_CFG, * LPNET_DVR_WDR_CFG;

//日夜转换功能配置
typedef struct tagNET_DVR_DAYNIGHT {
    BYTE byDayNightFilterType; /*日夜切换：0-白天，1-夜晚，2-自动，3-定时，4-报警输入触发, 5-自动模式2（无光敏）,6-黑光，7-黑光自动，8-黑光定时*/
    BYTE bySwitchScheduleEnabled; /*0 dsibale  1 enable,(保留)*/
    //定时模式参数
    BYTE byBeginTime; /*开始时间（小时），0-23*/
    BYTE byEndTime; /*结束时间（小时），0-23*/
    //模式2
    BYTE byDayToNightFilterLevel; //0-7
    BYTE byNightToDayFilterLevel; //0-7
    BYTE byDayNightFilterTime;//(60秒)
    //定时模式参数
    BYTE byBeginTimeMin; //开始时间（分），0-59
    BYTE byBeginTimeSec; //开始时间（秒），0-59
    BYTE byEndTimeMin; //结束时间（分），0-59
    BYTE byEndTimeSec; //结束时间（秒），0-59
    //报警输入触发模式参数
    BYTE byAlarmTrigState; //报警输入触发状态，0-白天，1-夜晚
} NET_DVR_DAYNIGHT, * LPNET_DVR_DAYNIGHT;

//Gamma校正
typedef struct tagNET_DVR_GAMMACORRECT {
    BYTE byGammaCorrectionEnabled; /*0 dsibale  1 enable*/
    BYTE byGammaCorrectionLevel; /*0-100*/
    BYTE byRes[6];
} NET_DVR_GAMMACORRECT, * LPNET_DVR_GAMMACORRECT;

//背光补偿配置
typedef struct tagNET_DVR_BACKLIGHT {
    BYTE byBacklightMode; /*背光补偿:0 off 1 UP、2 DOWN、3 LEFT、4 RIGHT、5MIDDLE、6自定义，10-开，11-自动，12-多区域背光补偿*/
    BYTE byBacklightLevel; /*0x0-0xF*/
    BYTE byRes1[2];
    DWORD dwPositionX1; //（X坐标1）
    DWORD dwPositionY1; //（Y坐标1）
    DWORD dwPositionX2; //（X坐标2）
    DWORD dwPositionY2; //（Y坐标2）
    BYTE byRes2[4];
} NET_DVR_BACKLIGHT, * LPNET_DVR_BACKLIGHT;

//数字降噪功能
typedef struct tagNET_DVR_NOISEREMOVE {
    BYTE byDigitalNoiseRemoveEnable; /*0-不启用，1-普通模式数字降噪，2-专家模式数字降噪*/
    BYTE byDigitalNoiseRemoveLevel; /*普通模式数字降噪级别：0x0-0xF*/
    BYTE bySpectralLevel;       /*专家模式下空域强度：0-100*/
    BYTE byTemporalLevel;   /*专家模式下时域强度：0-100*/
    BYTE byDigitalNoiseRemove2DEnable;         /* 抓拍帧2D降噪，0-不启用，1-启用 */
    BYTE byDigitalNoiseRemove2DLevel;            /* 抓拍帧2D降噪级别，0-100 */
    BYTE byRes[2];
} NET_DVR_NOISEREMOVE, * LPNET_DVR_NOISEREMOVE;

//CMOS模式下前端镜头配置
typedef struct tagNET_DVR_CMOSMODCFG {
    BYTE byCaptureMod;   //抓拍模式：0-抓拍模式1；1-抓拍模式2
    BYTE byBrightnessGate;//亮度阈值
    BYTE byCaptureGain1;   //抓拍增益1,0-100
    BYTE byCaptureGain2;   //抓拍增益2,0-100
    DWORD dwCaptureShutterSpeed1;//抓拍快门速度1
    DWORD dwCaptureShutterSpeed2;//抓拍快门速度2
    BYTE  byRes[4];
}NET_DVR_CMOSMODECFG, * LPNET_DVR_CMOSMODECFG;

//前端参数配置
typedef struct tagNET_DVR_CAMERAPARAMCFG {
    DWORD dwSize;
    NET_DVR_VIDEOEFFECT struVideoEffect; //亮度、对比度、饱和度、锐度、色调配置
    NET_DVR_GAIN struGain; //自动增益
    NET_DVR_WHITEBALANCE struWhiteBalance; //白平衡
    NET_DVR_EXPOSURE struExposure; //曝光控制
    NET_DVR_GAMMACORRECT struGammaCorrect; //Gamma校正
    NET_DVR_WDR struWdr; //宽动态
    NET_DVR_DAYNIGHT struDayNight; //日夜转换
    NET_DVR_BACKLIGHT struBackLight; //背光补偿
    NET_DVR_NOISEREMOVE struNoiseRemove; //数字降噪
    BYTE byPowerLineFrequencyMode; //0-50HZ; 1-60HZ
    /*
        0-自动光圈,
        1-手动光圈,
        2-P-Iris1,
        3-Union 3-9mm F1.6-2.7 (T5280-PQ1) [IPC5.1.7]
        4-Union 2.8-12mm F1.6-2.7 (T5289-PQ1) [IPC5.1.7]
        5-HIK 3.8-16mm F1.5（HV3816P-8MPIR)
        6-HIK 11-40mm F1.7 (HV1140P-8MPIR)
        7-HIK 2.7-12mm F1.2（TV2712P-MPIR）
        8- MZ5721D-12MPIR
        9- MZ1555D-12MPIR
        10- MZ5721D-12MPIR(RS485)
        11- MZ1555D-12MPIR(RS485)
    */
    BYTE byIrisMode;
    BYTE byMirror;  /* 镜像：0 off，1- leftright，2- updown，3-center */
    BYTE byDigitalZoom;  /*数字缩放:0 dsibale  1 enable*/
    BYTE byDeadPixelDetect;   /*坏点检测,0 dsibale  1 enable*/
    BYTE byBlackPwl;/*黑电平补偿 ,  0-255*/
    BYTE byEptzGate;// EPTZ开关变量:0-不启用电子云台，1-启用电子云台
    BYTE byLocalOutputGate;//本地输出开关变量0-本地输出关闭1-本地BNC输出打开 2-HDMI输出关闭  
    //20-HDMI_720P50输出开
    //21-HDMI_720P60输出开
    //22-HDMI_1080I60输出开
    //23-HDMI_1080I50输出开
    //24-HDMI_1080P24输出开
    //25-HDMI_1080P25输出开
    //26-HDMI_1080P30输出开
    //27-HDMI_1080P50输出开
    //28-HDMI_1080P60输出开
    //40-SDI_720P50,
    //41-SDI_720P60,
    //42-SDI_1080I50,
    //43-SDI_1080I60,
    //44-SDI_1080P24,
    //45-SDI_1080P25,
    //46-SDI_1080P30,
    //47-SDI_1080P50,
    //48-SDI_1080P60
    BYTE byCoderOutputMode;//编码器fpga输出模式0直通3像素搬家
    BYTE byLineCoding; //是否开启行编码：0-否，1-是
    BYTE byDimmerMode; //调光模式：0-半自动，1-自动
    BYTE byPaletteMode; //调色板：0-白热，1-黑热，2-调色板2，…，8-调色板8
    BYTE byEnhancedMode; //增强方式（探测物体周边）：0-不增强，1-1，2-2，3-3，4-4
    BYTE byDynamicContrastEN;    //动态对比度增强 0-1
    BYTE byDynamicContrast;    //动态对比度 0-100
    BYTE byJPEGQuality;    //JPEG图像质量 0-100
    NET_DVR_CMOSMODECFG struCmosModeCfg;//CMOS模式下前端参数配置，镜头模式从能力集获取
    BYTE byFilterSwitch; //滤波开关：0-不启用，1-启用
    BYTE byFocusSpeed; //镜头调焦速度：0-10
    BYTE byAutoCompensationInterval; //定时自动快门补偿：1-120，单位：分钟
    BYTE bySceneMode;  //场景模式：0-室外，1-室内，2-默认，3-弱光
}NET_DVR_CAMERAPARAMCFG, * LPNET_DVR_CAMERAPARAMCFG;

//透明通道
typedef struct tagNET_DVR_SERIALSTART_V40 {
    DWORD  dwSize;         //结构体大小
    DWORD  dwSerialType;    //串口号（1-232串口，2-485串口）
    BYTE   bySerialNum;   //串口编号
    BYTE   byRes[255];
}NET_DVR_SERIALSTART_V40, * LPNET_DVR_SERIALSTART_V40;

//
typedef struct tagNET_DVR_XML_CONFIG_INPUT {
    DWORD   dwSize;                     //结构体大小
    void* lpRequestUrl;               //请求信令，字符串格式
    DWORD   dwRequestUrlLen;            //请求信令长度，字符串长度
    void* lpInBuffer;                 //输入参数缓冲区，XML格式
    DWORD   dwInBufferSize;             //输入参数缓冲区大小
    DWORD   dwRecvTimeOut;              //接收超时时间，单位：ms，填0则使用默认超时5s
    BYTE    byForceEncrpt;              //是否强制加密，0-否，1-是
    BYTE    byNumOfMultiPart;           //0-无效，其他值表示报文分段个数，非零时lpInBuffer传入的是NET_DVR_MIME_UNIT结构体数组的指针，该值即代表结构体个数
    BYTE    byRes[30];
}NET_DVR_XML_CONFIG_INPUT, * LPNET_DVR_XML_CONFIG_INPUT;

typedef struct tagNET_DVR_XML_CONFIG_OUTPUT {
    DWORD   dwSize;                        //结构体大小
    void* lpOutBuffer;                //输出参数缓冲区，XML格式
    DWORD    dwOutBufferSize;            //输出参数缓冲区大小(内存大小)
    DWORD   dwReturnedXMLSize;            //实际输出的XML内容大小
    void* lpStatusBuffer;                //返回的状态参数(XML格式),获取命令成功时不会赋值,如果不需要,可以置NULL
    DWORD    dwStatusSize;                //状态缓冲区大小(内存大小)
    BYTE    byRes[32];
}NET_DVR_XML_CONFIG_OUTPUT, * LPNET_DVR_XML_CONFIG_OUTPUT;

//图片质量
typedef struct{
    /*注意：当图像压缩分辨率为VGA时，支持0=CIF, 1=QCIF, 2=D1抓图，
    当分辨率为3=UXGA(1600x1200), 4=SVGA(800x600), 5=HD720p(1280x720),6=VGA,7=XVGA, 8=HD900p
        仅支持当前分辨率的抓图*/

        /* 可以通过能力集获取
           0-CIF，           1-QCIF，           2-D1，         3-UXGA(1600x1200), 4-SVGA(800x600),5-HD720p(1280x720)，
           6-VGA，           7-XVGA，           8-HD900p，     9-HD1080，     10-2560*1920，
           11-1600*304，     12-2048*1536，     13-2448*2048,  14-2448*1200， 15-2448*800，
           16-XGA(1024*768), 17-SXGA(1280*1024),18-WD1(960*576/960*480),      19-1080i,      20-576*576，
           21-1536*1536,     22-1920*1920,      23-320*240,    24-720*720,    25-1024*768,
           26-1280*1280,     27-1600*600,       28-2048*768,   29-160*120,    55-3072*2048,
           64-3840*2160,     70-2560*1440,      75-336*256,
           78-384*256,         79-384*216,        80-320*256,    82-320*192,    83-512*384,
           127-480*272,      128-512*272,       161-288*320,   162-144*176,   163-480*640,
           164-240*320,      165-120*160,       166-576*720,   167-720*1280,  168-576*960,
           180-180*240,      181-360*480,       182-540*720,    183-720*960,  184-960*1280,
           185-1080*1440,      215-1080*720(占位，未测试),  216-360x640(占位，未测试),245-576*704(占位，未测试)
           500-384*288,
           0xff-Auto(使用当前码流分辨率)
        */
    WORD    wPicSize;
    WORD    wPicQuality;            /* 图片质量系数 0-最好 1-较好 2-一般 */
}NET_DVR_JPEGPARA, * LPNET_DVR_JPEGPARA;

//软解码预览参数
typedef struct
{
    LONG lChannel;//通道号
    LONG lLinkMode;//最高位(31)为0表示主码流，为1表示子，0－30位表示码流连接方式: 0：TCP方式,1：UDP方式,2：多播方式,3 - RTP方式，4-RTP/RTSP,5-RSTP/HTTP 
    void* hPlayWnd;//播放窗口的句柄,为NULL表示不播放图象
    char* sMultiCastIP;//多播组地址
    BYTE byProtoType; //应用层取流协议，0-私有协议，1-RTSP协议
    BYTE byRes[3];
}NET_DVR_CLIENTINFO, * LPNET_DVR_CLIENTINFO;

/*******************************************************************************************************
*
*
*
*
********************************************************************************************************/
typedef s32(__stdcall* func_NET_DVR_Init)();
typedef s32(__stdcall* func_NET_DVR_Cleanup)();
typedef s32(__stdcall* func_NET_DVR_GetLastError)();

//
typedef s32(__stdcall* func_NET_DVR_Login_V30)(char* sDVRIP, WORD wDVRPort, char* sUserName, char* sPassword, NET_DVR_DEVICEINFO_V30* lpDeviceInfo);
typedef s32(__stdcall* func_NET_DVR_Logout)(int iUserID);

//
typedef s32(__stdcall* func_NET_DVR_GetDVRConfig)(int lUserID, u32 dwCommand, int lChannel, void* lpOutBuffer, u32 dwOutBufferSize, u32* lpBytesReturned);
typedef s32(__stdcall* func_NET_DVR_SetDVRConfig)(int lUserID, u32 dwCommand, int lChannel, void* lpInBuffer, u32 dwInBufferSize);
typedef s32(__stdcall* func_NET_DVR_GetSTDConfig)(int iUserID, u32 dwCommand, NET_DVR_STD_CONFIG* lpConfigParam);
typedef s32(__stdcall* func_NET_DVR_SetSTDConfig)(int iUserID, u32 dwCommand, NET_DVR_STD_CONFIG* lpConfigParam);
typedef s32(__stdcall* func_NET_DVR_STDXMLConfig)(int lUserID, NET_DVR_XML_CONFIG_INPUT* lpInputParam, NET_DVR_XML_CONFIG_OUTPUT* lpOutputParam);

//
typedef s32(__stdcall* func_NET_DVR_CaptureJPEGPicture)(int lUserID, int lChannel, LPNET_DVR_JPEGPARA lpJpegPara, char* sPicFileName);

//
typedef s32(__stdcall* func_NET_DVR_PTZControl_Other)(s32 lUserID, s32 lChannel, u32 dwPTZCommand, u32 dwStop);
typedef s32(__stdcall* func_NET_DVR_PTZControlWithSpeed_Other)(int lUserID, int lChannel, u32 dwPTZCommand, u32 dwStop, u32 dwSpeed);
typedef s32(__stdcall* func_NET_DVR_PTZPreset_Other)(int lUserID, int lChannel, u32 dwPTZPresetCmd, u32 dwPresetIndex);

//
typedef void(__stdcall* func_SerialDataCallBack)(s32 lSerialHandle, s32 lChannel, char* pRecvDataBuffer, u32 dwBufSize, void* pUser);
typedef s32(__stdcall* func_NET_DVR_SerialStart_V40)(s32 lUserID, void* lpInBuffer, s32 dwInBufferSize, func_SerialDataCallBack cbSerialDataCallBack, void* pUser);
typedef s32(__stdcall* func_NET_DVR_SerialStop)(s32 lSerialHandle);
typedef s32(__stdcall* func_NET_DVR_SerialSend)(s32 lSerialHandle, s32 lChannel, char* pSendBuf, u32 dwBufSize);

//
typedef void(__stdcall* func_VoiceDataCallBack)(int lVoiceComHandle, char* pRecvDataBuffer, int dwBufSize, u8 byAudioFlag, void* pUser);
typedef s32(__stdcall* func_NET_DVR_StartVoiceCom_V30)(int lUserID, int dwVoiceChan, int bNeedCBNoEncData, func_VoiceDataCallBack cb, void* pUser);
typedef s32(__stdcall* func_NET_DVR_SetVoiceComClientVolume)(int lVoiceComHandle, s16 wVolume);
typedef s32(__stdcall* func_NET_DVR_StopVoiceCom)(int lVoiceComHandle);

//
typedef void(CALLBACK* func_RealDataCallBack)(LONG lRealHandle, DWORD dwDataType, BYTE* pBuffer, DWORD dwBufSize, void* pUser);
typedef s32(__stdcall* func_NET_DVR_RealPlay_V30)(LONG lUserID, LPNET_DVR_CLIENTINFO lpClientInfo, func_RealDataCallBack cb, void* pUser, BOOL bBlocked);
typedef s32(__stdcall* func_NET_DVR_StopRealPlay)(LONG lRealHandle);
typedef s32(__stdcall* func_NET_DVR_SaveRealData)(LONG lRealHandle, char* sFileName);
typedef s32(__stdcall* func_NET_DVR_StopSaveRealData)(LONG lRealHandle);
typedef s32(__stdcall* func_NET_DVR_CapturePicture)(LONG lRealHandle, char* sPicFileName);
typedef s32(__stdcall* func_NET_DVR_SetCapturePictureMode)(DWORD dwCaptureMode);

#endif