/*******************************************************************************************************
*
*
*
*
********************************************************************************************************/
#ifndef YOSEENALG_FILTER_H_
#define YOSEENALG_FILTER_H_

#include <yc_type.h>

/*******************************************************************************************************
*
*
*
*
********************************************************************************************************/
struct _MeanContext;
typedef struct _MeanContext MeanContext;
struct _MedianContext;
typedef struct _MedianContext MedianContext;
extern "C" {
    //
    SDK_API MeanContext* Alg_MeanCreate();
    SDK_API void Alg_MeanFree(MeanContext** pp);
    SDK_API s32 Alg_MeanExecute(MeanContext* context, s32 winSize, u16 srcWidth, u16 srcHeight, s16* srcData, s16* dstData);

    //
    SDK_API MedianContext* Alg_MedianCreate();
    SDK_API void Alg_MedianFree(MedianContext** pp);
    SDK_API void Alg_MedianExecute(MedianContext* context, s32 width, s32 height, s16* data);
}

/*******************************************************************************************************
*
*
*
*
********************************************************************************************************/
enum IRDestripType {
    IRDestripType_None  =   0,
    IRDestripType_ColV1,
    IRDestripType_ColV1opt,
    IRDestripType_ColV2
};
struct IRDestripConfig {
    u16 type;
    u16 width;
    u16 height;

    //
    u16 s0_radius;
    u16 s0_regular;
    u16 s1_radius;
    u16 s1_regular;

    //
    u8 sub_y;
    u8 sub_t;

    //
    u8 pad[16];
};
//
inline u16 IRDestrip_SelectType(u16 type) {
    if (type) {
#if defined(__arm__)
        type = IRDestripType_ColV1opt;
#elif defined(__aarch64__)
        type = IRDestripType_ColV1;
#else
#endif
    }
    return type;
}

//
struct _IRDestripContext;
typedef struct _IRDestripContext IRDestripContext;
extern "C" {
    SDK_API IRDestripContext* IRDestrip_Create();
    SDK_API void IRDestrip_Free(IRDestripContext** pp);

    SDK_API s32 IRDestrip_SetConfig(IRDestripContext* context, IRDestripConfig* config);
    SDK_API s32 IRDestrip_Execute(IRDestripContext* context, s16* temp, u16 width, u16 height, s32 isStream);
}

#endif