/*******************************************************************************************************
*
*
*
*
********************************************************************************************************/
#ifndef YOSEENALG_STRECH_H_
#define YOSEENALG_STRECH_H_

#include "YoseenDeviceTypes.h"

enum StrechControlFlags {
    //2019
    SCF_StrechType = 0x0001,	///< 
    SCF_PHEGain = 0x0008,		///<
    SCF_Temp2Gray = 0x0010,     ///<
    SCF_PHEStream = 0x0020,		///< 
    SCF_DDELevel = 0x0040,		///< 

    //2020
    SCF_ColorTemp = 0x0080,		///< 

    //20210604
    SCF_ManEnable = 0x0100,
    SCF_ManTemp0 = 0x0200,
    SCF_ManTemp1 = 0x0400,

    //
    SCF_FrameAll = (SCF_StrechType | SCF_PHEGain | SCF_Temp2Gray | SCF_DDELevel | SCF_ColorTemp | SCF_ManEnable | SCF_ManTemp0 | SCF_ManTemp1)
};

/**
*/
enum StrechType {
    StrechType_PHE = 1,			///< PHE
    StrechType_LINEAR,			///< LINEAR
};

/*

*/
enum ColorTempType {
    ColorTempType_None,			///< 
    ColorTempType_High,			///<  
    ColorTempType_Low,			///< 
    ColorTempType_Mid,			///< 
    ColorTempType_ExMid,		///< 
};

/**

*/
typedef struct _strech_control {
    s32 flags;						///< 

    //
    u8 strech_type;					///< 
    u8 contrast;					///< 
    u8 brightness;					///< 
    u8 phe_stream;					///< 
    float phe_gain;					///< 

    //man
    s16 man_temp0;
    s16 man_temp1;
    u8 man_enable;
    u8 temp2gray;					///< 0, 10-50

    //dde
    u8	dde_level;					///< 

    //ct
    u8 ct_type;						///< 
    s16 ct_temp0;					///< 
    s16 ct_temp1;					///< 
    s32 ct_color0;					///< 
    s32 ct_color1;					///< 

    //20241021
    u8 reserved[32];
}strech_control;

//
struct _strech_context;
typedef struct _strech_context strech_context;
extern "C" {
    SDK_API		strech_context* strCreate();
    SDK_API		void strFree(strech_context* context);
    SDK_API		void strTemp2Bgra(strech_context* context, const s16* dfd, const DataFrameHeader* dfh, bgra* bmp, const bgra* palette);
    SDK_API		void strTemp2Gray(strech_context* context, const s16* dfd, const DataFrameHeader* dfh, u8* bmp);
    SDK_API		void strTemp2Yuv(strech_context* context, const s16* dfd, const DataFrameHeader* dfh, u8* yData, u8* uData, u8* vData, const yuvx* paletteData);

    SDK_API		s32 strSetCtl(strech_context* context, const strech_control* control);
    SDK_API		void strGetCtl(strech_context* context, strech_control* control);

    SDK_API		void strHist(strech_context* context, float* bin, s32 bins, s16 start, s16 end);
    SDK_API		void strHist2(float* bin, s32 bins, u8* bmp, s32 width, s32 height);
}

s32 strSetCtl_Internal(strech_context* context, const strech_control* control);

#endif