package Test;

import Yoseen.YoseenData;
import Yoseen.YoseenSDK;
import Yoseen.YoseenUtil;

/**********************************************************************************************
 *
 * TestYoseenDevice_PTZ
 *
 *
 **********************************************************************************************/
public class TestYoseenDevice_PTZ {
    public static void main(String[] args) {
        String dddDebug = System.getProperty("user.dir") + "\\..\\build-Debug64";
        int ret;

        //init sdk
        ret = YoseenSDK.YoseenDevice.initSDK();
        YoseenSDK.YoseenDevice device = new YoseenSDK.YoseenDevice();

        //login
        ret = device.login("192.168.1.205");

        //B160-设置补光灯亮度，arg参数形如：00a000xx，xx取值范围：十六进制(0-64)，指十进制(0-100)
        String reqStr = "00a00000";
        byte[] respBytes = new byte[4];
        device.ptzControl_B160_W4R4(reqStr, respBytes);
        System.out.println("reqStr = " + reqStr);
        System.out.println("respStr = " + YoseenUtil.bytes2HexStr(respBytes));


        //move
//        ret = device.ptzControl(YoseenData.PtzAction_MoveLeft, 100);
//        ret = device.ptzControl_Stop(YoseenData.PtzAction_MoveLeft, 100);

        //get ptz
        int[] ptz = new int[3];
        ret = device.ptzControl_GetPtz(ptz, 1000);

        System.out.println("ptz[0] = " + ptz[0]);
        System.out.println("ptz[1] = " + ptz[1]);
        System.out.println("ptz[2] = " + ptz[2]);

        //set ptz
//        ret = device.ptzControl_SetPtz(ptz, 100);

        //logout
        device.logout();

        //free sdk
        YoseenSDK.YoseenDevice.freeSDK();
    }
}
