package Yoseen;

import com.sun.jna.Library;
import com.sun.jna.Native;
import sun.misc.Unsafe;

public class HKISAPIDevice {
    //
    static final int HKISAPIBinType_ZoomFocus = 0;
    static final int HKISAPIBinType_Color = 1;
    static final int HKISAPIBinType_Exposure = 2;
    static final int HKISAPIBinType_Iris = 3;
    static final int HKISAPIBinType_FocusConfiguration = 4;
    static final int HKISAPIBinType_SupplementLight = 5;

    //
    Unsafe _unsafe;
    long _hkisapi;
    long _mem;
    LibHK.HKISAPIConfig _config;

    public HKISAPIDevice() {
        _unsafe = LibHK.LibHKclass.__unsafe;
        _config = new LibHK.HKISAPIConfig();
        _hkisapi = 0;
        _mem = 0;
    }

    public int init() {
        if (0 != _hkisapi) return 0;
        _hkisapi = LibHK.Instance.hkisapiCreate();
        _mem = _unsafe.allocateMemory(1024 * 1024);
        return 0;
    }

    public void free() {
        if (0 == _hkisapi) return;
        _unsafe.putLong(_mem, _hkisapi);
        LibHK.Instance.hkisapiFree(_mem);
        _unsafe.freeMemory(_mem);
        _hkisapi = 0;
        _mem = 0;
    }

    public int setDeviceConfig(String url, String username, String password, int timeout) {
        if (0 == _hkisapi) return EError.EError_InvalidState;
        int ret;
        _config.url_str = url;
        _config.username_str = username;
        _config.password_str = password;
        _config.timeout = (short) timeout;
        _config.toMem(_mem);
        ret = LibHK.Instance.hkisapiSetConfig(_hkisapi, _mem);
        return ret;
    }

    //
    void initReq(int type, int mode) {
        long p = _mem;
        _unsafe.putInt(p, type);
        p += 4;
        _unsafe.putInt(p, mode);
        p += 4;
        _unsafe.putInt(p, 0);
        p += 4;
        _unsafe.putInt(p, 0);
    }

    //
    public int get_ZoomFocus(LibHK.HKISAPI_ZoomFocus x) {
        if (0 == _hkisapi) return EError.EError_InvalidState;

        int ret;
        initReq(HKISAPIBinType_ZoomFocus, 0);
        ret = LibHK.Instance.hkisapiExecuteBin(_hkisapi, _mem);
        x.fromMem(_mem + 16 + 1024);
        return ret;
    }

    public int set_ZoomFocus(LibHK.HKISAPI_ZoomFocus x) {
        if (0 == _hkisapi) return EError.EError_InvalidState;
        int ret;
        initReq(HKISAPIBinType_ZoomFocus, 1);
        x.toMem(_mem + 16);
        ret = LibHK.Instance.hkisapiExecuteBin(_hkisapi, _mem);
        return ret;
    }

    //
    public int get_Color(LibHK.HKISAPI_Color x) {
        if (0 == _hkisapi) return EError.EError_InvalidState;
        int ret;
        initReq(HKISAPIBinType_Color, 0);
        ret = LibHK.Instance.hkisapiExecuteBin(_hkisapi, _mem);
        x.fromMem(_mem + 16 + 1024);
        return ret;
    }

    public int set_Color(LibHK.HKISAPI_Color x) {
        if (0 == _hkisapi) return EError.EError_InvalidState;
        int ret;
        initReq(HKISAPIBinType_Color, 1);
        x.toMem(_mem + 16);
        ret = LibHK.Instance.hkisapiExecuteBin(_hkisapi, _mem);
        return ret;
    }

    //
    public int get_Exposure(LibHK.HKISAPI_Exposure x) {
        if (0 == _hkisapi) return EError.EError_InvalidState;
        int ret;
        initReq(HKISAPIBinType_Exposure, 0);
        ret = LibHK.Instance.hkisapiExecuteBin(_hkisapi, _mem);
        x.fromMem(_mem + 16 + 1024);
        return ret;
    }

    public int set_Exposure(LibHK.HKISAPI_Exposure x) {
        if (0 == _hkisapi) return EError.EError_InvalidState;
        int ret;
        initReq(HKISAPIBinType_Exposure, 1);
        x.toMem(_mem + 16);
        ret = LibHK.Instance.hkisapiExecuteBin(_hkisapi, _mem);
        return ret;
    }

    //
    public int get_Iris(LibHK.HKISAPI_Iris x) {
        if (0 == _hkisapi) return EError.EError_InvalidState;
        int ret;
        initReq(HKISAPIBinType_Iris, 0);
        ret = LibHK.Instance.hkisapiExecuteBin(_hkisapi, _mem);
        x.fromMem(_mem + 16 + 1024);
        return ret;
    }

    public int set_Iris(LibHK.HKISAPI_Iris x) {
        if (0 == _hkisapi) return EError.EError_InvalidState;
        int ret;
        initReq(HKISAPIBinType_Iris, 1);
        x.toMem(_mem + 16);
        ret = LibHK.Instance.hkisapiExecuteBin(_hkisapi, _mem);
        return ret;
    }

    //
    public int get_FocusConfiguration(LibHK.HKISAPI_FocusConfiguration x) {
        if (0 == _hkisapi) return EError.EError_InvalidState;
        int ret;
        initReq(HKISAPIBinType_FocusConfiguration, 0);
        ret = LibHK.Instance.hkisapiExecuteBin(_hkisapi, _mem);
        x.fromMem(_mem + 16 + 1024);
        return ret;
    }

    public int set_FocusConfiguration(LibHK.HKISAPI_FocusConfiguration x) {
        if (0 == _hkisapi) return EError.EError_InvalidState;
        int ret;
        initReq(HKISAPIBinType_FocusConfiguration, 1);
        x.toMem(_mem + 16);
        ret = LibHK.Instance.hkisapiExecuteBin(_hkisapi, _mem);
        return ret;
    }

    //
    public int get_SupplementLight(LibHK.HKISAPI_SupplementLight x) {
        if (0 == _hkisapi) return EError.EError_InvalidState;
        int ret;
        initReq(HKISAPIBinType_SupplementLight, 0);
        ret = LibHK.Instance.hkisapiExecuteBin(_hkisapi, _mem);
        x.fromMem(_mem + 16 + 1024);
        return ret;
    }

    public int set_SupplementLight(LibHK.HKISAPI_SupplementLight x) {
        if (0 == _hkisapi) return EError.EError_InvalidState;
        int ret;
        initReq(HKISAPIBinType_SupplementLight, 1);
        x.toMem(_mem + 16);
        ret = LibHK.Instance.hkisapiExecuteBin(_hkisapi, _mem);
        return ret;
    }


}
