#include "main.h"
#include <YoseenSDK/YoseenDeviceTypes.h>
#include <LibPTZ/LibPTZ.h>

#include <stdio.h>
#include <string.h>
#include <Windows.h>

void test_LibPTZ_control() {
    s32 ret, i;
    ret = Device_InitSDK();

    //
    DeviceConfig config = {};

    //vis
    config.ptzconntype = EPtzConnType_VIS;
    strcpy(config.ir_ip, "192.168.1.210");
    strcpy(config.vis_ip, "192.168.1.230");

    //ir
    //config.ptzconntype = EPtzConnType_IR;
    //strcpy(config.ir_ip, "192.168.1.215");
    //strcpy(config.vis_ip, "192.168.1.235");

    //
    strcpy(config.vis_username, "admin");
    strcpy(config.vis_password, "yoseen2018");
    config.timeout = 0;
 

    //
    DeviceContext* context = Device_Create();

    ret = Device_SetDeviceConfig(context, &config);

    //
    ret = Device_Login(context);

    //{
    //    //move
    //    s32 act = PtzAction_MoveLeft; //PtzAction_ZoomIn
    //    s32 arg = 100;
    //    ret = Device_PTZControlStart(context, act, arg);

    //    ret = Device_PTZControlStop(context, act, arg);
    //    ret = 0;
    //}

    {
        //ptz
        s32 pan, tilt, zoom;
        ret = Device_GetPTZ(context, pan, tilt, zoom);

        pan = 3000;
        tilt = 2000;
        zoom = 100;
        ret = Device_SetPTZ(context, pan, tilt, zoom);
        ret = 0;
    }

    {
        //w4r4
        s32 w = 0x000700c8;
        s32 r = 0;
        ret = Device_PTZW4R4(context, w, r);
        ret = 0;
    }

    //preset
    {
        PresetConfig* presetConfig;
        Preset preset = {};
        ret = Device_PresetOpenConfig(context, "PresetConfig.bin", &presetConfig);
        for (i = 0; i < PresetConfig_PresetCountMax; i++) {
            snprintf(preset.name, 64, "preset%d", i);
            preset.pan = i * 100;
            preset.tilt = i * 100;
            preset.zoom = i * 1000;
            ret = Device_PresetSave(context, &preset, i);
        }

        Device_PresetCloseConfig(context);

        ret = Device_PresetGoto(context, 1);
    }

    //
    Device_Logout(context);

    Device_Free(&context);
}
