using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Windows.Media;

using Xceed.Wpf.Toolkit.PropertyGrid.Attributes;

using MVVM;

using sdkdef = YoseenPTZ.SDKDef;
using YoseenPTZ.ResourceDef;

namespace YoseenPTZ.CoreDef
{
    public class ClsDeviceConfig : BaseModel
    {
        internal sdkdef.DeviceConfig _bin;

        [PropertyOrder(0), DisplayName(Loc.DeviceConfig_ir_ip), Description()]
        public string ir_ip
        {
            get
            {
                return _bin.ir_ip;
            }
            set
            {
                if (value != _bin.ir_ip)
                {
                    _bin.ir_ip = value;
                    OnPropertyChanged("ir_ip");
                }
            }
        }

        [PropertyOrder(1), DisplayName(Loc.DeviceConfig_vis_ip), Description()]
        public string vis_ip
        {
            get
            {
                return _bin.vis_ip;
            }
            set
            {
                if (value != _bin.vis_ip)
                {
                    _bin.vis_ip = value;
                    OnPropertyChanged("vis_ip");
                }
            }
        }

        [PropertyOrder(2), DisplayName(Loc.DeviceConfig_vis_username), Description()]
        public string vis_username
        {
            get
            {
                return _bin.vis_username;
            }
            set
            {
                if (value != _bin.vis_username)
                {
                    _bin.vis_username = value;
                    OnPropertyChanged("vis_username");
                }
            }
        }

        [PropertyOrder(3), DisplayName(Loc.DeviceConfig_vis_password), Description()]
        public string vis_password
        {
            get
            {
                return _bin.vis_password;
            }
            set
            {
                if (value != _bin.vis_password)
                {
                    _bin.vis_password = value;
                    OnPropertyChanged("vis_password");
                }
            }
        }

        [PropertyOrder(4), DisplayName(Loc.DeviceConfig_ptzconntype), Description()]
        public sdkdef.EPtzConnType ptzconntype
        {
            get
            {
                return (sdkdef.EPtzConnType)_bin.ptzconntype;
            }
            set
            {
                int n = (int)value;
                if (n != _bin.ptzconntype)
                {
                    _bin.ptzconntype = n;
                    OnPropertyChanged("ptzconntype");
                }
            }
        }

        [PropertyOrder(5), DisplayName(Loc.DeviceConfig_timeout), Description()]
        public int timeout
        {
            get
            {
                return _bin.timeout;
            }
            set
            {
                if (value != _bin.timeout)
                {
                    _bin.timeout = value;
                    OnPropertyChanged("timeout");
                }
            }
        }

        public void Bin2Cls(ref sdkdef.DeviceConfig bin)
        {
            _bin = bin;
        }

        public void Ptr2Cls(IntPtr ptr)
        {
            _bin = Marshal.PtrToStructure<sdkdef.DeviceConfig>(ptr);
        }
    }

    public class ClsPreset : BaseModel
    {
        static ClsPreset[] __presetArray;
        public static ClsPreset[] PresetArray
        {
            get
            {
                if (null == __presetArray)
                {
                    List<ClsPreset> presetList = new List<ClsPreset>();
                    int i;
                    for (i = 0; i <= 255; i++)
                    {
                        ClsPreset p = new ClsPreset();
                        p.ext_index = i;
                        presetList.Add(p);
                    }

                    //
                    List<ClsPreset> presetList2 = new List<ClsPreset>();
                    presetList2.Add(presetList[202]);
                    presetList2.Add(presetList[203]);
                    for (i = 1; i <= 255; i++)
                    {
                        presetList2.Add(presetList[i]);
                    }

                    __presetArray = presetList2.ToArray();
                }
                return __presetArray;
            }
        }

        internal sdkdef.Preset _bin;

        public string name
        {
            get
            {
                return _bin.name;
            }
            set
            {
                if (value != _bin.name)
                {
                    _bin.name = value;
                    OnPropertyChanged("name");
                }
            }
        }

        public int pan
        {
            get
            {
                return _bin.pan;
            }
            set
            {
                if (value != _bin.pan)
                {
                    _bin.pan = value;
                    OnPropertyChanged("pan");
                }
            }
        }

        public int tilt
        {
            get
            {
                return _bin.tilt;
            }
            set
            {
                if (value != _bin.tilt)
                {
                    _bin.tilt = value;
                    OnPropertyChanged("tilt");
                }
            }
        }

        public int zoom
        {
            get
            {
                return _bin.zoom;
            }
            set
            {
                if (value != _bin.zoom)
                {
                    _bin.zoom = value;
                    OnPropertyChanged("zoom");
                }
            }
        }

        public int ext_index { get; set; }

        public void Bin2Cls(ref sdkdef.Preset bin)
        {
            name = bin.name;
            pan = bin.pan;
            tilt = bin.tilt;
            zoom = bin.zoom;
        }
    }

    [CategoryOrder(Loc.Image, 1)]
    [CategoryOrder(Loc.Image_Man, 2)]
    [CategoryOrder(Loc.Image_CT, 3)]
    public class ClsImageConfig : BaseModel
    {
        internal sdkdef.ImageConfig _bin;

        #region image
        [Category(Loc.Image), PropertyOrder(0), DisplayName(Loc.Image_Palette), Description()]
        public sdkdef.xxxpalette Image_PaletteType
        {
            get
            {
                return (sdkdef.xxxpalette)_bin.palette_type;
            }
            set
            {
                int n = (int)value;
                if (n != _bin.palette_type)
                {
                    _bin.palette_type = n;
                    OnPropertyChanged("Image_PaletteType");
                }
            }
        }


        [Category(Loc.Image), PropertyOrder(1), DisplayName(Loc.Image_StrechType), Description()]
        public sdkdef.strech_type Image_StrechType
        {
            get
            {
                return _bin.sc.strech_type;
            }
            set
            {
                if (value != _bin.sc.strech_type)
                {
                    _bin.sc.strech_type = value;
                    OnPropertyChanged("Image_StrechType");
                }
            }
        }

        [Category(Loc.Image), PropertyOrder(2), DisplayName(Loc.Image_Gain), Description(Loc.Image_GainXXX)]
        public float Image_Gain
        {
            get
            {
                return _bin.sc.gain;
            }
            set
            {
                if (value != _bin.sc.gain && value > 0.09 && value < 10.01)
                {
                    _bin.sc.gain = value;
                    OnPropertyChanged("Image_Gain");
                }
            }
        }

        [Category(Loc.Image), PropertyOrder(3), DisplayName(Loc.Image_DDELevel), Description(Loc.Image_DDELevelXXX)]
        public byte Image_DDELevel
        {
            get
            {
                return _bin.sc.dde_level;
            }
            set
            {
                if (value != _bin.sc.dde_level && value >= 0 && value <= 8)
                {
                    _bin.sc.dde_level = value;
                    OnPropertyChanged("Image_DDELevel");
                }
            }
        }
        #endregion

        #region image, mt
        [Category(Loc.Image_Man), PropertyOrder(0), DisplayName(Loc.Image_ManEnable), Description(Loc.UnitTemp)]
        public bool Image_ManEnable
        {
            get
            {
                return 0 != _bin.sc.man_enable;
            }
            set
            {
                int n = value ? 1 : 0;
                if (n != _bin.sc.man_enable)
                {
                    _bin.sc.man_enable = (byte)n;
                    OnPropertyChanged("Image_ManEnable");
                }
            }
        }

        [Category(Loc.Image_Man), PropertyOrder(1), DisplayName(Loc.Image_ManTemp0), Description(Loc.UnitTemp)]
        public float Image_ManTemp0
        {
            get
            {
                float f = _bin.sc.man_temp0;
                return f / 10;
            }
            set
            {
                float f = value * 10;
                if (f > short.MaxValue || f < short.MinValue) return;
                short t = (short)f;
                if (t != _bin.sc.man_temp0)
                {
                    _bin.sc.man_temp0 = t;
                    OnPropertyChanged("Image_ManTemp0");
                }
            }
        }

        [Category(Loc.Image_Man), PropertyOrder(2), DisplayName(Loc.Image_ManTemp1), Description(Loc.UnitTemp)]
        public float Image_ManTemp1
        {
            get
            {
                float f = _bin.sc.man_temp1;
                return f / 10;
            }
            set
            {
                float f = value * 10;
                if (f > short.MaxValue || f < short.MinValue) return;
                short t = (short)f;
                if (t != _bin.sc.man_temp1)
                {
                    _bin.sc.man_temp1 = t;
                    OnPropertyChanged("Image_ManTemp1");
                }
            }
        }
        #endregion

        #region image, ct
        [Category(Loc.Image_CT), PropertyOrder(0), DisplayName(Loc.Image_CTType), Description(Loc.Image_CTTypeXXX)]
        public sdkdef.ColorTempType Image_ctType
        {
            get
            {
                return _bin.sc.ct_type;
            }
            set
            {
                if (value != _bin.sc.ct_type)
                {
                    _bin.sc.ct_type = value;
                    OnPropertyChanged("Image_ctType");
                }
            }
        }

        [Category(Loc.Image_CT), PropertyOrder(1), DisplayName(Loc.Image_CTTemp0), Description(Loc.UnitTemp)]
        public float Image_ctTemp0
        {
            get
            {
                float f = _bin.sc.ct_temp0;
                return f / 10;
            }
            set
            {
                float f = value * 10;
                if (f > short.MaxValue || f < short.MinValue) return;
                short t = (short)f;
                if (t != _bin.sc.ct_temp0 && t >= 0 && t <= 1000)
                {
                    _bin.sc.ct_temp0 = t;
                    OnPropertyChanged("Image_ctTemp0");
                }
            }
        }

        Color _ctColor0;
        [Category(Loc.Image_CT), PropertyOrder(2), DisplayName(Loc.Image_CTColor0), Description()]
        public Color Image_ctColor0
        {
            get
            {
                return _ctColor0;
            }
            set
            {
                if (value == _ctColor0) return;
                _bin.sc.ct_color0 = sdkdef.YoseenUtil.color2int(value);
                _ctColor0 = value;
                OnPropertyChanged("Image_ctColor0");
            }
        }

        [Category(Loc.Image_CT), PropertyOrder(3), DisplayName(Loc.Image_CTTemp1), Description(Loc.UnitTemp)]
        public float Image_ctTemp1
        {
            get
            {
                float f = _bin.sc.ct_temp1;
                return f / 10;
            }
            set
            {
                float f = value * 10;
                if (f > short.MaxValue || f < short.MinValue) return;
                short t = (short)f;
                if (t != _bin.sc.ct_temp1 && t >= 0 && t <= 1000)
                {
                    _bin.sc.ct_temp1 = t;
                    OnPropertyChanged("Image_ctTemp1");
                }
            }
        }

        Color _ctColor1;
        [Category(Loc.Image_CT), PropertyOrder(4), DisplayName(Loc.Image_CTColor1), Description()]
        public Color Image_ctColor1
        {
            get
            {
                return _ctColor1;
            }
            set
            {
                if (value == _ctColor1) return;
                _bin.sc.ct_color1 = sdkdef.YoseenUtil.color2int(value);
                _ctColor1 = value;
                OnPropertyChanged("Image_ctColor1");
            }
        }
        #endregion

        public void Bin2Cls(ref sdkdef.ImageConfig bin)
        {
            _bin = bin;
            _ctColor0 = sdkdef.YoseenUtil.int2color(_bin.sc.ct_color0);
            _ctColor1 = sdkdef.YoseenUtil.int2color(_bin.sc.ct_color1);
        }

        public void Ptr2Cls(IntPtr ptr)
        {
            _bin = Marshal.PtrToStructure<sdkdef.ImageConfig>(ptr);
            _ctColor0 = sdkdef.YoseenUtil.int2color(_bin.sc.ct_color0);
            _ctColor1 = sdkdef.YoseenUtil.int2color(_bin.sc.ct_color1);
        }
    }

    #region VISParam
    [CategoryOrder(Loc.SupplementLight, 0)]
    public class ClsVISParam : BaseModel
    {
        #region SupplementLight
        internal sdkdef.HKISAPI_SupplementLight _SupplementLight;

        [Category(Loc.SupplementLight), PropertyOrder(0), DisplayName(Loc.SupplementLight_supplementLightMode), Description()]
        public sdkdef.ESupplementLightMode supplementLightMode
        {
            get
            {
                sdkdef.ESupplementLightMode e = sdkdef.ESupplementLightMode.close;
                _SupplementLight.enum_get(ref e);
                return e;
            }
            set
            {
                bool b = _SupplementLight.enum_set(value);
                if (b)
                {
                    OnPropertyChanged("supplementLightMode");
                }
            }
        }

        [Category(Loc.SupplementLight), PropertyOrder(1), DisplayName(Loc.SupplementLight_mixedLightBrightnessRegulatMode), Description()]
        public sdkdef.EMixedLightBrightnessRegulatMode mixedLightBrightnessRegulatMode
        {
            get
            {
                sdkdef.EMixedLightBrightnessRegulatMode e = sdkdef.EMixedLightBrightnessRegulatMode.auto;
                _SupplementLight.enum_get(ref e);
                return e;
            }
            set
            {
                bool b = _SupplementLight.enum_set(value);
                if (b)
                {
                    OnPropertyChanged("mixedLightBrightnessRegulatMode");
                }
            }
        }

        [Category(Loc.SupplementLight), PropertyOrder(2), DisplayName(Loc.SupplementLight_whiteLightBrightness), Description()]
        public int whiteLightBrightness
        {
            get
            {
                return _SupplementLight.whiteLightBrightness;
            }
            set
            {
                bool b = value >= 0 && value <= 100 && value != _SupplementLight.whiteLightBrightness;
                if (b)
                {
                    _SupplementLight.whiteLightBrightness = value;
                    OnPropertyChanged("whiteLightBrightness");
                }
            }
        }

        [Category(Loc.SupplementLight), PropertyOrder(3), DisplayName(Loc.SupplementLight_irLightBrightness), Description()]
        public int irLightBrightness
        {
            get
            {
                return _SupplementLight.irLightBrightness;
            }
            set
            {
                bool b = value >= 0 && value <= 100 && value != _SupplementLight.irLightBrightness;
                if (b)
                {
                    _SupplementLight.irLightBrightness = value;
                    OnPropertyChanged("irLightBrightness");
                }
            }
        }

        public void Set_SupplementLight(ref sdkdef.HKISAPI_SupplementLight bin)
        {
            _SupplementLight = bin;
            string[] ss = { "supplementLightMode", "mixedLightBrightnessRegulatMode", "whiteLightBrightness", "irLightBrightness" };
            int i;
            for (i = 0; i < ss.Length; i++)
            {
                OnPropertyChanged(ss[i]);
            }
        }
        #endregion

        #region ZoomFocus
        internal sdkdef.HKISAPI_ZoomFocus _ZoomFocus;

        public int Zoom
        {
            get
            {
                return _ZoomFocus.pqrsZoom;
            }
            set
            {
                if (value != _ZoomFocus.pqrsZoom)
                {
                    _ZoomFocus.pqrsZoom = value;
                    OnPropertyChanged("Zoom");
                }
            }
        }

        public int Focus
        {
            get
            {
                return _ZoomFocus.mnstFocus;
            }
            set
            {
                if (value != _ZoomFocus.mnstFocus)
                {
                    _ZoomFocus.mnstFocus = value;
                    OnPropertyChanged("Focus");
                }
            }
        }
        #endregion

        #region Exposure
        internal sdkdef.HKISAPI_Exposure _Exposure;
        public string ExposureType
        {
            get
            {
                return _Exposure.ExposureType;
            }
            set
            {
                if (value != _Exposure.ExposureType)
                {
                    _Exposure.ExposureType = value;
                    OnPropertyChanged("ExposureType");
                }
            }
        }
        #endregion

        #region Iris
        internal sdkdef.HKISAPI_Iris _Iris;
        public int IrisLevel
        {
            get
            {
                return _Iris.IrisLevel;
            }
            set
            {
                if (value != _Iris.IrisLevel)
                {
                    _Iris.IrisLevel = value;
                    OnPropertyChanged("IrisLevel");
                }
            }
        }
        #endregion
    };
    #endregion

    #region ClsTestInfo
    public class ClsTestInfo : BaseModel
    {
        byte _PresetStart;
        [PropertyOrder(0), DisplayName(Loc.ClsTestInfo_PresetStart), Description()]
        public byte PresetStart
        {
            get
            {
                return _PresetStart;
            }
            set
            {
                bool b = value >= 1 && value < 200 && value != _PresetStart && value < PresetEnd;
                if (b)
                {
                    _PresetStart = value;
                    OnPropertyChanged("PresetStart");
                }
            }
        }

        byte _PresetEnd;
        [PropertyOrder(1), DisplayName(Loc.ClsTestInfo_PresetEnd), Description()]
        public byte PresetEnd
        {
            get
            {
                return _PresetEnd;
            }
            set
            {
                bool b = value >= 1 && value < 200 && value != _PresetEnd && value > _PresetStart;
                if (b)
                {
                    _PresetEnd = value;
                    OnPropertyChanged("PresetEnd");
                }
            }
        }

        int _Interval;
        [PropertyOrder(2), DisplayName(Loc.ClsTestInfo_Interval), Description()]
        public int Interval
        {
            get
            {
                return _Interval;
            }
            set
            {
                bool b = value >= 1 && value <= 1000 && value != _Interval;
                if (b)
                {
                    _Interval = value;
                    OnPropertyChanged("Interval");
                }
            }
        }

        public ClsTestInfo()
        {
            _PresetStart = 1;
            _PresetEnd = 2;
            _Interval = 10;
        }
    }
    #endregion
}
