using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Interop;

namespace YoseenPTZ.CoreDef
{
    public class HwndCanvas : HwndHost
    {
        IntPtr _ContentHandle;
        public IntPtr ContentHandle
        {
            get { return _ContentHandle; }
        }

        protected override HandleRef BuildWindowCore(HandleRef hwndParent)
        {
            _ContentHandle = CreateWindowEx(
                0, "static", "",
                WS_CHILD | WS_VISIBLE | LBS_NOTIFY,
                0, 0,
                (int)Width, (int)Height,
                hwndParent.Handle,
                IntPtr.Zero,
                IntPtr.Zero,
                0);
            return new HandleRef(this, _ContentHandle);
        }

        protected override void DestroyWindowCore(HandleRef hwnd)
        {
            DestroyWindow(hwnd.Handle);
        }

        const int WS_CHILD = 0x40000000;
        const int WS_VISIBLE = 0x10000000;
        const int LBS_NOTIFY = 0x001;
        [DllImport("user32.dll")]
        static extern IntPtr CreateWindowEx(int exStyle, string className, string windowName, int style, int x, int y, int width, int height, IntPtr hwndParent, IntPtr hMenu, IntPtr hInstance, [MarshalAs(UnmanagedType.AsAny)] object pvParam);

        [DllImport("user32.dll")]
        static extern bool DestroyWindow(IntPtr hwnd);
    }
}
