﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Media;

namespace YoseenPTZ.ResourceDef
{
    public class MyIcon : Control
    {
        private static readonly Lazy<IDictionary<MyIconKind, string>> _dataIndex = new Lazy<IDictionary<MyIconKind, string>>(MyIconDataFactory.Create);
        static MyIcon()
        {
            DefaultStyleKeyProperty.OverrideMetadata(typeof(MyIcon), new FrameworkPropertyMetadata(typeof(MyIcon)));
        }

        public static readonly DependencyProperty KindProperty = DependencyProperty.Register(nameof(Kind), typeof(MyIconKind), typeof(MyIcon), new PropertyMetadata(default(MyIconKind), KindPropertyChangedCallback));
        private static void KindPropertyChangedCallback(DependencyObject dependencyObject, DependencyPropertyChangedEventArgs dependencyPropertyChangedEventArgs)
        {
            ((MyIcon)dependencyObject).UpdateData();
        }
        public MyIconKind Kind
        {
            get => (MyIconKind)GetValue(KindProperty);
            set => SetValue(KindProperty, value);
        }

        private static readonly DependencyPropertyKey DataPropertyKey = DependencyProperty.RegisterReadOnly(nameof(Data), typeof(string), typeof(MyIcon), new PropertyMetadata(""));
        public static readonly DependencyProperty DataProperty = DataPropertyKey.DependencyProperty;
        [TypeConverter(typeof(GeometryConverter))]
        public string Data
        {
            get => (string)GetValue(DataProperty);
            private set => SetValue(DataPropertyKey, value);
        }

        public override void OnApplyTemplate()
        {
            base.OnApplyTemplate();
            UpdateData();
        }

        private void UpdateData()
        {
            string data = null;
            _dataIndex.Value?.TryGetValue(Kind, out data);
            Data = data;
        }
    }

    public enum MyIconKind
    {
        file_search,
        ir_vis,
        ptz_down,
        ptz_downleft,
        ptz_downright,
        ptz_left,
        ptz_right,
        ptz_up,
        ptz_upleft,
        ptz_upright,
        temp_stream,
        tool_point,
        tool_polygon,
        tool_polyline,
        tool_shield,
        video_stream,
    }

    static class MyIconDataFactory
    {
        public static IDictionary<MyIconKind, string> Create() => new Dictionary<MyIconKind, string>
        {
            { MyIconKind.file_search, "M832.8,299.3L646.5,121.9v177.4C645.7,299.3,832.8,299.3,832.8,299.3z M556.6,385.2V87.1H199.3c-12.2,0-23.5,4.1-31.6,13  c-8.9,8.1-13,18.6-13,30v765.6c0,11.3,4.9,22.7,13,30c8.9,8.1,19.4,12.2,31.6,12.2h625.4c12.2,0,23.5-4.1,31.6-12.2  c8.9-8.1,13-19.4,13-30V385.2H556.6z M199.3,2h446.4l312.7,297.3v595.5c0.8,34-13.8,67.2-38.9,89.9c-25.9,25.1-57.5,37.3-94.8,37.3  H199.3c-36.5,0-68.9-13-94.8-37.3c-25.1-23.5-39.7-55.9-38.9-89.9V130c0-34.8,13-65.6,38.9-89.9S162.8,2,199.3,2z M474.7,836.5  c-120.7,0-217.9-95.6-217.9-214.7c0-118.3,98-214.7,217.9-214.7c120.7,0,217.9,95.6,217.9,214.7S594.6,836.5,474.7,836.5z   M474.7,772.5c85.1,0,153.9-68.1,153.9-150.7s-68.9-149.9-153.9-149.9s-153.9,67.2-153.9,149.9S388.9,772.5,474.7,772.5z   M587.3,766.8c-14.6-14.6-7.3-22.7,7.3-36.5c14.6-14.6,29.2-29.2,44.6-16.2l128,121.5c15.4,14.6,15.4,37.3,0.8,51.9  c-14.6,14.6-37.3,15.4-52.7,0.8L587.3,766.8L587.3,766.8z" },
            { MyIconKind.ir_vis, "M726.7,422.5c0-119.9-96.4-217.1-216.3-217.1s-217.1,96.4-217.1,216.3l0,0c0,119.9,96.4,217.1,216.3,217.1  S726.7,542.4,726.7,422.5z M354.8,422.5c0-85.9,69.7-155.6,155.6-155.6s155.6,69.7,155.6,155.6l0,0c0,85.9-69.7,155.6-155.6,155.6  S354.8,507.5,354.8,422.5z M610.9,422.5c0-55.9-44.6-100.5-100.5-100.5s-100.5,44.6-100.5,100.5l0,0c0,55.9,44.6,100.5,100.5,100.5  S610.9,477.6,610.9,422.5z M470.7,422.5c-1.6-21.9,15.4-40.5,36.5-42.1c21.9-1.6,40.5,15.4,42.1,36.5c0,1.6,0,4.1,0,5.7  c-1.6,21.9-21.1,38.1-42.1,35.6C486.9,456.5,472.3,441.9,470.7,422.5L470.7,422.5z M622.2,886.7V796  c215.5-60.8,339.5-283.6,278.7-499.1C840.1,81.4,617.3-43.4,401.8,17.4C228.4,66.8,107.7,225.6,107.7,407.1  C104.5,591,229.3,753,408.3,796.8v90.7h-1.6h-2.4c-89.9,15.4-177.4,42.9-177.4,103.7c0,17,13.8,30.8,30,30.8c17,0,30-13,30-28.4  v-0.8c6.5-13.8,85.1-51,233.3-51S747,978.3,752.6,992c0,17,13.8,30,30,30c17,0,30-13.8,30-30C814.2,928,717,898,622.2,886.7  L622.2,886.7L622.2,886.7z M166.1,407.1C163.6,216.7,315.1,61.1,504.7,57.9C694.3,55.4,850.7,207,853.1,396.5c0,3.2,0,6.5,0,9.7  c0,189.6-153.9,343.5-343.5,343.5C320.8,750.6,166.1,596.7,166.1,407.1L166.1,407.1z M560.6,881.8c-30-1.6-61.6-1.6-91.6,0.8v-70.5  h91.6V881.8z" },
            { MyIconKind.ptz_down, "M538.6,723.2l267.5-385.5c14.8-21.4,0-50.4-26.2-50.4H244c-25.7,0-41,29.1-26.2,50.4l268,385.6  C498.7,741.3,525.8,741.3,538.6,723.2z" },
            { MyIconKind.ptz_downleft, "M286.7,774.7l461.8-83.4c25.6-4.7,35.7-35.7,17.2-54.2l-379-379c-18.2-18.2-49.5-8.4-54.2,17.2l-83.1,462.1  C245.7,759.3,264.8,778.5,286.7,774.7z" },
            { MyIconKind.ptz_downright, "M774.6,737.4l-83.1-462.1c-4.7-25.6-36-35.4-54.2-17.2l-379,379c-18.5,18.5-8.4,49.5,17.2,54.2l461.7,83.5  C759.2,778.5,778.7,759.6,774.6,737.4z" },
            { MyIconKind.ptz_left, "M300.4,537.2l385.1,268.9c21.4,14.8,50.5,0,50.5-26.2l1.4-536c0-25.7-29.1-40.9-50.5-26.2L300.4,484.4  C281.8,497.2,282.3,524.4,300.4,537.2z" },
            { MyIconKind.ptz_right, "M723.6,484.3L337,217.7c-21.4-14.8-50.5,0.9-50.5,26.2l1.4,536.1c0,26.2,29.1,40.9,50.5,26.2l385.2-268.5  C742.1,524.3,742.1,497.2,723.6,484.3z" },
            { MyIconKind.ptz_up, "M485.7,300.9l-268,385.5c-14.8,21.4,0.5,50.5,26.2,50.5h536c26.2,0,40.9-29.1,26.2-50.5L538.6,300.9  C525.8,282.8,498.6,282.3,485.7,300.9z" },
            { MyIconKind.ptz_upleft, "M249.4,286.6l83.1,462.1c4.7,25.6,36,35.4,54.2,17.2l379-379c18.5-18.5,8.4-49.5-17.2-54.2l-461.7-83.5  C264.8,245.5,245.3,264.4,249.4,286.6z" },
            { MyIconKind.ptz_upright, "M737.4,249.4l-462.1,83.1c-25.6,4.7-35.4,36-17.2,54.2l379,379c18.5,18.5,49.5,8.4,54.2-17.2l83.5-461.7  C778.5,264.8,759.6,245.3,737.4,249.4z" },
            { MyIconKind.temp_stream, "M562.3,506.8V173.6c-4-97.9-86.5-174.7-184.4-171.5c-97.1-2.4-177.1,74.4-181.2,171.5v333.2  C71.4,592.5,39.8,763.2,126.4,888.5c4,6.5,8.9,12.1,13.7,17.8c48.5,61.5,119.7,101.1,197.3,112.4c14.6,1.6,28.3,3.2,42.9,3.2  c64.7,0,127-19.4,179.6-56.6c127-84.1,160.1-254.8,76-380.9c-4-6.5-8.9-12.1-12.9-17.8C605.2,543.2,585.8,523.8,562.3,506.8z   M580.9,843.3c-68.7,106-207.9,141.5-318.7,80.1c-105.1-54.2-145.6-182.8-91.4-287.1c2.4-4,4.9-8.1,7.3-12.1  c21-33.2,50.1-61.5,84.9-80.1V173.6c1.6-62.3,54.2-110.8,116.5-108.4l0,0c61.5-1.6,112.4,46.1,114,107.6l0,0v369.6  c105.1,52.6,148,179.6,95.4,285.5C586.6,833.5,584.1,838.4,580.9,843.3z M676.3,194.6h237c17.8,0,32.4-13.7,33.2-31.5  c0-17.8-15.4-31.5-32.4-31.5h-0.8h-237c-17.8,0-31.5,13.7-32.4,30.7C644,180.8,658.5,194.6,676.3,194.6z M914.1,422.7H676.3  c-17.8,0-31.5,14.6-31.5,31.5s14.6,31.5,31.5,31.5h237c17.8,0.8,32.4-12.9,33.2-30.7v-0.8C946.5,436.4,932.7,422.7,914.1,422.7  L914.1,422.7L914.1,422.7z M914.1,282.8H676.3c-17.8,0-31.5,12.9-31.5,29.9c0,17.8,14.6,31.5,31.5,31.5h237  c17.8,0,32.4-13.7,33.2-31.5C946.5,294.9,932.7,281.9,914.1,282.8L914.1,282.8L914.1,282.8z M419.1,653.2V226.9  c-0.8-21-18.6-37.2-38.8-36.4l0,0c-21-0.8-37.2,15.4-38,35.6v0.8v427c-37.2,12.9-62.3,47.7-63.1,86.5c1.6,53.4,46.1,95.4,99.5,94.6  h0.8c53.4,1.6,98.7-40.4,100.3-93.8v-0.8C479,701.7,454.7,666.9,419.1,653.2z" },
            { MyIconKind.tool_point, "M511.6,333.9c-20.2,0-36.4-16.2-36.4-36.4v-259c0-20.2,16.2-36.4,36.4-36.4S548,18.2,548,38.4v258.2  C548.8,316.9,531.8,333.9,511.6,333.9z M297.1,548.4H38.8c-20.2,0-36.4-16.2-36.4-36.4s16.2-36.4,36.4-36.4h258.2  c20.2,0,36.4,16.2,36.4,36.4S317.3,548.4,297.1,548.4z M511.6,1022c-20.2,0-36.4-16.2-36.4-36.4V727.3c0-20.2,16.2-36.4,36.4-36.4  s36.4,16.2,36.4,36.4v258.2C548.8,1005.8,531.8,1022,511.6,1022z M985.2,548.4H726.9c-20.2,0-36.4-16.2-36.4-36.4  s16.2-36.4,36.4-36.4h258.2c20.2,0,36.4,16.2,36.4,36.4C1022.4,532.2,1005.4,548.4,985.2,548.4z M511.6,888.4  c-100.4,0-195.1-39.7-266.3-110.1C174,707.1,135.2,612.4,135.2,512s39.7-195.1,110.1-267.1c147.3-147.3,385.3-147.3,531.9,0  s147.3,385.3,0,531.9C706.7,849.6,612,888.4,511.6,888.4L511.6,888.4z M511.6,209.2c-77.7,0-155.4,30-213.7,88.2  c-57.5,57.5-89,133.6-89,214.5s31.6,157,89,213.7c57.5,57.5,133.6,89,213.7,89s157-31.6,213.7-89c118.2-118.2,118.2-310,0-427.4  C667,239.2,589.3,209.2,511.6,209.2z" },
            { MyIconKind.tool_polygon, "M41,120.2L615.3,329c8.1,2.9,17,2.2,24.5-2.1l338.7-193.6c14-8,31.7-3.1,39.7,10.9c3.6,6.3,4.7,13.6,3.1,20.7L922.4,610  c-2.1,9.2-8.5,16.9-17.2,20.6L250.7,903.3c-14.8,6.2-31.9-0.8-38.1-15.7c-0.4-1-0.8-2.1-1.1-3.2L3.1,155.5c-4.4-15.5,4.5-31.6,20-36  C29,117.8,35.3,118.1,41,120.2L41,120.2z M258.4,837l610.4-254.4l81.4-366.1L668.6,377.4c-22.3,12.8-49.1,15.1-73.2,6.3L74.8,194.4  C74.8,194.4,258.4,837,258.4,837z" },
            { MyIconKind.tool_polyline, "M1010.1,213.4c-14.8-13.2-37.5-12-50.7,2.8c-0.1,0.1-0.2,0.2-0.3,0.3L567,660.4L318.4,345.1c-12.3-15.6-34.9-18.3-50.5-6  c-3.2,2.5-6,5.6-8.2,9.1L7.7,748.3c-10.6,16.8-5.6,39,11.3,49.6c16.8,10.6,39,5.6,49.6-11.3l224.8-357l243.7,309.1  c6.7,8.3,16.6,13.4,27.3,13.7c10.6-0.1,20.7-4.5,28-12.2L1013,264.2C1026.2,249.4,1024.9,226.7,1010.1,213.4  C1010.1,213.4,1010.1,213.4,1010.1,213.4z" },
            { MyIconKind.tool_shield, "M826.7,543.8L480.2,197.3H239.9l580.7,614c4.1,4.4,6.1,9.9,6.1,15.4L826.7,543.8L826.7,543.8z M826.7,480.2V197.3h-283  L826.7,480.2z M191.6,152.6c1.8-0.2,3.7-0.4,5.6-0.4h629.5c24.8,0,45,20.1,45,45l0,0v629.5c0,24.8-20.1,45-45,45l0,0H197.2  c-24.8-0.1-44.9-20.2-44.9-45l0,0V197.3c0-14.1,6.5-26.7,16.6-34.9C173.9,154.9,182.8,151.1,191.6,152.6z M773.3,826.7L197.2,217.6  v273.6l346.3,335.5C543.6,826.7,773.3,826.7,773.3,826.7z M478.9,826.7l-281.7-273v273H478.9z" },
            { MyIconKind.video_stream, "M616.4,540.3l1.6,1.6c22.7,23.5,34.8,55,34.8,88.2c0,33.2-13,65.6-36.4,89c-22.7,23.5-54.2,37.2-88.2,37.2  c-32.4,0-64.8-13.8-87.4-37.2c-23.5-23.5-36.4-55-36.4-89c0-34.8,13.8-66.4,36.4-89l0,0c23.5-23.5,55-37.2,87.4-37.2  C563,503.1,594.6,517.7,616.4,540.3z M585.7,687.7c15.4-15.4,23.5-36.4,23.5-57.5c0-21.9-8.1-42.1-22.7-56.7l-0.8-0.8  c-15.4-15.4-35.6-24.3-56.7-24.3s-42.1,8.1-56.7,23.5l0,0c-15.4,15.4-23.5,36.4-23.5,57.5c0,22.7,8.9,42.9,23.5,57.5l0,0l0,0  c15.4,15.4,35.6,24.3,56.7,23.5C550,711.1,571.1,703,585.7,687.7L585.7,687.7z M930.5,135.6c59.1,59.9,91.5,140.9,91.5,225  c0,12.1-9.7,21.9-21,21.9c-12.1,0-21.9-9.7-21-21.9l0,0c0-76.1-30-144.1-79.3-194.3C852,116.1,784,86.2,709.5,86.2  c-12.1,0-21.9-9.7-21.9-21.9s8.9-21.9,21-21.9l0,0C794.5,42.5,873,78.1,930.5,135.6L930.5,135.6z M809.1,258.6  c-25.9-26.7-61.5-42.1-101.2-42.1c-12.1,0-21.9-9.7-21.9-21.9c0-12.1,9.7-21.9,21.9-21.9c49.4,0,97.1,19.4,131.1,55l0.8,1.6  c34,35.6,53.4,82.6,53.4,132c0,12.1-9.7,21.9-21,21.9c-12.1,0-21.9-9.7-21-21.9l0,0c0-39.7-16.2-75.3-40.5-101.2L809.1,258.6  L809.1,258.6z M887.6,444.8c8.1-8.1,21.9-8.1,30,0l0,0c4.9,4.9,5.7,9.7,5.7,16.2v338.4c0,12.1-9.7,21.9-21,21.9  c-5.7,0-11.3-2.4-15.4-6.5L772.7,697.4v129.5c0,41.3-16.2,80.1-44.5,109.3c-28.3,28.3-66.4,45.3-107.7,45.3H154.2  c-41.3,0-79.3-17-107.7-45.3S2,868.2,2,826.9V432.7c0-41.3,16.2-80.1,44.5-109.3c28.3-29.1,67.2-45.3,107.7-45.3h465.5  c42.1,0,80.1,17.8,107.7,45.3c29.1,29.1,44.5,68,44.5,109.3v129.5C773.5,561.4,887.6,444.8,887.6,444.8z M700.6,826.1V431.9  c0-21-8.1-42.1-23.5-57.5c-15.4-15.4-35.6-23.5-56.7-23.5H154.2c-21,0-42.1,8.1-56.7,23.5C82.1,389.8,74,410.8,74,431.9v394.2  c0,21.9,8.9,42.1,23.5,57.5c15.4,15.4,35.6,24.3,56.7,24.3h465.5c21.9,0,42.1-8.9,56.7-24.3C691.7,869,701.4,848,700.6,826.1  L700.6,826.1z M882,745.1V512.8L773.5,623.7V635C773.5,634.2,882,745.1,882,745.1z M333.1,540.3l1.6,1.6  c22.7,23.5,34.8,55,34.8,88.2c0,33.2-13,65.6-36.4,89c-22.7,23.5-54.2,37.2-88.2,37.2s-65.6-14.6-87.4-37.2  c-23.5-23.5-36.4-55-36.4-89c0-34.8,13.8-66.4,36.4-89c23.5-23.5,55-37.2,88.2-37.2C280.5,503.1,311.2,517.7,333.1,540.3z   M303.1,687.7c15.4-15.4,23.5-36.4,23.5-57.5c0-21.9-8.9-42.1-22.7-56.7l-0.8-0.8c-30-31.6-81-31.6-112.5-1.6  c-0.8,0.8-0.8,0.8-1.6,1.6l0,0c-15.4,15.4-23.5,36.4-23.5,57.5c0,22.7,8.9,42.9,23.5,57.5l0,0l0,0c15.4,15.4,35.6,24.3,56.7,23.5  C267.5,711.1,287.8,703,303.1,687.7z" },
        };
    }
}
