using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Controls;
using System.ComponentModel;
using System.Text.RegularExpressions;
using System.IO;

using MVVM;

using sdkdef = YoseenPTZ.SDKDef;

using YoseenPTZ.ConfigDef;
using YoseenPTZ.CoreDef;
using YoseenPTZ.ResourceDef;

namespace YoseenPTZ.ViewDef
{
    public partial class PresetRawView : Window
    {
        #region single
        static PresetRawView __instance;
        public static void ShowView(DeviceView deviceView)
        {
            if (__instance == null)
            {
                __instance = new PresetRawView(deviceView);
                __instance.Owner = App.Instance.ShellView;
                __instance.Show();
            }
            else
            {
                __instance.Show();
            }
        }

        protected override void OnClosing(CancelEventArgs e)
        {
            if (!_forceClose)
            {
                e.Cancel = true;
                this.Hide();
            }
            base.OnClosing(e);
        }

        bool _forceClose;
        public static void ForceClose()
        {
            if (__instance == null) return;
            __instance._forceClose = true;
            __instance.Close();
            __instance = null;
        }
        #endregion

        readonly DeviceView _deviceView;
        PresetRawView(DeviceView deviceView)
        {
            MaterialDesignWindow.RegisterCommands(this);
            InitializeComponent();
            //
            _deviceView = deviceView;
            dgPreset.ItemsSource = ClsPreset.PresetArray;
        }

        private void btnPresetGoto_Click(object sender, RoutedEventArgs e)
        {
            ClsPreset preset = dgPreset.SelectedItem as ClsPreset;
            if (preset == null) return;
            int presetId = preset.ext_index;
            int ret;
            ret = _deviceView.PTZControlStart((int)sdkdef.EPtzAction.PresetGoto, presetId);
        }

        private void btnPresetSave_Click(object sender, RoutedEventArgs e)
        {
            ClsPreset preset = dgPreset.SelectedItem as ClsPreset;
            if (preset == null) return;
            int presetId = preset.ext_index;
            int ret;
            ret = _deviceView.PTZControlStart((int)sdkdef.EPtzAction.PresetSet, presetId);
        }

        private void btnPresetClear_Click(object sender, RoutedEventArgs e)
        {
            ClsPreset preset = dgPreset.SelectedItem as ClsPreset;
            if (preset == null) return;
            int presetId = preset.ext_index;
            int ret;
            ret = _deviceView.PTZControlStart((int)sdkdef.EPtzAction.PresetClear, presetId);
        }
    }
}
