#include "Device.h"
#include "QDebug"

/*********************************************************************
 *
 *
 * init, free sdk
 *
 * ******************************************************************/
int Device::initSDK(){
    int ret;
    ret=Yoseen_InitSDK();
    return ret;
}
void Device::freeSDK(){
    Yoseen_FreeSDK();
}

Device::Device(QObject *parent) : QObject(parent){
    m_userHandle = -1;
    m_previewHandle = -1;
    memset(&m_basicInfo, 0, sizeof(CameraBasicInfo));
    memset(&m_loginInfo, 0, sizeof(YoseenLoginInfo));

    //
    memset(&m_previewInfo, 0, sizeof(YoseenPreviewInfo));
    m_previewInfo.CustomData = this;
    m_previewInfo.CustomCallback = Device::onFrameRecvedStatic;

    //default-1
    m_gpioInputLast=1;
}

Device::~Device(){
    logout();
}
/*********************************************************************
 *
 *
 * preview, callback
 *
 * ******************************************************************/
void __stdcall Device::onFrameRecvedStatic(s32 errorCode, DataFrame *dataFrame, void *customData){
    Device* camera = (Device*)customData;
    camera->onFrameRecved(errorCode, dataFrame);
}
void Device::onFrameRecved(s32 errorCode, DataFrame* dataFrame){
    //trigger gpioInputChanged, 1->0, 0->1
    DataFrameHeader* dfh=(DataFrameHeader*)dataFrame->Head;
    int newValue=dfh->GpioInput0;
    if(m_gpioInputLast!=newValue){
        emit gpioInputChanged(m_gpioInputLast,newValue);
        m_gpioInputLast=newValue;
    }

    //
    emit frameRecved(errorCode, dataFrame);
}

/*********************************************************************
 *
 * login
 *
 *
 * ******************************************************************/
int Device::login(char* ip){
    s32 ret;
    strncpy(m_loginInfo.CameraAddr, ip, 32);
    ret = Yoseen_Login(&m_loginInfo, &m_basicInfo);
    if(0<=ret){
        m_userHandle=ret;
    }
    return ret;
}

void Device::logout(){
    if(m_userHandle<0) return;
    stopPreview();
    Yoseen_Logout(m_userHandle);m_userHandle=-1;
}

int Device::saveJpg(char* fn){
    if(m_userHandle<0) return EError_InvalidState;

    int ret;
    ret= Yoseen_SaveFrame(m_userHandle,fn,1);
    return ret;
}
int Device::sendControl(Ctl* ctl){
    if(m_userHandle<0) return EError_InvalidState;

    int ret;
    ret=Yoseen_SendControl(m_userHandle, ctl);
    return ret;
}
int Device::sendControlX(CtlX* ctlx){
    if(m_userHandle<0) return EError_InvalidState;

    int ret;
    ret=Yoseen_SendControlX(m_userHandle, ctlx);
    return ret;
}

/*********************************************************************
 *
 * preview
 *
 *
 * ******************************************************************/
int Device::startPreivew(s32 dataType){
    bool b=m_userHandle>=0 && m_previewHandle<0;
    if(!b)return EError_InvalidState;

    s32 ret;
    m_previewInfo.DataType = dataType;
    ret = Yoseen_StartPreview(m_userHandle, &m_previewInfo);
    if(0<=ret){
        m_previewHandle=ret;
    }
    //default-1
    m_gpioInputLast=1;
    return ret;
}

void Device::stopPreview(){
    if(m_previewHandle < 0) return;
    int ret;
    ret=Yoseen_StopPreview(m_previewHandle);m_previewHandle = -1;
}

int Device::beginSave(char* fn, s32 ft){
    if(m_previewHandle < 0) return EError_InvalidState;
    int ret = -1;
    ret = Yoseen_BeginSave(m_previewHandle, fn, ft);
    return ret;
}

void Device::endSave(s32 ft){
    if(m_previewHandle < 0) return;
    int ret;
    ret = Yoseen_EndSave(m_previewHandle, ft);
}
