#include "YoseenCamera.h"

#include <stdio.h>
#include <string.h>


/*
初始化SDK, 释放SDK
*/
s32 YoseenCamera::InitSDK(){
	s32 ret = Yoseen_InitSDK();
	return ret;
}
void YoseenCamera::FreeSDK(){
	Yoseen_FreeSDK();
}

/*
构造和析构函数
*/
YoseenCamera::YoseenCamera(){
	mUserHandle = -1;
	mPreviewHandle = -1;
	mFuncFrameRecved = NULL;
	mFuncConnectChanged = NULL;
}

YoseenCamera::~YoseenCamera(){
	StopPreview();
	Logout();
}

/*
登入和退出
*/
s32 YoseenCamera::Login(const char* cameraIp){
	//
	if (mUserHandle >= 0){
		Logout();
	}

	//
	YoseenLoginInfo loginInfo = {};
	strncpy(loginInfo.CameraAddr, cameraIp, 32);
	mUserHandle = Yoseen_Login(&loginInfo, &mBasicInfo);
	return mUserHandle;
}
void YoseenCamera::Logout(){
	if (mUserHandle >= 0){
		Yoseen_Logout(mUserHandle);
		mUserHandle = -1;
	}
}

/*
开始和停止温度流预览
*/
s32 YoseenCamera::StartPreview(Func_FrameRecved funcFrameRecved, Func_ConnectChanged funcConnectChanged){
	//
	if (mPreviewHandle >= 0){
		StopPreview();
	}

	//
	YoseenPreviewInfo previewInfo = {};
	previewInfo.DataType = xxxdatatype_video;//xxxdatatype_temp
	previewInfo.CustomData = this;
	previewInfo.CustomCallback = YoseenCamera::FrameRecvedStatic;
	mPreviewHandle = Yoseen_StartPreview(mUserHandle, &previewInfo);

	if (mPreviewHandle >= 0){
		mFuncFrameRecved = funcFrameRecved;
		mFuncConnectChanged = funcConnectChanged;
	}

	return mPreviewHandle;
}
void YoseenCamera::StopPreview(){
	if (mPreviewHandle >= 0){
		Yoseen_StopPreview(mPreviewHandle);
		mPreviewHandle = -1;
		mFuncFrameRecved = NULL;
		mFuncConnectChanged = NULL;
	}
}

/*
SDK定义的回调, 转, 用户定义的回调
*/
void YoseenCamera::FrameRecvedStatic(s32 errorCode, DataFrame* dataFrame, void* customData){
	YoseenCamera* camera = (YoseenCamera*)customData;
	camera->FrameRecved(errorCode, dataFrame);
}
void YoseenCamera::FrameRecved(s32 errorCode, DataFrame* dataFrame){
	//连接改变判定
	if (errorCode != 0){
		if (mFuncConnectChanged){
			mFuncConnectChanged(this, errorCode);
		}
		return;
	}

	/*	
	帧头dfh: 128字节, 包含设备工作的温度等信息
	帧数据区dfd: 384x288个16位有符号的数(左上角为原点), 数值除以100就是温度值
	*/
	DataFrameHeader* dfh = (DataFrameHeader*)dataFrame->Head;
	s16* dfd = (s16*)dataFrame->Temp;

	if (mFuncFrameRecved){
		mFuncFrameRecved(this, dataFrame);
	}
}

/*
手动挡板校零
*/
s32 YoseenCamera::ManualFFC(){
	if (mUserHandle < 0)return EError_InvalidHandle;

	Ctl ctl = {};
	ctl.Type = CtlType_ManualFFC;
	s32 ret = Yoseen_SendControl(mUserHandle, &ctl);
	return ret;
}