using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;

using yoseen = YoseenSDKCS;

namespace YoseenDemoCustomDraw
{
    public partial class ShellView : Form
    {
        #region consts
        const string Const_hwndShell = "YoseenDemo, VideoMouse";
        const string Const_hwndPreview = "Preview";
        const string Const_btnUrl = "Url";

        const string Const_btnStartWork = "Start Work";
        const string Const_btnStopWork = "Stop Work";

        const string Const_btnSaveJpgx = "Save .jpg";
        const string Const_btnBeginSave = "Begin Save .mp4";
        const string Const_btnEndSave = "End Save .mp4";

        #endregion

        #region controls
        IRVideoView irView;

        Button btnUrl;
        TextBox tbUrl;

        Button btnStarWork;
        Button btnStopWork;

        Button btnSaveJpgx;
        Button btnBeginSave;
        Button btnEndSave;

        TextBox tbEcho;

        Font _font;
        public ShellView()
        {
            InitializeComponent();

            this.SuspendLayout();

            //
            _font = new Font("Times New Roman", 9, FontStyle.Regular);
            this.Font = _font;
            this.Text = Const_hwndShell;

            //0
            irView = new IRVideoView();
            this.Controls.Add(irView);

            //1
            btnUrl = new Button();
            btnUrl.Text = Const_btnUrl;
            btnUrl.Click += btnUrl_Click;
            this.Controls.Add(btnUrl);

            tbUrl = new TextBox();
            this.Controls.Add(tbUrl);

            //2
            btnStarWork = new Button();
            btnStarWork.Text = Const_btnStartWork;
            btnStarWork.Click += btnStartWork_Click;
            this.Controls.Add(btnStarWork);

            btnStopWork = new Button();
            btnStopWork.Text = Const_btnStopWork;
            btnStopWork.Click += btnStopWork_Click;
            this.Controls.Add(btnStopWork);

            //3
            btnSaveJpgx = new Button();
            btnSaveJpgx.Text = Const_btnSaveJpgx;
            btnSaveJpgx.Click += btnSaveJpgx_Click;
            this.Controls.Add(btnSaveJpgx);

            btnBeginSave = new Button();
            btnBeginSave.Text = Const_btnBeginSave;
            btnBeginSave.Click += btnBeginSave_Click;
            this.Controls.Add(btnBeginSave);

            btnEndSave = new Button();
            btnEndSave.Text = Const_btnEndSave;
            btnEndSave.Click += btnEndSave_Click;
            this.Controls.Add(btnEndSave);

            //4
            tbEcho = new TextBox();
            this.Controls.Add(tbEcho);

            //
            this.Width = 800;
            this.Height = 600;
            layout();
            this.ResumeLayout(false);

            this.Resize += ShellView_Resize;
        }

        void setBounds(Control ctl, int x, int y, int width, int height)
        {
            int dx = width / 6;
            int dy = height / 8;
            ctl.SetBounds(x + dx, y + dy, width - 2 * dx, height - 2 * dy);
        }


        void layout()
        {
            Size s = this.ClientSize;
            int width = s.Width;
            int height = s.Height;

            //
            double[] xarr = { 1, 1, 1, 1, 1 };
            double[] yarr = { 10, 1, 1, 1, 1 };
            double dx = width / 5.0;
            double dy = height / 14.0;

            //00
            int x, y;
            x = 0; y = 0; height = Convert.ToInt32(dy * yarr[0]);
            irView.SetBounds(x, y, width, height);

            //10,11
            y += height; width = Convert.ToInt32(dx * xarr[0]); height = Convert.ToInt32(dy * yarr[1]);
            setBounds(btnUrl, x, y, width, height);

            x += width; width = Convert.ToInt32(dx * (xarr[1] + xarr[2] + xarr[3] + xarr[4]));
            tbUrl.SetBounds(x, y, width, height);

            //20,
            x = 0; y += height; width = Convert.ToInt32(dx * xarr[0]); height = Convert.ToInt32(dy * yarr[2]);
            setBounds(btnStarWork, x, y, width, height);

            x += width; width = Convert.ToInt32(dx * xarr[1]);
            setBounds(btnStopWork, x, y, width, height);

            //30
            x = 0; y += height; width = Convert.ToInt32(dx * xarr[0]); height = Convert.ToInt32(dy * yarr[3]);
            setBounds(btnSaveJpgx, x, y, width, height);

            x += width; width = Convert.ToInt32(dx * xarr[1]);
            setBounds(btnBeginSave, x, y, width, height);

            x += width; width = Convert.ToInt32(dx * xarr[2]);
            setBounds(btnEndSave, x, y, width, height);

            //40
            x = 0; y += height; width = this.Width; height = Convert.ToInt32(dy * yarr[4]);
            tbEcho.SetBounds(x, y, width, height);
        }

        void ShellView_Resize(object sender, EventArgs e)
        {
            layout();
        }
        #endregion

        void btnUrl_Click(object sender, EventArgs e)
        {
            yoseen.DiscoverCameraResp2[] dcrs = yoseen.YoseenSDK.Yoseen_DiscoverCameras2(0x01);
            string s = null;
            if (dcrs.Length == 0)
            {
                s = "discover no cameras";
            }
            else
            {
                s = "discover cameras, ";
                int i = 0;
                for (; i < dcrs.Length; i++)
                {
                    s += yoseen.YoseenUtil.uint2str(dcrs[i].CameraIp) + ", ";
                }
            }
            tbEcho.Text = s;
        }

        private void btnStartWork_Click(object sender, EventArgs e)
        {
            int ret;
            irView.SetConfig(tbUrl.Text);
            ret= irView.StartWork();
            tbEcho.Text = $"StartWork, ret {ret}";
        }

        private void btnStopWork_Click(object sender, EventArgs e)
        {
            int ret;
            irView.StopWork();
            tbEcho.Text = $"StopWork";
        }

        private void btnSaveJpgx_Click(object sender, EventArgs e)
        {
            string fn = string.Format("{0}\\{1:yyyyMMdd_HHmmss}.jpg", AppPaths.Data, DateTime.Now);
            int ret = irView.SaveFrame(fn);
            tbEcho.Text = $"SaveFrame, fn {fn}, ret {ret}";
        }

        private void btnBeginSave_Click(object sender, EventArgs e)
        {
            int ret;
            string fn = string.Format("{0}\\{1:yyyyMMdd_HHmmss}.mp4", AppPaths.Data, DateTime.Now);
            ret = irView.BeginSave(fn);
            tbEcho.Text = $"BeginSave, fn {fn}, ret {ret}";
        }

        private void btnEndSave_Click(object sender, EventArgs e)
        {
            irView.EndSave();
            tbEcho.Text = $"EndSave";
        }

        protected override void OnClosing(CancelEventArgs e)
        {
            base.OnClosing(e);
        }
    }

}
