﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Text.RegularExpressions;

namespace YoseenSDKCS
{
    public static class YoseenUtil
    {
        /// <summary>
        /// IP字符串转数字
        /// </summary>
        /// <param name="ipStr">IP字符串</param>
        /// <returns>IP数字</returns>
        public static uint str2uint(string ipStr)
        {
            char[] separator = new char[] { '.' };
            string[] items = ipStr.Split(separator);

            if (items.Length != 4) return 0;

            return uint.Parse(items[0]) << 24
                    | uint.Parse(items[1]) << 16
                    | uint.Parse(items[2]) << 8
                    | uint.Parse(items[3]);
        }

        /// <summary>
        /// IP数字转字符串
        /// </summary>
        /// <param name="ipUint">IP数字</param>
        /// <returns>IP字符串</returns>
        public static string uint2str(uint ipUint)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append((ipUint >> 24) & 0xFF).Append(".");
            sb.Append((ipUint >> 16) & 0xFF).Append(".");
            sb.Append((ipUint >> 8) & 0xFF).Append(".");
            sb.Append(ipUint & 0xFF);
            return sb.ToString();
        }

        public static bool IsValid(ref xxxshield shield, ushort dataWidth, ushort dataHeight)
        {
            ushort[] xydata = shield.xydata;
            bool valid = xydata[0] < dataWidth && xydata[2] < dataWidth && xydata[4] < dataWidth && xydata[6] < dataWidth
                && xydata[1] < dataHeight && xydata[3] < dataHeight && xydata[5] < dataHeight && xydata[7] < dataHeight;
            return valid;
        }

        public static bool IsValid(ref xxxmeasure mo, ushort dataWidth, ushort dataHeight)
        {
            bool valid = mo.emmi >= 50 && mo.emmi <= 100;
            int i;
            switch (mo.measuretype)
            {
                case xxxmeasuretype.point:
                    valid = valid && mo.xydata[0] < dataWidth && mo.xydata[1] < dataHeight
                        && mo.xydata[2] < 4;
                    break;

                case xxxmeasuretype.line:
                    valid = valid && mo.xydata[0] < dataWidth && mo.xydata[1] < dataHeight
                       && mo.xydata[2] < dataWidth && mo.xydata[3] < dataHeight;
                    break;

                case xxxmeasuretype.rectangle:
                case xxxmeasuretype.ellipse:
                    valid = valid && mo.xydata[0] < dataWidth && mo.xydata[1] < dataHeight
                        && mo.xydata[2] < dataWidth && mo.xydata[3] < dataHeight
                        && mo.xydata[0] < mo.xydata[2] && mo.xydata[1] < mo.xydata[3];
                    break;

                case xxxmeasuretype.polyline:
                    valid = valid && mo.points >= 2;
                    for (i = 0; i < mo.points; i++)
                    {
                        bool x = mo.xydata[i * 2] < dataWidth && mo.xydata[i * 2 + 1] < dataHeight;
                        valid = valid && x;
                        if (!valid) break;
                    }
                    break;
                case xxxmeasuretype.polygon:
                    valid = valid && mo.points >= 3;
                    for (i = 0; i < mo.points; i++)
                    {
                        bool x = mo.xydata[i * 2] < dataWidth && mo.xydata[i * 2 + 1] < dataHeight;
                        valid = valid && x;
                        if (!valid) break;
                    }
                    break;

                default:
                    valid = false;
                    break;
            }
            return valid;
        }


        public static string Byte2Hex(byte[] bytes, int count)
        {
            string[] hexStringTable = new string[] {
        "00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F",
        "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1A", "1B", "1C", "1D", "1E", "1F",
        "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2A", "2B", "2C", "2D", "2E", "2F",
        "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3A", "3B", "3C", "3D", "3E", "3F",
        "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4A", "4B", "4C", "4D", "4E", "4F",
        "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5A", "5B", "5C", "5D", "5E", "5F",
        "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6A", "6B", "6C", "6D", "6E", "6F",
        "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7A", "7B", "7C", "7D", "7E", "7F",
        "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "8A", "8B", "8C", "8D", "8E", "8F",
        "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "9A", "9B", "9C", "9D", "9E", "9F",
        "A0", "A1", "A2", "A3", "A4", "A5", "A6", "A7", "A8", "A9", "AA", "AB", "AC", "AD", "AE", "AF",
        "B0", "B1", "B2", "B3", "B4", "B5", "B6", "B7", "B8", "B9", "BA", "BB", "BC", "BD", "BE", "BF",
        "C0", "C1", "C2", "C3", "C4", "C5", "C6", "C7", "C8", "C9", "CA", "CB", "CC", "CD", "CE", "CF",
        "D0", "D1", "D2", "D3", "D4", "D5", "D6", "D7", "D8", "D9", "DA", "DB", "DC", "DD", "DE", "DF",
        "E0", "E1", "E2", "E3", "E4", "E5", "E6", "E7", "E8", "E9", "EA", "EB", "EC", "ED", "EE", "EF",
        "F0", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "FA", "FB", "FC", "FD", "FE", "FF",};
            StringBuilder result = new StringBuilder(count * 2);
            int i = 0;
            for (; i < count; i++)
            {
                result.Append(hexStringTable[bytes[i]]);
            }
            return result.ToString();
        }
        public static byte[] Hex2Byte(string hex)
        {
            int numberChars = hex.Length;
            byte[] bytes = new byte[numberChars / 2];
            for (int i = 0; i < numberChars; i += 2)
                bytes[i / 2] = Convert.ToByte(hex.Substring(i, 2), 16);
            return bytes;
        }
    }


    public static class Win32Helper
    {
        #region Const
        public const int WM_SIZE = 0x0005;
        public const int WM_PAINT = 0x000F;

        public const int SW_HIDE = 0;
        public const int SW_SHOWNORMAL = 1;
        public const int SW_SHOWMINIMIZED = 2;
        public const int SW_SHOWMAXIMIZED = 3;
        public const int SW_SHOWNOACTIVATE = 4;
        public const int SW_SHOW = 5;
        public const int SW_MINIMIZE = 6;
        public const int SW_SHOWMINNOACTIVE = 7;
        public const int SW_SHOWNA = 8;
        public const int SW_RESTORE = 9;
        public const int SW_SHOWDEFAULT = 10;
        public const int SW_FORCEMINIMIZE = 11;
        #endregion

        [StructLayout(LayoutKind.Sequential)]
        public struct RECT
        {
            public int Left, Top, Right, Bottom;
        }

        [DllImport("kernel32.dll")]
        public static extern IntPtr LoadLibrary(string dllToLoad);

        [DllImport("user32.dll", EntryPoint = "CreateWindowExW", CharSet = CharSet.Unicode)]
        public static extern IntPtr CreateWindowExW(WindowStylesEx dwExStyle,
           string lpClassName, string lpWindowName, WindowStyles dwStyle,
           int x, int y, int nWidth, int nHeight,
           IntPtr hwndParent, IntPtr hMenu,
           IntPtr hInstance, IntPtr lpParam);

        [DllImport("user32.dll")]
        public static extern bool GetClientRect(IntPtr hwnd, out RECT lpRect);

        [DllImport("User32.dll")]
        public static extern bool MoveWindow(IntPtr hwnd, int x, int y, int width, int height, bool redraw);

        [DllImport("user32.dll")]
        public static extern bool ShowWindow(IntPtr hWnd, int nCmdShow);

        [DllImport("User32.dll")]
        public static extern IntPtr GetWindowDC(IntPtr hwnd);

        [DllImport("User32.dll")]
        public static extern int ReleaseDC(IntPtr hwnd, IntPtr hdc);

        #region msvcrt
        [DllImport("msvcrt.dll", EntryPoint = "memcpy", CallingConvention = CallingConvention.Cdecl, SetLastError = false)]
        public static extern IntPtr memcpy(IntPtr dest, IntPtr src, int count);

        [DllImport("msvcrt.dll", EntryPoint = "memset", CallingConvention = CallingConvention.Cdecl, SetLastError = false)]
        public static extern IntPtr memset(IntPtr dest, int c, int count);

        [DllImport("msvcrt.dll", EntryPoint = "malloc", CallingConvention = CallingConvention.Cdecl, SetLastError = false)]
        public static extern IntPtr malloc(uint size);

        [DllImport("msvcrt.dll", EntryPoint = "calloc", CallingConvention = CallingConvention.Cdecl, SetLastError = false)]
        public static extern IntPtr calloc(uint count, uint size);

        [DllImport("msvcrt.dll", EntryPoint = "free", CallingConvention = CallingConvention.Cdecl, SetLastError = false)]
        public static extern void free(IntPtr ptr);

        [DllImport("msvcrt.dll", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode, SetLastError = true)]
        public static extern IntPtr _wfopen(string filename, string mode);

        [DllImport("msvcrt.dll", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode, SetLastError = true)]
        public static extern IntPtr fclose(IntPtr ptr);

        [DllImport("msvcrt.dll", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode, SetLastError = true)]
        public static extern uint fwrite(IntPtr buffer, uint size, uint count, IntPtr ptr);

        [DllImport("msvcrt.dll", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode, SetLastError = true)]
        public static extern int fflush(IntPtr ptr);

        [DllImport("msvcrt.dll", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode, SetLastError = true)]
        public static extern uint fread(IntPtr buffer, uint size, uint count, IntPtr ptr);

        [DllImport("msvcrt.dll", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode, SetLastError = true)]
        public static extern int fseek(IntPtr ptr, int offset, int origin);

        [DllImport("msvcrt.dll", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode, SetLastError = true)]
        public static extern int _fseeki64(IntPtr ptr, Int64 offset, int origin);

        [DllImport("msvcrt.dll", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode, SetLastError = true)]
        public static extern int ftell(IntPtr ptr);

        public static Int64 _ftelli64(IntPtr ptr)
        {
            return _telli64(_fileno(ptr));
        }

        [DllImport("msvcrt.dll", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode, SetLastError = true)]
        public static extern int _fileno(IntPtr ptr);

        [DllImport("msvcrt.dll", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Unicode, SetLastError = true)]
        public static extern Int64 _telli64(int fd);

        #endregion
    }


    [Flags]
    public enum WindowStylesEx : uint
    {
        WS_EX_NONE = 0x00000000,

        WS_EX_ACCEPTFILES = 0x00000010,
        WS_EX_APPWINDOW = 0x00040000,
        WS_EX_CLIENTEDGE = 0x00000200,
        WS_EX_COMPOSITED = 0x02000000,
        WS_EX_CONTEXTHELP = 0x00000400,
        WS_EX_CONTROLPARENT = 0x00010000,
        WS_EX_DLGMODALFRAME = 0x00000001,
        WS_EX_LAYERED = 0x00080000,
        WS_EX_LAYOUTRTL = 0x00400000,
        WS_EX_LEFT = 0x00000000,
        WS_EX_LEFTSCROLLBAR = 0x00004000,
        WS_EX_LTRREADING = 0x00000000,
        WS_EX_MDICHILD = 0x00000040,
        WS_EX_NOACTIVATE = 0x08000000,
        WS_EX_NOINHERITLAYOUT = 0x00100000,
        WS_EX_NOPARENTNOTIFY = 0x00000004,
        WS_EX_OVERLAPPEDWINDOW = WS_EX_WINDOWEDGE | WS_EX_CLIENTEDGE,
        WS_EX_PALETTEWINDOW = WS_EX_WINDOWEDGE | WS_EX_TOOLWINDOW | WS_EX_TOPMOST,
        WS_EX_RIGHT = 0x00001000,
        WS_EX_RIGHTSCROLLBAR = 0x00000000,
        WS_EX_RTLREADING = 0x00002000,
        WS_EX_STATICEDGE = 0x00020000,
        WS_EX_TOOLWINDOW = 0x00000080,
        WS_EX_TOPMOST = 0x00000008,
        WS_EX_TRANSPARENT = 0x00000020,
        WS_EX_WINDOWEDGE = 0x00000100,
    }

    [Flags]
    public enum WindowStyles : uint
    {
        WS_BORDER = 0x800000,
        WS_CAPTION = 0xc00000,
        WS_CHILD = 0x40000000,
        WS_CLIPCHILDREN = 0x2000000,

        WS_CLIPSIBLINGS = 0x4000000,
        WS_DISABLED = 0x8000000,
        WS_DLGFRAME = 0x400000,

        WS_GROUP = 0x20000,
        WS_HSCROLL = 0x100000,
        WS_MAXIMIZE = 0x1000000,
        WS_MAXIMIZEBOX = 0x10000,
        WS_MINIMIZE = 0x20000000,
        WS_MINIMIZEBOX = 0x20000,
        WS_OVERLAPPED = 0x0,

        WS_POPUP = 0x80000000,

        WS_SIZEFRAME = 0x40000,
        WS_SYSMENU = 0x80000,
        WS_TABSTOP = 0x10000,
        WS_VISIBLE = 0x10000000,
        WS_VSCROLL = 0x200000,

        //
        WS_POPUPWINDOW = WS_POPUP | WS_BORDER | WS_SYSMENU,
        WS_OVERLAPPEDWINDOW = WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_SIZEFRAME | WS_MINIMIZEBOX | WS_MAXIMIZEBOX,
    }
}
