/*
其他示例代码: 单帧文件回放, 多帧文件回放, 特征温度提取, 电动镜头控制等
*/
#include <YoseenSDK/YoseenSDK.h>
#include <YoseenSDK/YoseenAlg_Strech.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

void test_frame(){
	//#1新建回放上下文,
	YoseenPlaybackContext* ctx = YoseenPlayback_Create();

	//#2打开文件, 每次只能打开一个文件, 但可以打开任意多次不同的文件
	s32 ret = YoseenPlayback_OpenFile(ctx, ".\\Data\\test.jpg", xxxmediafile_jpgx);

	//#3读取封面数据
	TempFrameFile tff = {};
	ret = YoseenPlayback_ReadCover(ctx, &tff);

	//#4读取温度数据, 会触发位图数据的生成
	DataFrame dataFrame = {};
	ret = YoseenPlayback_ReadFrame(ctx, 0, &dataFrame);

	//#修改图像算法, 再次读取文件数据
	strech_control sc = {};
	sc.flags = SCF_DDELevel;
	sc.dde_level = 1;
	s32 paletteType = xxxpalette_WhiteHot;
	YoseenPlayback_SetImage(ctx, &sc, &paletteType);
	ret = YoseenPlayback_ReadFrame(ctx, 0, &dataFrame);

	//#获取特征温度
	xxxrectangle mrect = {};
	mrect.xmin = 50; mrect.xmax = 150;
	mrect.ymin = 50; mrect.ymax = 150;
	xxxmeasure_result mresult = {};
	Alg_MeasureRectangle(&mrect, (DataFrameHeader*)dataFrame.Head, (s16*)dataFrame.Temp, &mresult);

	//#修改custom16k区域, 修改封面数据, 保存新文件
	memset(tff.custom, 1, 16 * 1024);
	tff.coverImageSize = 0;//删除封面
	ret = YoseenPlayback_SaveFile(ctx, &tff, ".\\Data\\test_save.jpg");

	//#5关闭文件
	YoseenPlayback_CloseFile(ctx);

	//#6释放回放上下文
	YoseenPlayback_Free(&ctx);
}

void test_stream(){
	//#1新建回放上下文,
	YoseenPlaybackContext* ctx = YoseenPlayback_Create();

	//#2打开文件, 每次只能打开一个文件, 但可以打开任意多次不同的文件
	s32 ret = YoseenPlayback_OpenFile(ctx, ".\\Data\\test.stream", xxxmediafile_stream);

	//#3读取封面数据
	TempFrameFile tff = {};
	ret = YoseenPlayback_ReadCover(ctx, &tff);

	stream_file_header* sfh = (stream_file_header*)tff.ffh;
	s32 frameCount = sfh->frame_count;

	//#4读取温度数据, 会触发位图数据的生成
	DataFrame dataFrame = {};
	ret = YoseenPlayback_ReadFrame(ctx, frameCount/2, &dataFrame);

	//#5关闭文件
	YoseenPlayback_CloseFile(ctx);

	//#6释放回放上下文
	YoseenPlayback_Free(&ctx);
}

void test_focus(){
	//位置记忆, 设置位置
	//刻度0代表1.5米对焦位置, 刻度1000代表最远对焦位置, 误差+-10
	s32 userHandle = -1;
	CtlX ctlx = {};
	ctlx.Type = CtlXType_XfMove;
	ctlx.Data.XfMove = 800;//刻度值[0-1000]
	s32 ret = Yoseen_SendControlX(userHandle, &ctlx);

	//位置记忆, 获取位置
	ctlx.Type = CtlXType_XfGetCur;
	ctlx.Data.XfCurType = 1;//1代表刻度值[0-1000]
	ret = Yoseen_SendControlX(userHandle, &ctlx);
	s32 cur = ctlx.Data.XfCurType;

	//位置记忆, 重置位置, 镜头回到对焦距离最近的点(并非刻度值0点)
	//镜头聚焦到到最近端和最远端, 会引起机械限位(存在随机误差), 会增加设置位置的误差，复位能消除此误差
	//刻度值[0-1000]并非对应镜头最近端和最远端, 一般不会引起机械限位. 
	ctlx.Type = CtlXType_XfReset;
	ret = Yoseen_SendControlX(userHandle, &ctlx);

	//位置记忆, 检测过冲, 电源适配器输出电压存在个体差异, 影响电机转动惯性, 增加设置位置的误差
	//做一次过冲检测, 自动测量获取过冲参数, 可消除此误差. ！！！不必每次上电都做.
	ctlx.Type = CtlXType_XfCheckDelta;
	ret = Yoseen_SendControlX(userHandle, &ctlx);

	//自动对焦
	ctlx.Type = CtlXType_AutoFocus;
	ctlx.Data.FocusRect.xmin = 100;
	ctlx.Data.FocusRect.xmax = 200;
	ctlx.Data.FocusRect.ymin = 100;
	ctlx.Data.FocusRect.ymax = 200;
	ret = Yoseen_SendControlX(userHandle, &ctlx);
}

void test(){
	//设置温度流预览，图像效果，开启DDE
	s32 previewHandle = -1;
	s32 paletteType = -1;
	strech_control sc = {};
	sc.flags = SCF_DDELevel;
	sc.dde_level = 1;
	s32 ret = Yoseen_PreviewSetImage(previewHandle, &sc, paletteType);
}
