package Test;

import Yoseen.YoseenData;
import Yoseen.YoseenSDK;
import Yoseen.YoseenUtil;

import javax.crypto.spec.PSource;

/**********************************************************************************************
 *
 * TestYoseenDevice_PTZ
 *
 *
 **********************************************************************************************/
public class TestYoseenDevice_PTZ {
    public static void main(String[] args) {
        String dddDebug = YoseenSDK.getDebugDir();
        int ret;

        //init sdk
        ret = YoseenSDK.YoseenDevice.initSDK();
        YoseenSDK.YoseenDevice device = new YoseenSDK.YoseenDevice();

        //login
        ret = device.login("192.168.1.215");

        //B160 发送4字节串口指令
        String reqStr = "00a00000";
        byte[] respBytes = new byte[4];
        device.ptzControl_B160_W4R4(reqStr, respBytes);
        System.out.println("reqStr = " + reqStr);
        System.out.println("respStr = " + YoseenUtil.bytes2HexStr(respBytes));

        //B160 设置补光灯亮度
        ret = device.ptzControl(YoseenData.PtzAction_B160_Backlight, 100);


        //move and stop
        try {
            ret = device.ptzControl(YoseenData.PtzAction_MoveLeft, 100);
            Thread.sleep(2000);
            ret = device.ptzControl_Stop(YoseenData.PtzAction_MoveLeft, 100);
            Thread.sleep(2000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //get ptz
        int[] ptz = new int[3];
        ret = device.ptzControl_GetPtz(ptz, 1000);

        System.out.println("ptz[0] = " + ptz[0]);
        System.out.println("ptz[1] = " + ptz[1]);
        System.out.println("ptz[2] = " + ptz[2]);

        //set ptz
//        ret = device.ptzControl_SetPtz(ptz, 100);

        //logout
        device.logout();

        //free sdk
        YoseenSDK.YoseenDevice.freeSDK();
    }
}
