package Yoseen;

import java.util.regex.Pattern;

public class YoseenUtil {
    //////////////////////////////////////////////////////////////////////////////////////////////////////

    //
    public static final int xxxdatatype_temp = 2;
    public static final int xxxdatatype_video = 3;

    //
    public static final int xxxmediafile_bmpx = 0;
    public static final int xxxmediafile_pngx = 1;
    public static final int xxxmediafile_stream = 2;
    public static final int xxxmediafile_mp4 = 3;
    public static final int xxxmediafile_jpgx = 4;

    public static final int xxxpalette_Autumn = 0;
    public static final int xxxpalette_BlackHot = 1;
    public static final int xxxpalette_GlowBow = 2;
    public static final int xxxpalette_HighContrast = 3;
    public static final int xxxpalette_HotMetal = 4;
    public static final int xxxpalette_IronBow = 5;
    public static final int xxxpalette_Jet = 6;
    public static final int xxxpalette_RainBow = 7;
    public static final int xxxpalette_RedSaturation = 8;
    public static final int xxxpalette_WhiteHot = 9;
    public static final int xxxpalette_Winter = 10;
    public static final int xxxpalette_IronBow2 = 11;

    //
    public static final int xxxcameramem_measure = 0;

    //
    public static final int xxxmeasuretype_point = 0;
    public static final int xxxmeasuretype_line = 1;
    public static final int xxxmeasuretype_rectangle = 2;
    public static final int xxxmeasuretype_ellipse = 3;
    public static final int xxxmeasuretype_polyline = 4;
    public static final int xxxmeasuretype_polygon = 5;

    //
    public static String IpInt2Str(int ipInt) {
        String s0 = Integer.toString(ipInt & 0x000000ff);
        String s1 = Integer.toString((ipInt & 0x0000ff00) >> 8);
        String s2 = Integer.toString((ipInt & 0x00ff0000) >> 16);
        String s3 = Integer.toString((ipInt >> 24) & 0x000000ff);
        return s3 + "." + s2 + "." + s1 + "." + s0;
    }

    public static int IpStr2Int(String ipStr) {
        String[] parts = ipStr.split("\\.");
        int[] tmp = new int[4];
        for (int i = 0; i < 4; i++) {
            tmp[i] = Integer.parseInt(parts[i]);
        }

        int ipInt = (tmp[0] << 24) | (tmp[1] << 16) | (tmp[2] << 8) | tmp[3];
        return ipInt;
    }

    public static int String2Bytes(String s, byte[] bytes, int bytesCount) {
        byte[] bytes2 = s.getBytes();
        int len = bytes2.length;
        if (len >= bytesCount) return EError.EError_InvalidArgs;

        int i;
        for (i = 0; i < len; i++) {
            bytes[i] = bytes2[i];
        }
        bytes[i] = 0;
        return 0;
    }

    public static float Bytes2Float(byte[] data, int offset) {
        int x = (data[offset] & 0xff) | (data[offset + 1] & 0xff) << 8 | (data[offset + 2] & 0xff) << 16 | (data[offset + 3] & 0xff) << 24;
        return Float.intBitsToFloat(x);
    }

    public static boolean hexStr2Integers(String hexStr, int[] integers) {
        boolean b = hexStr.matches("^[0-9A-Fa-f]{8}$");
        if (!b) {
            return false;
        }
        long l = Long.parseLong(hexStr, 16);
        integers[0] = (int) l;
        return true;
    }

    public static byte[] int2Bytes(int i) {
        byte[] bytes = new byte[4];
        bytes[3] = (byte) (i >> 24);
        bytes[2] = (byte) (i >> 16);
        bytes[1] = (byte) (i >> 8);
        bytes[0] = (byte) i;

        return bytes;

    }

    public static String bytes2HexStr(byte[] bytes) {
        StringBuilder stringBuilder = new StringBuilder();
        if (null != bytes && 0 < bytes.length) {
            for (int i = 0; i < bytes.length; i++) {
                String hexStr = Integer.toHexString(bytes[i] & 0xFF).toLowerCase();
                if (hexStr.length() < 2) {
                    stringBuilder.append("0");
                }
                stringBuilder.append(hexStr);
            }
        }
        return stringBuilder.toString();
    }
}
