#############################################################################
gbl_arch:=$(ARCH)
gbl_workdir=$(shell pwd)/..#YoseenSDK_Linux

#build
gbl_builddir=$(gbl_workdir)/YoseenBuild/build-$(ARCH)#

#sdk include+library
gbl_sdkinc=$(gbl_workdir)/SDK
gbl_sdklib=$(gbl_workdir)/SDK/YoseenSDK/$(ARCH)

#############################################################################
#linux, x64, x86
ifeq ($(ARCH),x64)
COMPILER_PREFIX=
gbl_sysroot=
gbl_isandroid=0

else ifeq ($(ARCH),x86)
COMPILER_PREFIX=
gbl_sysroot=
gbl_isandroid=0

#linux, arm
else ifeq ($(ARCH),armhf)
COMPILER_PREFIX=/home/duwu/arm-linux/x4418/buildroot-2015.05/output/host/usr/bin/arm-linux-gnueabihf-
gbl_sysroot=
gbl_isandroid=0

else ifeq ($(ARCH),arm64)
COMPILER_PREFIX=/home/duwu/arm-linux/gcc-linaro-7.3.1-2018.05-x86_64_aarch64-linux-gnu/bin/aarch64-linux-gnu-
gbl_sysroot=
gbl_isandroid=0

#android, arm
else ifeq ($(ARCH),android-19-arm32)
COMPILER_PREFIX=/home/duwu/arm-linux/android-ndk-r15c/toolchains/arm-linux-androideabi-4.9/prebuilt/linux-x86_64/bin/arm-linux-androideabi-
gbl_sysroot=/home/duwu/arm-linux/android-ndk-r15c/platforms/android-19/arch-arm
gbl_isandroid=0

else ifeq ($(ARCH),android-21-arm64)
COMPILER_PREFIX=/home/duwu/arm-linux/android-ndk-r15c/toolchains/aarch64-linux-android-4.9/prebuilt/linux-x86_64/bin/aarch64-linux-android-
gbl_sysroot=/home/duwu/arm-linux/android-ndk-r15c/platforms/android-21/arch-arm64
gbl_isandroid=1

#hisiv600
else ifeq ($(ARCH),hisiv600)
COMPILER_PREFIX=/opt/hisi-linux/x86-arm/arm-hisiv600-linux/bin/arm-hisiv600-linux-gnueabi-
gbl_sysroot=
gbl_isandroid=0

#kylin_phytium=linux_arm64
else ifeq ($(ARCH),kylin_phytium)
COMPILER_PREFIX=
gbl_sysroot=
gbl_isandroid=0

#kylin_loongarch=linux_loongarch
else ifeq ($(ARCH),kylin_loongarch)
COMPILER_PREFIX=
gbl_sysroot=
gbl_isandroid=0

else
endif

#############################################################################
CC=${COMPILER_PREFIX}gcc
CXX=${COMPILER_PREFIX}g++
LD=${COMPILER_PREFIX}g++
AS=${COMPILER_PREFIX}as
AR=${COMPILER_PREFIX}ar

STRIP=${COMPILER_PREFIX}strip

ifeq ($(gbl_isandroid),1) 
CFLAGS:= --sysroot=${gbl_sysroot} -DANDROID -D__STDC_CONSTANT_MACROS 
CXXFLAGS:= -std=c++11
LDFLAGS:= --sysroot=${gbl_sysroot} 

else 
CFLAGS:=
CXXFLAGS:= -std=c++11
LDFLAGS:=
endif 

LDFLAGS+= -Wl,-rpath,'$$ORIGIN'

ARFLAGS=-r

#############################################################################
RM=rm -rf
MKDIR=mkdir -p
CP=cp
LN=ln

################################################################################
# SRCS -> OBJS
# SRCS_C -> OBJS_C
# SRCS_ASM -> OBJS_ASM
################################################################################
OBJS = $(patsubst %.cpp, %.o, $(addprefix $(cfg_builddir)/,$(SRCS)))
OBJS_C = $(patsubst %.c, %.o, $(addprefix $(cfg_builddir)/,$(SRCS_C)))
OBJS_ASM = $(patsubst %.s, %.o, $(addprefix $(cfg_builddir)/,$(SRCS_ASM)))