/*******************************************************************************************************
 * BoxTypes.h
 *
 * 2023-04-30: init
 *
 *
 *
 ********************************************************************************************************/
#ifndef BOXTYPES_H_
#define BOXTYPES_H_

#include "../yc_type.h"

/////////////////////////////////////////////////////////////////////////////////////////////////////////
//
typedef struct _BoxBasicInfo{
	char BoxId[32];
	char BoxName[32];
	char BoxType[16];
	char pad[32];
	char HardwareId[32];
	char SoftwareId[32];
	char reserved[40];
}BoxBasicInfo;

typedef struct _BoxNetworkInfo {
    u8 UseStaticIp;
    u8 pad;
    u16 MulticastPort;
    u32 StaticIp;
    u32 SubnetMask;
    u32 Gateway;
    u32 MulticastIp;
    u8 MacAddr[6];
    u16 Mtu;						///< 576, 1500, 9000
    u32 Dns;
    u32 Dns2;
    u8 reserved[16];
}BoxNetworkInfo;

typedef struct _BoxTimeInfo {
    char	NtpServer[32];
    char	NtpServer2[32];
    char	TimeZone[32];
    u8		reserved[32];
}BoxTimeInfo;

typedef struct _BoxInputInfo{
	char        rtspAddr[128];
    u16         timeout;//s, 10
    u16         transType;//0 tcp, 1 udp
	char        reserved[512-132];
}BoxInputInfo;

typedef struct _BoxOutputInfo{
    //h264
	s32 h264_bitrate;//kbps
	s32 h264_gopSize;//

    //alarm
    u16 alarm_enable;
    u16 alarm_interval;//s
    char alarm_serverIp[128];
    u16 alarm_serverPort;
    u16 alarm_serverTimeout;//s
	char reserved[512-144];
}BoxOutputInfo;

typedef struct _BoxAlgInfo{
    s32 enable;
	float box_threshold;//0.25
	float nms_threshold;//0.45
	s32 sub_t;//4
	char reserved[512-16];
}BoxAlgInfo;

/////////////////////////////////////////////////////////////////////////////////////////////////////////
//
enum BoxFileType{
	BoxFileType_bin		=	0,
	BoxFileType_log		=	3,
	BoxFileType_model	=	100,
};
enum BoxMemType{
	BoxMemType_start	=	100,
};





#endif
