using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Windows.Forms;

using yoseen = YoseenSDKCS;

namespace YoseenDemoCustomDraw
{
    static class Program
    {
        [STAThread]
        static void Main()
        {
            string logFileName = AppPaths.Exe + "\\YoseenDemo.log";
            Trace.Listeners.Add(new TextWriterTraceListener(logFileName));
            Trace.AutoFlush = true;
            try
            {
                int error = yoseen.YoseenSDK.Yoseen_InitSDK();
                if (error < 0) throw new Exception(string.Format("Yoseen_InitSDK, ret {0}.", error));

                Application.EnableVisualStyles();
                Application.SetCompatibleTextRenderingDefault(false);
                Application.Run(new ShellView());

                yoseen.YoseenSDK.Yoseen_FreeSDK();
            }
            catch (Exception e)
            {
                Trace.WriteLine(e);
                MessageBox.Show(e.Message);
            }
        }
    }

    static class AppPaths
    {
        static string _exe;
        public static string Exe
        {
            get
            {
                if (_exe == null)
                {
                    _exe = Path.GetDirectoryName(Assembly.GetEntryAssembly().Location);
                }
                return AppPaths._exe;
            }
        }

        static string _config;
        public static string Config
        {
            get
            {
                if (_config == null)
                {
                    _config = Exe + "\\Config";
                }
                return AppPaths._config;
            }
        }

        static string _data;
        public static string Data
        {
            get
            {
                if (_data == null)
                {
                    _data = Exe + "\\Data";
                }
                return AppPaths._data;
            }
        }
    }
}
