﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;

namespace YoseenSDKCS
{
    /// <summary>
    /// png文件数据
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    public struct TempFrameFile
    {
        /// <summary>
        /// 帧文件头
        /// </summary>
        public IntPtr ffh;

        /// <summary>
        /// 用户数据区, 大小16*1024
        /// </summary>
        public IntPtr custom;

        /// <summary>
        /// 温度数据头
        /// </summary>
        public IntPtr dfh;

        /// <summary>
        /// 温度数据区
        /// </summary>
        public IntPtr dfd;

        /// <summary>
        /// 可见光图像文件数据区
        /// </summary>
        public IntPtr visiImage;

        /// <summary>
        /// 封面图像文件数据区
        /// </summary>
        public IntPtr coverImage;

        /// <summary>
        /// 可见光图像文件数据大小
        /// </summary>
        public int visiImageSize;

        /// <summary>
        /// 封面图像文件数据大小
        /// </summary>
        public int coverImageSize;
    }


    /// <summary>
    /// 温度帧文件头
    /// </summary>
    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi, Size = 128)]
    public struct frame_file_header
    {
        /// <summary>
        /// 热像仪序列号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
        public string camera_id;

        /// <summary>
        /// 拍摄时间
        /// </summary>
        public Int64 captured_time;

        /// <summary>
        /// 宽度
        /// </summary>
        public UInt16 width;

        /// <summary>
        /// 高度
        /// </summary>
        public UInt16 height;

        /// <summary>
        /// 修正信息
        /// </summary>
        public FixInfo fix_info;

        /// <summary>
        /// 调色板
        /// </summary>
        public byte palette;
    }

    /// <summary>
    /// 温度流文件头
    /// </summary>
    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi, Size = 128)]
    public struct stream_file_header
    {
        /// <summary>
        /// 热像仪序列号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
        public string camera_id;

        /// <summary>
        /// 拍摄时间
        /// </summary>
        public Int64 captured_time;

        /// <summary>
        /// 宽度
        /// </summary>
        public UInt16 width;

        /// <summary>
        /// 高度
        /// </summary>
        public UInt16 height;

        /// <summary>
        /// 修正信息
        /// </summary>
        public FixInfo fix_info;

        /// <summary>
        /// 帧率分子
        /// </summary>
        public ushort fps_num;

        /// <summary>
        /// 帧率分母
        /// </summary>
        public ushort fps_den;

        /// <summary>
        /// 帧数
        /// </summary>
        public UInt32 frame_count;

        /// <summary>
        /// 调色板
        /// </summary>
        public byte palette;

        public byte pad;

        /// <summary>
        /// 录制率
        /// </summary>
        public short record_ratio;
    }


    /// <summary>
    /// ptc_custom
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    public struct ptc_custom
    {
        public const int Const_Version = 20191204;

        public int version;
        public int palette;
        public strech_control sc;
        public MeasureTemplate mt;
    }

    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi, Size = 128)]
    public struct bs_file_header
    {
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
        public string camera_id;
        public Int64 captured_time;
        public UInt16 width;
        public UInt16 height;

        public Int32 env_temp;
        public Int32 blackbody_temp;

        public Byte frames_acced;
    }
}
