/*******************************************************************************************************
* BoxSDK.h
*
*
*
*
*
********************************************************************************************************/
#ifndef BOXSDK_H_
#define BOXSDK_H_

#include "BoxTypes.h"

/////////////////////////////////////////////////////////////////////////////////////////////////////////
//AlarmData

//AlarmDataType
#define MAP_AlarmDataType(XX)   \
XX(0, None, None)\
XX(1, SmokeFirePerson, SmokeFirePerson)
enum AlarmDataType {
#define XX(num, name, string)   AlarmDataType_##name = num,
    MAP_AlarmDataType(XX)
#undef XX
};

//AlarmPartType
#define MAP_AlarmPartType(XX)   \
XX(0, None, none)\
XX(1, ALG, alg)\
XX(2, TXT, txt)\
XX(3, JPG, jpg)\
XX(4, MP4, mp4)
enum AlarmPartType {
#define XX(num, name, string)   AlarmPartType_##name = num,
    MAP_AlarmPartType(XX)
#undef XX
};

//
#define AlarmData_HeadSize			512
#define AlarmData_PartCount         4
#define AlarmData_SizeMin			AlarmData_HeadSize
#define AlarmData_SizeMax			(16*1024*1024)
struct AlarmDataHead {
    s32 size;//head+part*
    s32 type;
    char sender_name[64];
    s64 sender_timestamp;
    s64 recver_timestamp;
    s32 part_sizeArray[AlarmData_PartCount];
    u8 part_typeArray[AlarmData_PartCount];
    u8 reserved[AlarmData_HeadSize - 108];
};

extern "C" {
    SDK_API const char* AlarmDataType_num2str(s32 num);
    SDK_API s32 AlarmData_Save(AlarmDataHead* data, const char* dir, s32 split, char* fnPrefix, s32 fnPrefixLen);
    SDK_API AlarmDataHead* AlarmData_Create(AlarmDataHead* head, void** partDataArray, s32* partSizeArray, u8* partTypeArray);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////
//AlarmServer
typedef struct _AlarmServerConfig {
    char ip[16];
    u16 port;
    u16 timeout;
    u8	pad[20];
}AlarmServerConfig;
typedef void(__stdcall* AlarmServerCallback)(s32 errorCode, AlarmDataHead* alarmData, void* customData);

//
struct _AlarmServer;
typedef struct _AlarmServer AlarmServer;
extern "C" {
    SDK_API AlarmServer* AlarmServer_Create();
    SDK_API void AlarmServer_Free(AlarmServer** pp);
    SDK_API s32 AlarmServer_Start(AlarmServer* context, AlarmServerConfig* config, AlarmServerCallback cbFunc, void* cbData);
    SDK_API void AlarmServer_Stop(AlarmServer* context);
    SDK_API s32 AlarmServer_FreeData(AlarmServer* context, AlarmDataHead* data);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////
//AlarmClient
typedef struct _AlarmClientConfig {
    char serverIp[16];
    u16 serverPort;
    u16 timeout;

    u16 cacheSize;
    u8	pad[18];
}AlarmClientConfig;
typedef void(__stdcall* AlarmClientCallback)(s32 errorCode, AlarmDataHead* alarmData, void* customData);

//
struct _AlarmClient;
typedef struct _AlarmClient AlarmClient;
extern "C" {
    SDK_API AlarmClient* AlarmClient_Create();
    SDK_API void AlarmClient_Free(AlarmClient** pp);
    SDK_API s32 AlarmClient_Start(AlarmClient* context, AlarmClientConfig* config, AlarmClientCallback cbFunc, void* cbData);
    SDK_API void AlarmClient_Stop(AlarmClient* context);
    SDK_API s32 AlarmClient_PostData(AlarmClient* context, AlarmDataHead* data);
}

#endif
