package Test;

import Yoseen.YoseenData;
import Yoseen.YoseenSDK;
import Yoseen.YoseenUtil;
import com.sun.jna.Pointer;

/**********************************************************************************************
 *
 * TestYoseenDevice
 *
 *
 **********************************************************************************************/
public class TestYoseenDevice {
    public static void main(String[] args) {
        String dddDebug = YoseenSDK.getDebugDir();
        int ret;

        //InitSDK
        ret = YoseenSDK.YoseenDevice.initSDK();
        YoseenSDK.YoseenDevice device = new YoseenSDK.YoseenDevice();

        //Login
        ret = device.login("192.168.1.204");

        //Control
        YoseenData.Ctl ctl = new YoseenData.Ctl();
        //ctl.setFocusInfo(100, 100, 200, 200);
        //ret=device.sendControl(ctl);

        //
        ctl.setManualFFC();
        ret = device.sendControl(ctl);

        //
        String imagePath = dddDebug + YoseenSDK.FileSeperator + "Data" + YoseenSDK.FileSeperator + "test.jpg";
        ret = device.saveFrame(imagePath);

        //Config
        YoseenData.CameraBasicInfo basicInfo = new YoseenData.CameraBasicInfo();
        ret = device.get_CameraBasicInfo(basicInfo);

        //StartPreview, StopPreview
        YoseenData.YoseenPreviewCallback previewCallback = new YoseenData.YoseenPreviewCallback() {
            int _count = 0;

            public void callback(int errorCode, long dataFrame, long customData) {
                if (0 == errorCode) {
                    Pointer p = new Pointer(dataFrame);
                    YoseenData.DataFrame frame = new YoseenData.DataFrame();
                    frame.Head = p.getLong(0);
                    frame.Temp = p.getLong(8);
                    frame.Bmp = p.getLong(24);
                } else {

                }
                _count++;
            }
        };
        YoseenData.YoseenPreviewInfo previewInfo = new YoseenData.YoseenPreviewInfo();
        previewInfo.DataType = YoseenUtil.xxxdatatype_video;
        previewInfo.CustomCallback = previewCallback;
        ret = device.startPreview(YoseenUtil.xxxdatatype_video, previewCallback);
        if (0 == ret) {
            String videoPath = dddDebug + YoseenSDK.FileSeperator + "Data" + YoseenSDK.FileSeperator + "test.mp4";
            ret = device.beginSave(videoPath, YoseenUtil.xxxmediafile_mp4);
            try {
                //wait
                Thread.sleep(5000);
                device.endSave(YoseenUtil.xxxmediafile_mp4);

                //wait
                Thread.sleep(5000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        device.stopPreview();

        //Logout
        device.logout();

        //FreeSDK
        YoseenSDK.YoseenDevice.freeSDK();
    }
}
