#ifndef MAINWINDOW_H
#define MAINWINDOW_H

//
#include <QMainWindow>
#include <QPushButton>
#include <QLineEdit>
#include <QTextEdit>
#include <QString>
#include <QComboBox>

//
#include "Device.h"
#include "DeviceCanvas.h"

//
class Device;
class DeviceCanvas;

QT_BEGIN_NAMESPACE
namespace Ui { class MainWindow; }
QT_END_NAMESPACE

class MainWindow : public QMainWindow{
    Q_OBJECT
public:
    MainWindow(QWidget *parent = nullptr);
    ~MainWindow() override;

private:
    void initUI();
protected:
    void resizeEvent(QResizeEvent *event) override;

private:
    Ui::MainWindow *ui;

    int             m_flags;
    Device*   m_device;

    //0
    DeviceCanvas*     deviceCanvas;

    //1
    QPushButton*    btnUrl;
    QLineEdit*      txtUrl;
    //2
    QPushButton*    btnLogin;
    QPushButton*    btnPlayVideo;
    QPushButton*    btnPlayTemp;
    QPushButton*    btnStop;
    //3
    QPushButton*    btnSaveJpg;
    QPushButton*    btnSaveMp4;
    QPushButton*    btnSaveStream;
    QComboBox*      cmbTest;
    QPushButton*    btnTest;
    //4
    QTextEdit*      txtEcho;

private slots:
    void btnUrl_clicked();
    void btnLogin_clicked();
    void btnPlayVideo_clicked();
    void btnPlayTemp_clicked();
    void btnStop_clicked();
    void btnSaveJpg_clicked();
    void btnSaveMp4_clicked();
    void btnSaveStream_clicked();
    void btnTest_clicked();
    void device_frameRecved(int errorCode, DataFrame* dataFrame);
    void device_gpioInputChanged(int oldValue, int newValue);
};
#endif // MAINWINDOW_H
