#include "YoseenCamera.h"

/*
调试打印
*/
#define _CRT_SECURE_NO_WARNINGS
#include <stdio.h>
#include <conio.h>
#define UTILLOG(format, ...) printf("\n###%s, %05d:\n"format, __FUNCTION__, __LINE__, ##__VA_ARGS__)

/*
数据接收回调实现
*/
static void __stdcall _FrameRecved(YoseenCamera* camera, DataFrame* dataFrame){
	static u32 _calls = 0;

	DataFrameHeader* dfh = (DataFrameHeader*)dataFrame->Head;
	s16* temp = (s16*)dataFrame->Temp;
	s32* bmp = (s32*)dataFrame->Bmp;
	////打印帧索引
	//printf("%d, ", header->Index);
	//if (_calls++ % 10 == 0){
	//	printf("\n");
	//}
}

/*
连接改变回调实现
*/
static void __stdcall _ConnectChanged(YoseenCamera* camera, s32 state){
	printf("\nConnectChanged, state %d\n", state);
}

/*
测试程序
*/
#define YoseemDemo_Menu	"1: start preview\n"\
	"2: stop preview\n"\
	"3: manual ffc\n"\
	"q: quit\n"

int main(int argc, char *argv[]){
	char* ipAddr = "192.168.1.83";
	if (argc == 2){
		ipAddr = argv[1];
	}
	printf(YoseemDemo_Menu);

	//初始化SDK, 新建设备对象, 登入
	s32 ret = YoseenCamera::InitSDK();
	if (ret < 0)return -1;
	YoseenCamera* camera = new YoseenCamera();
	ret = camera->Login(ipAddr);
	if (ret < 0)return -2;

	//
	while (1){
		if (_kbhit()){
			char ch = _getch();
			switch (ch){
				//开始温度流预览
			case '1':
				ret = camera->StartPreview(_FrameRecved, _ConnectChanged);
				printf("\nStartPreview, ret %d\n", ret);
				break;

				//结束温度流预览
			case '2':
				camera->StopPreview();
				break;

				//手动挡板校零
			case '3':
				ret = camera->ManualFFC();
				printf("\nManualFFC, ret %d\n", ret);
				break;

			case 'q':
				camera->StopPreview();
				goto error1;

			default:
				break;
			}
		}
	}

error1:
	//销毁设备对象, 释放SDK
	delete camera;
	YoseenCamera::FreeSDK();
	return 0;
}