﻿/*
其他示例代码: 单帧文件回放, 多帧文件回放, 特征温度提取, 电动镜头控制等
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;

using yoseen = YoseenSDKCS;

namespace YoseenDemoWinForm
{
    class test
    {
        public static void test_frame()
        {
            int ret;

            //#1新建回放上下文, 
            IntPtr ctx = yoseen.YoseenPlayback.YoseenPlayback_Create();

            //#2打开文件, 每次只能打开一个文件, 但可以打开任意多次不同的文件
            ret = yoseen.YoseenPlayback.YoseenPlayback_OpenFile(ctx, ".\\Data\\test.jpg", (int)yoseen.xxxmediafile.jpgx);

            //#3读取封面数据
            yoseen.TempFrameFile tff = new yoseen.TempFrameFile();
            ret = yoseen.YoseenPlayback.YoseenPlayback_ReadCover(ctx, ref tff);

            //4读取温度数据, 读取会触发位图数据的生成
            yoseen.DataFrame dataFrame = new yoseen.DataFrame();
            ret = yoseen.YoseenPlayback.YoseenPlayback_ReadFrame(ctx, 0, ref dataFrame);

            //#修改图像算法, 再次读取文件数据
            yoseen.strech_control sc = new yoseen.strech_control();
            sc.change_type = yoseen.StrechControlFlags.SCF_DDELevel;
            sc.dde_level = 1;
            int paletteType = (int)yoseen.xxxpalette.WhiteHot;
            yoseen.YoseenPlayback.YoseenPlayback_SetImage(ctx, ref sc, ref paletteType);
            ret = yoseen.YoseenPlayback.YoseenPlayback_ReadFrame(ctx, 0, ref dataFrame);

            //#获取特征温度
            yoseen.xxxmeasure mea = yoseen.xxxmeasure.Create();
            yoseen.xxxresult result = new yoseen.xxxresult();
            mea.measuretype = yoseen.xxxmeasuretype.rectangle;
            ushort[] xydata = mea.xydata;
            xydata[0] = 50; xydata[1] = 50;
            xydata[2] = 100; xydata[3] = 100;

            ret = yoseen.YoseenAlg.mtGetResult(dataFrame.Head, dataFrame.Temp, ref mea, ref result);

            //#修改custom16k区域, 修改封面, 保存新文件
            yoseen.Win32Helper.memset(tff.custom, 1, 16 * 1024);
            tff.coverImageSize = 0;//删除封面
            ret = yoseen.YoseenPlayback.YoseenPlayback_SaveFile(ctx, ref tff, ".\\Data\\test_save.jpg");

            //#4关闭文件
            yoseen.YoseenPlayback.YoseenPlayback_CloseFile(ctx);

            //#5释放回放上下文
            yoseen.YoseenPlayback.YoseenPlayback_Free(ref ctx);
        }

        public static void test_stream()
        {
            int ret;

            //#1新建回放上下文, 
            IntPtr ctx = yoseen.YoseenPlayback.YoseenPlayback_Create();

            //#2打开文件, 每次只能打开一个文件, 但可以打开任意多次不同的文件
            ret = yoseen.YoseenPlayback.YoseenPlayback_OpenFile(ctx, ".\\Data\\test.stream", (int)yoseen.xxxmediafile.stream);

            //#3读取封面数据
            yoseen.TempFrameFile tff = new yoseen.TempFrameFile();
            ret = yoseen.YoseenPlayback.YoseenPlayback_ReadCover(ctx, ref tff);

            yoseen.stream_file_header sfh = (yoseen.stream_file_header)Marshal.PtrToStructure(tff.ffh, typeof(yoseen.stream_file_header));
            int frameCount = (int)sfh.frame_count;

            //#读取温度数据, 位图数据重新生成
            yoseen.DataFrame dataFrame = new yoseen.DataFrame();
            ret = yoseen.YoseenPlayback.YoseenPlayback_ReadFrame(ctx, frameCount / 2, ref dataFrame);

            //#4关闭文件
            yoseen.YoseenPlayback.YoseenPlayback_CloseFile(ctx);

            //#5释放回放上下文
            yoseen.YoseenPlayback.YoseenPlayback_Free(ref ctx);
        }

        public unsafe static void test_unsafe()
        {
            yoseen.DataFrame dataFrame = new yoseen.DataFrame();

            yoseen.DataFrameHeader dfh = (yoseen.DataFrameHeader)Marshal.PtrToStructure(dataFrame.Head, typeof(yoseen.DataFrameHeader));
            int width = dfh.Width;
            int height = dfh.Height;
            int pixels = width * height;
            short* dfd = (short*)dataFrame.Temp.ToPointer();

            short* dfd_end = dfd + pixels;

            short* pmax = dfd;
            short* pdfd = dfd;
            while (pdfd < dfd_end)
            {
                if ((*pdfd) < (*pmax))
                {
                    pmax = pdfd;
                }
                pdfd++;
            }

            //
            int index = (int)(pmax - dfd);
            int maxX = index % width;
            int maxY = index / width;
            int maxTemp = *pmax;
            float maxTempFloat = (float)maxTemp / (float)dfh.Slope + dfh.Offset;
        }

        static void test_save()
        {
            ////get from camera
            //yoseen.TempFrameFile tff;
            //IntPtr coverImage = tff.coverImage;
            //int coverImageSize = tff.coverImageSize;

            ////save mem to file
            //IntPtr ptr = yoseen.Win32Helper._wfopen("d:\\test.jpg", "wb");
            //yoseen.Win32Helper.fwrite(coverImage, (uint)coverImageSize, 1, ptr);
            //yoseen.Win32Helper.fclose(ptr);
        }

    }
}
