/*********************************************************************************************************
* XMea.h
* 2023-10-01: init
*
*********************************************************************************************************/
#ifndef XXX_XMEA_H_
#define XXX_XMEA_H_

#include <YoseenSDK/YoseenDeviceTypes.h>

enum XMeaType {
    XMeaType_None = 0,

    //point
    XMeaType_Point1x1,
    XMeaType_Point3x3,
    XMeaType_PointCross,

    //line
    XMeaType_Line,
    XMeaType_Polyline,

    //
    XMeaType_Ellipse,
    XMeaType_Circle,
    XMeaType_Custom,

    //
    XMeaType_Rectangle,
    XMeaType_Square,
    XMeaType_Polygon,
};

enum XTextPos {
    XTextPos_None = 0,
    XTextPos_TopLeft,
    XTextPos_TopRight,
    XTextPos_BottomLeft,
    XTextPos_BottomRight,
};

enum XMeaFlags {
    XMeaFlags_TrackHigh = 0x01,
    XMeaFlags_TrackLow = 0x02
};

struct XMea {
    char meaName[64];
    s32 meaColor;
    u8 meaType;
    u8 meaFlags;
    u8 textPos;
    u8 alarmType;//0 none, 1 max

    /*
    t2=(t1-(1-emi)*reflectTemp)/emi
    */
    s32 fixEnable;
    float fixEmi;
    float fixReflectTemp;

    //
    u8 isShield;
    u8 use3x3;
    u16 pointCount;
    u16 pointData[64];
};

struct XResult {
    s32 flags;
    float max_temp;
    float avg_temp;
    float min_temp;

    u16 max_x;
    u16 max_y;

    u16 min_x;
    u16 min_y;
};

#define AlgConfig_MeaCountMax       32//1+31
#define AlgConfig_LmoCountMax       (AlgConfig_MeaCountMax - 1)

enum EStatsType {
    EStatsType_Min = 0,
    EStatsType_Max,
    EStatsType_Mean,
    EStatsType_Sum,
    EStatsType_Std
};

enum EDimType {
    EDimType_X = 0,
    EDimType_Y,
    EDimType_Time,
};

//
extern "C" {
    SDK_API s32 MEA2024_Init();
    SDK_API void MEA2024_Free();
    SDK_API double* MEA2024_GetLut(u16 slope, s16 offset);

    //
    SDK_API s32 MEA2024_CheckMea(XMea* mea, u16 width, u16 height);
    SDK_API s32 MEA2024_GetResult(XMea* mea, DataFrameHeader* dfh, s16* dfd, XResult* result);

    //
    SDK_API s32 MEA2024_GetSpaceData(XMea* mea, DataFrameHeader* dfh, s16* dfd, s32 statsType, s32 dimType, double*& spaceData, s32& spaceDataCount);
}

#endif
