#ifndef XXX_DEVICECANVAS_H_
#define XXX_DEVICECANVAS_H_

//sdk
#include <YoseenSDK/YoseenDeviceTypes.h>

//
#include <QWidget>
#include <QPainter>
#include <QImage>
#include <QRect>
#include <QPaintEvent>

class DeviceCanvas : public QWidget
{
    Q_OBJECT
public:
    DeviceCanvas(QWidget* parent=nullptr);
    ~DeviceCanvas() override;

protected:
    void paintEvent(QPaintEvent *event);

public:
    s32 xBeginUpdate(s32 dataWidth, s32 dataHeight);
    void xEndUpdate();
    s32 xUpdateData(DataFrame* dataFrame);

    s32 xSave(const QString& fn);

    void xSetGeometry(int x, int y, int width, int height);

private:
    s32     m_state;
    s32     mdata_width, mdata_height, mdata_pixels;
    QImage* m_image;

    //
    u8*     mdata_bfd;
};

#endif // XXX_DEVICECANVAS_H_
