#ifndef YOSEENSTREAM_H_
#define YOSEENSTREAM_H_

#include <YoseenSDK/YoseenFileTypes.h>
#include <YoseenSDK/YoseenSDK.h>
#include <YoseenSDK/YoseenAlg_Strech.h>
#include <stdio.h>
#include <stdlib.h>

class CYoseenStream{
public:
    CYoseenStream();
    ~CYoseenStream();

    s32 loadStream(const char* fn);
    s32 findBeginAndEnd();
    s32 splitStream(const char* fnPrefix);

private:
    //
    FILE* m_file;
    s32 m_dataWidth, m_dataHeight, m_dataPixels;
    s32 m_frameBegin, m_frameEnd, m_frameCount;
    s64 m_frameSize, m_frame0Offset, m_frameBeginOffset;

    //
    strech_context* m_alg;
    strech_control m_algConfig;

    //
    DataFrameHeader* m_data;//128+pixels*2+pixels*4

    //
    xxxpalettedata* m_paletteData;
    s32 m_paletteCount;
};



#endif
