#ifndef HKSADP_H_
#define HKSADP_H_

#include "HKSADP_Types.h"

typedef struct _HKSADP_Device {
    //
    struct _HKSADP_Device* pnext;

    //
    char DeviceId[48];
    char Mac[20];
    char Ip[16];
    char SubnetMask[16];
    char Gateway[16];
    char SWVersion[48];

    //
    char IPV6_Address[128];
    char IPV6_Gateway[128];
    u8 IPV6_MaskLen;
    u8 DhcpEnable;
    u16 Port;
    u16 HttpPort;
    u16 TlsPort;
}HKSADP_Device;

struct HKSADP_Auth {
    u8 RetryCountLeft;
    u8 LockTimeLeft;//minute
};

extern "C" {
    //
    SDK_API s32 sadpInit(const char* libDir);
    SDK_API void sadpFree();

    //
    SDK_API HKSADP_Device* sadpGetList(s32& count);
    SDK_API void sadpFreeList(HKSADP_Device** pp);
    SDK_API s32 sadpSearchOnce();

    /*

    */
    SDK_API s32 sadpSetNetInfo(HKSADP_Device* device, const char* password, HKSADP_Auth* auth);

}


#endif