/*********************************************************************************************************
* HuiYuanYunTai.h
*
* 2023-10-31: init
*
*
*********************************************************************************************************/
#ifndef XXX_HYYT_H_
#define XXX_HYYT_H_

#include "../yc_type.h"

struct HYYTConfig {
    char ip[16];
    u16 port;//6666
    u16 timeout;//ms, 500
    s32 pt_interval;//ms, 100

    //
    float hspeed;//1/s
    float vspeed;//1/s

    //
    s32 limit_enable;
    float limit_hmin;//0
    float limit_hmax;//360
    float limit_vmin;//-63.0
    float limit_vmax;//62.5
};

enum EHYYTAction {
    EHYYTAction_None    =   0,
    EHYYTAction_Stop,
    EHYYTAction_Right,
    EHYYTAction_Up,
    EHYYTAction_Left,
    EHYYTAction_Down,

    EHYYTAction_RightUp,
    EHYYTAction_LeftUp,
    EHYYTAction_LeftDown,
    EHYYTAction_RightDown,
};

struct HYYTPreset {
    char name[128];
    s32 pan;
    s32 tilt;
    s32 pad[8];
};

struct _HYYTContext;
typedef struct _HYYTContext HYYTContext;

typedef void(__stdcall* HYYTCallback)(s32 errorCode, float pan, float tilt, void* customData);

extern "C" {
    //
    SDK_API s32 HYYT_InitSDK();
    SDK_API void HYYT_FreeSDK();

    //
    SDK_API HYYTContext* HYYT_Create();
    SDK_API void HYYT_Free(HYYTContext** p);

    SDK_API s32 HYYT_SetConfig(HYYTContext* context, HYYTConfig* config);

    SDK_API s32 HYYT_Control(HYYTContext* context, s32 act);

    SDK_API s32 HYYT_StartWork(HYYTContext* context, HYYTCallback cb, void* cbData);

    SDK_API void HYYT_StopWork(HYYTContext* context);
}
#endif