/*******************************************************************************************************
* 2025-07-17
*
*
*
********************************************************************************************************/
#ifndef YOSEENALG_CALIBRATE_H_
#define YOSEENALG_CALIBRATE_H_

#include "YoseenDeviceTypes.h"

struct _CaliContext;
typedef struct _CaliContext CaliContext;

struct _FpaContext;
typedef struct _FpaContext FpaContext;

struct _NstContext;
typedef struct _NstContext NstContext;

struct _CustContext;
typedef struct _CustContext CustContext;

struct _FixTransContext;
typedef struct _FixTransContext FixTransContext;

struct _FixDistContext;
typedef struct _FixDistContext FixDistContext;

//
struct _WeiJuContext;
typedef struct _WeiJuContext WeiJuContext;

struct _XCaliContext;
typedef struct _XCaliContext XCaliContext;

struct _GaoWenContext;
typedef struct _GaoWenContext GaoWenContext;

struct _CaliVideoContext;
typedef struct _CaliVideoContext CaliVideoContext;

struct _ExtBbContext;
typedef struct _ExtBbContext ExtBbContext;

//
struct ComPoint {
    u16 x;
    u16 y;
};
struct ComInput {
    char camera_id[32];
    s32 width;
    s32 height;
    s32 count;
    ComPoint points[0];
};
struct ComItem {
    u32 index;
    s32 count;
    u32 refs[8];
};

//
typedef struct _CaliCreateInfo {
    const char* fn_cali;
    const char* fn_bad;
    const FixInfo* fixInfo;
    s32 fpaTemp;
    u16 width;
    u16 height;
    u16 cropWidth;
    u16 cropHeight;
    u8 cali1_shellTempHW;
    u8 irType;//0 lwir, x mwir
    u8 pad[14];
}CaliCreateInfo;

extern "C" {
    //IRCali_Ref
    SDK_API void Cali_Execute201601(CaliContext* context, s32 fpaTemp, s16* vd, s16* temp);
    SDK_API void Cali_Execute201704(CaliContext* context, s32 fpaTemp, s16* vd);

    //IRCali_Cali
    SDK_API CaliContext* Cali_Create(const char* fn_cali, const char* fn_com, const FixInfo& fixInfo, s32 fpaTemp);
    SDK_API CaliContext* Cali_CreateX(const CaliCreateInfo& info);
    SDK_API void Cali_Free(CaliContext** pp);
    SDK_API s32 Cali_SetFixInfo(CaliContext* context, const FixInfo& fixInfo);
    SDK_API void Cali_Com(CaliContext* context, s16* vd);
    SDK_API void Cali_InitEnv(CaliContext* context, s32 fpaTemp, s32 shellTemp);
    SDK_API void Cali_InitEnvWhole(CaliContext* context, s32 fpaTemp, s32 shellTemp);
    SDK_API void Cali_Execute(CaliContext* context, s16* vd);
    SDK_API void Cali_Execute_C1(CaliContext* context, s16* vd);
    SDK_API void Cali_Execute_Cache(CaliContext* context, s16* vd, u8* cache);
    SDK_API void Cali_SetHackFlags(CaliContext* context, s32 flags);
    SDK_API int Cali_CheckFile(const char* fn_cali, const char* camera_id);
    SDK_API s32 Cali_LoadCust(CaliContext* context, const char* fn_cust);

    //IRCali_Fpa
    SDK_API FpaContext* Fpa_Create(CaliContext* caliArray[]);
    SDK_API void Fpa_Free(FpaContext** pp);
    SDK_API s32 Fpa_GetEnv(FpaContext* context, s32 fpa);

    //IRCali_Com
    SDK_API s32 Com_Process(CaliContext* cali, const char* fn_bad, const char* fn_com);
    SDK_API s32 Com_ProcessVideo(CaliVideoContext* cali, const char* fn_bad, const char* fn_com);
    SDK_API s32 Com_ProcessX(ComInput* input, ComItem** ppItemArray);
    SDK_API s32 Com_CheckFile(const char* fn_bad, const ComInput* bfh);

    //IRCali_Nst
    SDK_API NstContext* Nst_Create(CaliContext* cali, const char* fn_cali);
    SDK_API NstContext* Nst_CreateX(CaliContext* cali, const CaliCreateInfo& info);
    SDK_API void Nst_Free(NstContext** pp);
    SDK_API s32 Nst_Execute(NstContext* context, s32 fpaTemp, s32 nstDelta, s16* vol, s16* temp);
    SDK_API void Nst_SetConfig(NstContext* context, s32 fpaTempDelta);

    //IRCali_FixTrans
    SDK_API FixTransContext* FixTrans_Create(s32 irType);
    SDK_API void FixTrans_Free(FixTransContext** pp);
    SDK_API void FixTrans_Init(FixTransContext* context, u16 slope, s16 offset);
    SDK_API void FixTrans_UpdateLut(FixTransContext* context, s32 envTemp, double trans, s16* lut);
    /*
    * t1: no trans
    * t2: trans
    * envTemp: 25
    * type: 0 lwir, x mwir
    */
    SDK_API double FixTrans_CalcTrans(double t1, double t2, double envTemp, s32 irType);

    //IRCali_FixDist
    SDK_API FixDistContext* FixDist_Create();
    SDK_API void FixDist_Free(FixDistContext** pp);
    SDK_API s32 FixDist_Init(FixDistContext* context, const char* fn, u16 slope, s16 offset);
    SDK_API s32 FixDist_Init2(FixDistContext* context, const char* fn, CaliContext* cali);
    SDK_API s32 FixDist_UpdateLut(FixDistContext* context, s32 dist, s16* lut);

    //IRCali_Cust

    //IRCali_C2m
    SDK_API s32 C2m_Load(CaliContext* context, const char* fn_c2m);
    SDK_API s32 C2m_CheckFile(const char* fn_c2m, const char* camera_id);

    //IRCali_GaoWen
    SDK_API GaoWenContext* GaoWen_Create(CaliContext* cali);
    SDK_API void GaoWen_Free(GaoWenContext** pp);
    SDK_API s32 GaoWen_LoadFile(GaoWenContext* context, const char* fn_gaowen);
    SDK_API s32 GaoWen_LoadCust(GaoWenContext* context, const char* fn_cust1, const char* fn_cust2);
    SDK_API void GaoWen_InitEnv(GaoWenContext* context, s32 fpaTemp, s32 shellTemp);
    SDK_API void GaoWen_Execute(GaoWenContext* context, s16* vd, DataFrameHeader* dfh);
    SDK_API void GaoWen_SetMode(GaoWenContext* context, s32 caliMode, s32 fpaTemp, s32 shellTemp);
    SDK_API s32 GaoWen_ConvertFile(const char* fn_cali, const char* fn_old, const char* fn);

    //IRCali_WeiJu
    SDK_API WeiJuContext* WeiJu_Create(CaliContext* cali);
    SDK_API void WeiJu_Free(WeiJuContext** pp);
    SDK_API s32 WeiJu_LoadFile(WeiJuContext* context, const char* fn_weiju);
    SDK_API s32 WeiJu_LoadCust(WeiJuContext* context, const char* fn_cust1, const char* fn_cust2);
    SDK_API void WeiJu_Execute(WeiJuContext* context, s16* vd);
    SDK_API void WeiJu_InitEnv(WeiJuContext* context, s32 fpaTemp, s32 shellTemp);

    //IRCali_XCali
    SDK_API XCaliContext* XCali_Create(const CaliCreateInfo& info);
    SDK_API void XCali_Free(XCaliContext** pp);
    SDK_API s32 XCali_LoadCali2(XCaliContext* context, XCali2* config);
    SDK_API s32 XCali_LoadCust(XCaliContext* context, XCaliCust* config);
    SDK_API void XCali_InitEnv(XCaliContext* context, s32 fpaTemp, s32 shellTemp);

    //IRCali_Video
    SDK_API CaliVideoContext* CaliVideo_Create(const char* fn_cali, const char* fn_com);
    SDK_API void CaliVideo_Free(CaliVideoContext** pp);
    SDK_API s32 CaliVideo_GetEnv(CaliVideoContext* context, s32 fpaTemp);
    SDK_API void CaliVideo_Nst(CaliVideoContext* context, s32 fpaTemp, s16* vol, s16* temp);
    SDK_API void CaliVideo_Fix(CaliVideoContext* context, s16* temp);
    SDK_API void CaliVideo_Com(CaliVideoContext* context, s16* temp);
    SDK_API s32 CaliVideo_CheckFile(const char* fn_cali, const char* camera_id);

    //IRCali_ExtBb
    SDK_API ExtBbContext* ExtBb_Create();
    SDK_API void ExtBb_Free(ExtBbContext** pp);
    SDK_API s32 ExtBb_SetConfig(ExtBbContext* context, ExtBbConfig* config);
    SDK_API void ExtBb_Execute(ExtBbContext* context, DataFrameHeader* dfh, s16* dfd);
}

#endif//YOSEENALG_CALIBRATE_H_
