/*******************************************************************************************************
* 2024-12-04
*
*
*
********************************************************************************************************/
#ifndef YOSEENCALI_H_
#define YOSEENCALI_H_

#include "YoseenDeviceTypes.h"

/*******************************************************************************************************
*
* 
*
*
********************************************************************************************************/
enum HTType {
    //
    HT_NULL = 0,

    //x210
    HT_U384A = 100,
    HT_U384B,
    HT_U640B,
    HT_S384A,

    //x4418
    HT_X384B = 200,
    HT_X640A,
    HT_X640B,
    HT_X384D,
    HT_X640D,
    HT_X640E,

    HT_X384C,
    HT_X160A,
    HT_X384A,
    HT_X1024B,
    HT_X1280B,
    HT_X1024C,
    HT_X640E_GDX,

    //m4418
    HT_M384B = 300,
    HT_M640A,
    HT_M384D,
    HT_M640D,
    HT_M160A,
    HT_M384F,
    HT_M640F,
    HT_M384G,//AK640->384

    //
    HT_H160A = 400,
    HT_H384D,
    HT_H640D,
    HT_H384F,
    HT_H640F,
    HT_H384G,

    //rk3568
    HT_R1280A = 500,
    HT_R384F,
    HT_R640F,
    HT_R384H,
    HT_R640H,
    HT_R1280F,
    HT_R1280H,
    HT_R384G,//AK640->384
    HT_CLW01,
    HT_CLW02,
    HT_CLW03,
    HT_CLW04,
    HT_CLW05,
};

//
#define HistBinCount			1024
typedef struct _HistConfig {
    s16 htType;
    s16 skipBad;
    u8 pad[8];
}HistConfig;
typedef struct _HistOutput {
    float max;
    float min;
    float avg;

    float binArray[HistBinCount];
}HistOutput;

//
typedef struct _NETDContext NETDContext;
struct NETDConfig {
    u16 width;
    u16 height;
    u16 frameCount;
    u16 calcInterval;//ms
    u8 pad[8];
};
struct NETDOutput {
    float netd;//mK
    float sstd;//mK
};

//
extern "C" {
    //
    SDK_API s32 Cali_HistVol(DataFrameHeader* dfh, s16* dfd, HistConfig* config, HistOutput* output);
    SDK_API s32 Cali_SaveJpg(char* fn, u8* dfhdfd);

    //
    SDK_API NETDContext* NETD_Create();
    SDK_API void NETD_Free(NETDContext** pp);
    SDK_API s32 NETD_SetConfig(NETDContext* context, NETDConfig* config);
    SDK_API s32 NETD_Execute(NETDContext* context, DataFrameHeader* dfh, s16* dfd, NETDOutput* output);

    //
    SDK_API s32 Cali_vd2temp(const char* caliFn, const char* srcDir, const char* dstDir);

}

#endif