package Test;

import Yoseen.YoseenData;
import Yoseen.YoseenSDK;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;

/**********************************************************************************************
 *
 * TestConfigMeasureTemplate
 *
 *
 **********************************************************************************************/
public class TestConfigMeasureTemplate {
    public static void main(String[] args) {
        int ret;

        //init sdk
        ret = YoseenSDK.YoseenDevice.initSDK();
        YoseenSDK.YoseenDevice device = new YoseenSDK.YoseenDevice();

        //login
        ret = device.login("192.168.1.201");

        //create measure template
        YoseenData.MeasureTemplate mt = new YoseenData.MeasureTemplate();
        Pointer mtp = mt.getPointer();
        long mtp2 = Pointer.nativeValue(mtp);

        //get measure template
        IntByReference size = new IntByReference(mt.size());
        ret = device.downloadMem(mtp2, size);
        mt.autoRead();

        //set measure template
        mt.Head.shieldFlags = 0x1;
        mt.ShieldArray[0].xydata = new short[]{50, 36, 100, 36, 100, 72, 50, 72};
        mt.autoWrite();
        ret = device.uploadMem(mtp2, mt.size());

        //logout
        device.logout();

        //free sdk
        YoseenSDK.YoseenDevice.freeSDK();
    }

}
