package Test;

import Yoseen.YoseenData;
import Yoseen.YoseenSDK;

import Yoseen.YoseenUtil;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;

/**********************************************************************************************
 *
 * TestMeasure
 *
 *
 **********************************************************************************************/
public class TestMeasure {
    public static void main(String[] args) {
        int ret;

        //init sdk
        ret = YoseenSDK.YoseenDevice.initSDK();
        YoseenSDK.YoseenDevice device = new YoseenSDK.YoseenDevice();

        //login
        ret = device.login("192.168.1.201");

        //get one frame from device
        YoseenData.TempFrameFile tff = new YoseenData.TempFrameFile();
        ret = device.saveFrame(tff);

        //create meaContext
        YoseenSDK.YoseenMeasure meaContext = new YoseenSDK.YoseenMeasure();

        //single measure
        YoseenData.xxxmeasure mea = new YoseenData.xxxmeasure();
        YoseenData.xxxresult result = new YoseenData.xxxresult();
        mea.emmi = 97;
        mea.measuretype = YoseenUtil.xxxmeasuretype_rectangle;
        mea.xydata[0] = 100;
        mea.xydata[1] = 100;
        mea.xydata[2] = 200;
        mea.xydata[3] = 200;
        ret = YoseenSDK.YoseenMeasure.getResult(tff.dfh, tff.dfd, mea, result);
        System.out.printf("max %3.2f, avg %3.2f, min %3.2f\n", result.max, result.avg, result.min);

        //multi measure
        YoseenData.CameraBasicInfo basicInfo = device.getBasicInfo();
        short width = basicInfo.DataWidth;
        short height = basicInfo.DataHeight;
        YoseenData.MeasureTemplate mt = new YoseenData.MeasureTemplate();
        YoseenData.MeasureTemplateResult mtResult = new YoseenData.MeasureTemplateResult();
        YoseenData.MeasureTemplateHead mtHead = mt.Head;
        mtHead.width = width;
        mtHead.height = height;
        mtHead.shieldFlags = 0;
        mtHead.LMOFlags = 0x07;//0,1,2

        //point
        mea = mt.LMOArray[0];
        mea.measuretype = YoseenUtil.xxxmeasuretype_point;
        mea.emmi = 97;
        mea.xydata[0] = 50;
        mea.xydata[1] = 100;
        mea.xydata[2] = 3;//x,y,radius

        //polyline
        mea = mt.LMOArray[1];
        mea.measuretype = YoseenUtil.xxxmeasuretype_polyline;
        mea.emmi = 97;
        mea.points = 3;
        mea.xydata[0] = 30;mea.xydata[1] = 30;
        mea.xydata[2] = 40;mea.xydata[3] = 40;
        mea.xydata[4] = 60;mea.xydata[5] = 60;

        //polygon
        mea = mt.LMOArray[2];
        mea.measuretype = YoseenUtil.xxxmeasuretype_polygon;
        mea.emmi = 97;
        mea.points = 3;
        mea.xydata[0] = 130;mea.xydata[1] = 130;
        mea.xydata[2] = 140;mea.xydata[3] = 140;
        mea.xydata[4] = 160;mea.xydata[5] = 160;
        mt.autoWrite();

        //
        ret = meaContext.init();
        ret = meaContext.setConfig(mt);
        ret = meaContext.getResult(tff.dfh, tff.dfd, mtResult);

        //logout
        device.logout();

        //free sdk
        YoseenSDK.YoseenDevice.freeSDK();
    }

}
