package Test;

import Yoseen.YoseenData;
import Yoseen.YoseenUtil;
import Yoseen.YoseenSDK;

import com.sun.jna.Pointer;

/**********************************************************************************************
 *
 * TestYoseenDevice
 *
 *
 **********************************************************************************************/
public class TestYoseenDevice {
    public static void main(String[] args) {
        String dddDebug = System.getProperty("user.dir")+"\\..\\build-Debug64";
        int ret;

        //init sdk
        ret = YoseenSDK.YoseenDevice.initSDK();
        YoseenSDK.YoseenDevice device = new YoseenSDK.YoseenDevice();

        //login
        ret = device.login("192.168.1.201");

        //control
        YoseenData.Ctl ctl = new YoseenData.Ctl();
        //ctl.setFocusInfo(100, 100, 200, 200);
        //ret=device.sendControl(ctl);

        //
        ctl.setManualFFC();
        ret = device.sendControl(ctl);

        //
        ret = device.saveFrame(dddDebug + "\\Data\\test.jpg");

        //config
        YoseenData.CameraBasicInfo basicInfo = new YoseenData.CameraBasicInfo();
        ret = device.get_CameraBasicInfo(basicInfo);

        //StartPreview, StopPreview
        YoseenData.YoseenPreviewCallback previewCallback = new YoseenData.YoseenPreviewCallback() {
            int _count = 0;
            public void callback(int errorCode, long dataFrame, long customData) {
                if (0==errorCode){
                    Pointer p = new Pointer(dataFrame);
                    YoseenData.DataFrame frame = new YoseenData.DataFrame();
                    frame.Head = p.getLong(0);
                    frame.Temp = p.getLong(1);
                    frame.Bmp = p.getLong(3);
                }else{

                }
                _count++;
            }
        };
        YoseenData.YoseenPreviewInfo previewInfo = new YoseenData.YoseenPreviewInfo();
        previewInfo.DataType = YoseenUtil.xxxdatatype_video;
        previewInfo.CustomCallback = previewCallback;
        ret = device.startPreview(YoseenUtil.xxxdatatype_video, previewCallback);
        if (0 == ret) {
            ret = device.beginSave(dddDebug + "\\Data\\test.mp4", YoseenUtil.xxxmediafile_mp4);
            try {
                //wait
                Thread.sleep(5000);
                device.endSave(YoseenUtil.xxxmediafile_mp4);

                //wait
                Thread.sleep(5000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        device.stopPreview();

        //logout
        device.logout();

        //free sdk
        YoseenSDK.YoseenDevice.freeSDK();
    }
}
