#include "main.h"
#include <YoseenSDK/YoseenDeviceTypes.h>
#include <LibPTZ/LibPTZ.h>

#include <stdio.h>
#include <string.h>
#include <Windows.h>

static void __stdcall ir_onFrame(s32 errorCode, DeviceFrame* frame, void* custom) {
    static s32 __calls = 0;
    //if (__calls % 10 == 0)printf("\n");
    //printf("%d, ", __calls++);
}

static void __stdcall vis_onFrame(s32 errorCode, DeviceFrame* frame, void* custom) {
    static s32 __calls = 0;
    //if (__calls % 10 == 0)printf("\n");
    //printf("%d, ", __calls++);
}

void test_LibPTZ_preview() {
    s32 ret, i;
    ret = Device_InitSDK();

    //
    DeviceConfig config = {};
    //vis
    //config.ptzconntype = EPtzConnType_VIS;
    //strcpy(config.ir_ip, "192.168.1.210");
    //strcpy(config.vis_ip, "192.168.1.230");

    //ir
    config.ptzconntype = EPtzConnType_IR;
    strcpy(config.ir_ip, "192.168.1.215");
    strcpy(config.vis_ip, "192.168.1.235");

    strcpy(config.vis_username, "admin");
    strcpy(config.vis_password, "yoseen2018");
    config.timeout = 0;

    //
    DeviceContext* context = Device_Create();
    ret = Device_SetDeviceConfig(context, &config);

    //
    ret = Device_Login(context);

    //
    DevicePreviewInfo previewInfo = {};
    previewInfo.userData = NULL;
    previewInfo.ir_streamType = EStreamType_Temp;
    previewInfo.ir_onFrame = ir_onFrame;
    previewInfo.vis_streamType = EStreamType_Video;
    previewInfo.vis_onFrame = vis_onFrame;
    ret = Device_StartPreview(context, &previewInfo);

    //
    while (1) {
        Sleep(100);
    }

    //
    s32 ft = EFileType_jpg;
    ret = Device_BeginSave(context, "Debug/test", ft);
    Device_EndSave(context);

    //
    Device_StopPreview(context);

    Device_Logout(context);

    Device_Free(&context);
}