#include "main.h"

//
#include <LibHK/HKISAPI.h>

//
#include <string.h>
#include <stdio.h>
#include <Windows.h>

void test_hkisapi() {
	s32 ret;
	HKISAPIContext* context = hkisapiCreate();

	//
	HKISAPIConfig config = {};
	strcpy(config.url, "http://192.168.1.210:80");
	strcpy(config.username, "admin");
	strcpy(config.password, "yoseen2018");
	config.timeout = 2000;

	ret = hkisapiSetConfig(context, &config);

	//
	{
		HKISAPIRaw raw = {};
		strcpy(raw.isapi, "/ISAPI/Image/channels/1/capabilities");
		raw.mode = 0;
		ret = hkisapiExecuteRaw(context, &raw);
	}

	{
		HKISAPIRaw2 raw2 = {};
		strcpy(raw2.isapi, "/ISAPI/Image/channels/1/capabilities");
		raw2.mode = 0;
		raw2.respSizeMax = 8192;
		raw2.resp = (char*)calloc(1, raw2.respSizeMax);
		ret = hkisapiExecuteRaw2(context, &raw2);

		//
		free(raw2.resp);
	}

	//
	HKISAPIBin bin = {};

	//ZoomFocus, get-put
	bin.type = HKISAPIBinType_ZoomFocus;
	bin.mode = 0;
	HKISAPI_ZoomFocus& resp_ZoomFocus = bin.resp.ZoomFocus;
	ret = hkisapiExecuteBin(context, &bin);
	//
	bin.mode = 1;
	HKISAPI_ZoomFocus& req_ZoomFocus = bin.req.ZoomFocus;
	memcpy(&req_ZoomFocus, &resp_ZoomFocus, sizeof(HKISAPI_ZoomFocus));
	ret = hkisapiExecuteBin(context, &bin);

	//Color, get-put
	bin.type = HKISAPIBinType_Color;
	bin.mode = 0;
	HKISAPI_Color& resp_Color = bin.resp.Color;
	ret = hkisapiExecuteBin(context, &bin);
	//
	bin.mode = 1;
	HKISAPI_Color& req_Color = bin.req.Color;
	memcpy(&req_Color, &resp_Color, sizeof(HKISAPI_Color));
	ret = hkisapiExecuteBin(context, &bin);

	//Exposure, get-put
	bin.type = HKISAPIBinType_Exposure;
	bin.mode = 0;
	HKISAPI_Exposure& resp_Exposure = bin.resp.Exposure;
	ret = hkisapiExecuteBin(context, &bin);
	//
	bin.mode = 1;
	HKISAPI_Exposure& req_Exposure = bin.req.Exposure;
	memcpy(&req_Exposure, &resp_Exposure, sizeof(HKISAPI_Exposure));
	ret = hkisapiExecuteBin(context, &bin);

	//Iris, get-put
	bin.type = HKISAPIBinType_Iris;
	bin.mode = 0;
	HKISAPI_Iris& resp_Iris = bin.resp.Iris;
	ret = hkisapiExecuteBin(context, &bin);
	//
	bin.mode = 1;
	HKISAPI_Iris& req_Iris = bin.req.Iris;
	memcpy(&req_Iris, &resp_Iris, sizeof(HKISAPI_Iris));
	ret = hkisapiExecuteBin(context, &bin);

	////FocusConfiguration, get-put
	//bin.type = HKISAPIBinType_FocusConfiguration;
	//bin.mode = 0;
	//HKISAPI_FocusConfiguration& resp_FocusConfiguration = bin.resp.FocusConfiguration;
	//ret = hkisapiExecuteBin(context, &bin);
	////
	//bin.mode = 1;
	//HKISAPI_FocusConfiguration& req_FocusConfiguration = bin.req.FocusConfiguration;
	//memcpy(&req_FocusConfiguration, &resp_FocusConfiguration, sizeof(HKISAPI_FocusConfiguration));
	//ret = hkisapiExecuteBin(context, &bin);

	//
	while (1) {
		Sleep(100);
	}

	//
	hkisapiFree(&context);
}

