#include "main.h"

//
#include <LibHK/HKNET.h>
#include <YoseenSDK/YoseenDeviceTypes.h>

//
#include <string.h>
#include <stdio.h>
#include <Windows.h>

void test_hknet() {
    s32 ret;
    ret = hkStaticInit("./LibHK");
    //

    HKContext* context = hkCreate();
    ret = hkLogin(context, (char*)"192.168.1.202", (char*)"admin", (char*)"yoseen2018");

    //enable getptz+setptz
    //ret = hkSerialStart(context, NULL, NULL);

    //move, wait, stop
    ret = hkPtzControl(context, PtzAction::PtzAction_MoveLeft, 100);
    Sleep(2000);
    ret = hkPtzControl_Stop(context, PtzAction::PtzAction_MoveLeft, 100);

    //goto preset, wait
    ret = hkPtzControl(context, PtzAction::PtzAction_PresetGoto, 1);
    Sleep(2000);

    //getptz, setptz
    s32 pan, tilt, zoom;
    ret = hkPtzControl_GetPtz(context, pan, tilt, zoom, 500);
    ret = hkPtzControl_SetPtz(context, pan, tilt, zoom);

    //
    hkStaticFree();
}