#include "main.h"

//
#include <YoseenSDK/YoseenSDK.h>

//
#include <string.h>
#include <stdio.h>
#include <Windows.h>

void test_yoseensdk_ptz() {
    s32 ret;
    s32 userHandle;

    ret = Yoseen_InitSDK();

    CameraBasicInfo basicInfo = {};
    YoseenLoginInfo loginInfo = {};
    strcpy(loginInfo.CameraAddr, "192.168.1.111");

    userHandle = Yoseen_Login(&loginInfo, &basicInfo);

    CtlX ctlx = {};
    xxxptzcmd& cmd = ctlx.Data.PtzCmd;

    //move, wait, stop
    ctlx.Type = CtlXType_ExecutePtz;
    cmd.act = PtzAction_MoveLeft;
    cmd.arg = 100;
    ret = Yoseen_SendControlX(userHandle, &ctlx);    Sleep(2000);


    ctlx.Type = CtlXType_ExecutePtz;
    cmd.act = PtzAction_Stop;
    cmd.arg = 100;
    ret= Yoseen_SendControlX(userHandle, &ctlx);

    //goto preset
    ctlx.Type = CtlXType_ExecutePtz;
    cmd.act = PtzAction_PresetGoto;
    cmd.arg = 1;
    ret = Yoseen_SendControlX(userHandle, &ctlx);   Sleep(2000);

    //get ptz
    ctlx.Type = CtlXType_ExecutePtz;
    cmd.act = PtzAction_GetPTZ;
    cmd.arg = 1;
    ret = Yoseen_SendControlX(userHandle, &ctlx);   Sleep(2000);
    printf("pan %d, tilt %d\n", cmd.pan, cmd.tilt);

    //set ptz
    ctlx.Type = CtlXType_ExecutePtz;
    cmd.act = PtzAction_SetPTZ;
    cmd.arg = 1;
    cmd.pan = 1000;//0.01
    cmd.tilt = 2000;//0.01
    ret = Yoseen_SendControlX(userHandle, &ctlx);   Sleep(2000);


    //
    ret=Yoseen_Logout(userHandle);
    Yoseen_FreeSDK();
}