#include <yc_type.h>

enum PtzAction {
    //
    PtzAction_Stop,

    PtzAction_MoveUp,
    PtzAction_MoveDown,
    PtzAction_MoveLeft,
    PtzAction_MoveRight,

    PtzAction_MoveLeftUp,
    PtzAction_MoveRightUp,
    PtzAction_MoveLeftDown,
    PtzAction_MoveRightDown,

    //
    PtzAction_ZoomIn,
    PtzAction_ZoomOut,

    PtzAction_FocusFar,
    PtzAction_FocusNear,

    PtzAction_IrisOpen,
    PtzAction_IrisClose,

    //
    PtzAction_PresetSet,
    PtzAction_PresetClear,
    PtzAction_PresetGoto,

    //getpan+gettilt+getzoom
    PtzAction_GetPTZ,

    //setpan+settilt+setzoom
    PtzAction_SetPTZ,

    //
    PtzAction_SwitchLightPowerOn,
    PtzAction_SwitchLightPowerOff,

    PtzAction_SwitchWiperPowerOn,
    PtzAction_SwitchWiperPowerOff,

    //add20230209
    PtzAction_GetPan,
    PtzAction_SetPan,

    PtzAction_GetTilt,
    PtzAction_SetTilt,

    PtzAction_GetZoom,
    PtzAction_SetZoom,

    PtzAction_B160_Backlight,
    PtzAction_B160_GetVersion,

    /*
     * pelcod custom req+resp
     *
     * cmd0+cmd1+data0+data1
     *
     * req-pan, resp-tilt
     *
     * */
    PtzAction_B160_W4R4,

    /*
    * DiaoCang
    *
    */
    PtzAction_DiaoCang_SuiDong,
};


/*
req+resp share Cmd_CtlX

*/
struct Cmd_CtlX {
    //fixed head
    u16 Type;//56 
    u16 Size;//76=8+4+64
    s32 CtlX_Type;//14

    //var
    u8 act;//PtzAction
    u8 arg;//speed or presetid
    u8 pad[2];
    s32 pan;
    s32 tilt;
    s32 zoom;
};

void test_yoseensdk_ptz_raw() {
    Cmd_CtlX cmd = {};

    //move left, req
    cmd.Type = 56;
    cmd.Size = 76;
    cmd.CtlX_Type = 14;
    cmd.act = PtzAction_MoveLeft;
    cmd.arg = 100;

    //goto preset1, req
    cmd.Type = 56;
    cmd.Size = 80;
    cmd.CtlX_Type = 14;
    cmd.act = PtzAction_PresetGoto;
    cmd.arg = 1;//preset1

    //getptz, req
    cmd.Type = 56;
    cmd.Size = 80;
    cmd.CtlX_Type = 14;
    cmd.act = PtzAction_GetPTZ;
    //getptz, resp
    //cmd.pan, cmd.tilt

    //setptz, req
    cmd.Type = 56;
    cmd.Size = 80;
    cmd.CtlX_Type = 14;
    cmd.act = PtzAction_SetPTZ;
    cmd.pan = 10000;//100
    cmd.tilt = 4500;//45
}


void test_hkisapi_raw() {

    /*
        /ISAPI/Image/channels/1/SupplementLight
    <?xml version="1.0" encoding="UTF-8"?>
    <SupplementLight version="2.0" xmlns="http://www.hikvision.com/ver20/XMLSchema">
        <supplementLightMode>close</supplementLightMode>
        <mixedLightBrightnessRegulatMode>manual</mixedLightBrightnessRegulatMode>
        <whiteLightBrightness>0</whiteLightBrightness>
        <irLightBrightness>100</irLightBrightness>
    </SupplementLight>
    */

}