using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Media;
using System.Windows.Threading;

using sdkdef = YoseenPTZ.SDKDef;
using YoseenPTZ.ConfigDef;
using YoseenPTZ.ResourceDef;

namespace YoseenPTZ
{
    class App : Application
    {
        static App __instance;
        public static App Instance
        {
            get
            {
                if (__instance == null)
                {
                    __instance = new App();
                }
                return App.__instance;
            }
        }

        public ConfigService ConfigService { get; private set; }

        public ShellView ShellView { get; private set; }

        private App()
        {
            //
            FontFamily Const_FontFamily = new FontFamily("楷体");
            TextElement.FontFamilyProperty.OverrideMetadata(typeof(TextElement), new FrameworkPropertyMetadata(Const_FontFamily));
            TextBlock.FontFamilyProperty.OverrideMetadata(typeof(TextBlock), new FrameworkPropertyMetadata(Const_FontFamily));
            
            double Const_FontSize = 14;
            TextElement.FontSizeProperty.OverrideMetadata(typeof(TextElement), new FrameworkPropertyMetadata(Const_FontSize));
            TextBlock.FontSizeProperty.OverrideMetadata(typeof(TextBlock), new FrameworkPropertyMetadata(Const_FontSize));

            ResourceDictionary rd = new ResourceDictionary();
            rd.Source = new Uri("ResourceDef/common.xaml", UriKind.Relative);
            this.Resources.MergedDictionaries.Add(rd);

            //
            this.ShutdownMode = ShutdownMode.OnMainWindowClose;
            this.DispatcherUnhandledException += App_DispatcherUnhandledException;
            this.Exit += App_Exit;
        }

        void App_DispatcherUnhandledException(object sender, DispatcherUnhandledExceptionEventArgs e)
        {
            LogUtil.Error(e.Exception.Message);
        }

        void App_Exit(object sender, ExitEventArgs e)
        {
  
        }

        public void DoMain()
        {
            ConfigService = new ConfigService();

            //
            ShellView shellView = new ShellView();
            ShellView = shellView;
            this.Run(shellView);
        }

        public void ConfigPart(ConfigPartType type)
        {
            ConfigService.ConfigPart(type);
            ShellView.ConfigPart(type);
        }
    }


    public class AppStatic
    {
        public const string ConstAppName = "YoseenPTZ";

        #region paths
        static string _exe;
        public static string Exe
        {
            get
            {
                if (_exe == null)
                {
                    _exe = Path.GetDirectoryName(Assembly.GetEntryAssembly().Location);
                }
                return _exe;
            }
        }

        static string _config;
        public static string Config
        {
            get
            {
                if (_config == null)
                {
                    _config =  $"{Exe}/{ConstAppName}-Config";
                }
                return _config;
            }
        }

        static string _fileBin;
        public static string FileBin
        {
            get
            {
                if (null == _fileBin)
                {
                    _fileBin = $"{Config}/{ConstAppName}.bin";
                }
                return _fileBin;
            }
        }

        static string _filePresetConfig;
        public static string FilePresetConfig
        {
            get
            {
                if (null == _filePresetConfig)
                {
                    _filePresetConfig = $"{Config}/PresetConfig.bin";
                }
                return _filePresetConfig;
            }
        }

        static string _fileLog;
        public static string FileLog
        {
            get
            {
                if (null == _fileLog)
                {
                    _fileLog = $"{Exe}/Log/{ConstAppName}.log";
                }
                return _fileLog;
            }
        }

        #endregion

        #region consts

        public const int ConstVIS_WidthDefault = 1920;
        public const int ConstVIS_HeightDefault = 1080;
        public const int ConstIR_WidthDefault = 384;
        public const int ConstIR_HeightDefault = 288;

        public const int ConstPtrBufferSize = 1024 * 1024;
        #endregion

        //
        static bool _isInited;

        public static void Init()
        {
            if (_isInited) return;
            int ret;
            ret = sdkdef.LibPTZ.Device_InitSDK();
            if (0 > ret)
            {
                throw new Exception($"Device_InitSDK, ret {ret}");
            }

            //
            _isInited = true;
        }

        public static void Free()
        {
            if (!_isInited) return;

            sdkdef.LibPTZ.Device_FreeSDK();
            _isInited = false;
        }
    }
}
