using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Globalization;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Windows;

using System.Windows.Input;
using System.Windows.Media;

namespace YoseenPTZ.CoreDef
{
    public class CanvasStatic
    {
        public static readonly double TextFontSize1 = 18;
        public static readonly double TextFontSize2 = 28;

        public static FontFamily FF_TimesNewRoman = new FontFamily("Times New Roman");
        public static readonly Typeface TextTypeface = new Typeface(FF_TimesNewRoman,FontStyles.Normal,FontWeights.Normal,FontStretches.Normal);

        //
        public static readonly SolidColorBrush BrushBlack = new SolidColorBrush(Colors.Black);
        public static readonly SolidColorBrush BrushBlackA = new SolidColorBrush(Color.FromArgb(128, 32, 32, 32));
        public static readonly Pen PenBlack = new Pen(BrushBlack, 2);

        public static readonly SolidColorBrush BrushWhite = new SolidColorBrush(Colors.White);
        public static readonly SolidColorBrush BrushWhiteA = new SolidColorBrush(Color.FromArgb(128, 255, 255, 255));
        public static readonly Pen PenWhite = new Pen(BrushWhite, 2);
        public static readonly Pen PenWhiteA = new Pen(BrushWhiteA, 2);

        public static readonly SolidColorBrush BrushRed = new SolidColorBrush(Colors.Red);
        public static readonly SolidColorBrush BrushRedA = new SolidColorBrush(Color.FromArgb(128, 255, 0, 0));
        public static readonly Pen PenRed = new Pen(BrushRed, 2);

        public static readonly SolidColorBrush BrushBlue = new SolidColorBrush(Colors.Blue);
        public static readonly Pen PenBlue = new Pen(BrushBlue, 2);
        public static readonly Pen PenBlueDash = new Pen(BrushBlue, 2) { DashStyle = DashStyles.Dash };
        public static readonly Pen PenBlueDash4 = new Pen(BrushBlue, 4) { DashStyle = DashStyles.Dash };

        public static readonly SolidColorBrush BrushYellow = new SolidColorBrush(Colors.Yellow);
        public static readonly Pen PenYellow = new Pen(BrushYellow, 2);
        public static readonly Pen PenYellowDash = new Pen(BrushYellow, 2) { DashStyle = DashStyles.Dash };

        public static readonly SolidColorBrush BrushOrange = new SolidColorBrush(Colors.Orange);
        public static readonly Pen PenOrange = new Pen(BrushOrange, 2);
        public static readonly Pen PenOrangeDash = new Pen(BrushOrange, 2) { DashStyle = DashStyles.Dash };

        public static readonly SolidColorBrush BrushLime = new SolidColorBrush(Colors.LimeGreen);
        public static readonly SolidColorBrush BrushLimeGreen = new SolidColorBrush(Colors.LimeGreen);

        public static readonly SolidColorBrush BrushMagenta = new SolidColorBrush(Colors.Magenta);
        public static readonly Pen PenMagenta = new Pen(BrushMagenta, 2);
        public static readonly Pen PenMagentaDash = new Pen(BrushMagenta, 2) { DashStyle = DashStyles.Dash };

        public static readonly Pen PenLime = new Pen(BrushLime, 1);
        public static readonly Pen PenLimeGreen = new Pen(BrushLimeGreen, 2);
        public static readonly Pen PenLimeGreenDash = new Pen(BrushLimeGreen, 2) { DashStyle = DashStyles.Dash };
        public static readonly Pen PenLimeGreenDash4 = new Pen(BrushLimeGreen, 4) { DashStyle = DashStyles.Dash };

        public static readonly SolidColorBrush BrushGray = new SolidColorBrush(Color.FromArgb(255, 211, 211, 211));

        public static readonly SolidColorBrush BrushShield = new SolidColorBrush(Color.FromArgb(128, 50, 50, 50));
        public static readonly Pen PenShield = new Pen(BrushBlack, 2) { DashStyle = DashStyles.Dash };

        public static readonly SolidColorBrush BrushTextBk = new SolidColorBrush(Color.FromArgb(128, 0, 0, 0));
        public static readonly SolidColorBrush BrushTextFg = new SolidColorBrush(Color.FromArgb(255, 255, 255, 255));



        const double ConstTrack_Radius = 4;
        const double ConstTrack_Radius2 = 12;
        static Point _tmpPoint1, _tmpPoint2;
        public static void DrawTrack(DrawingContext dc, Point point, Pen penFg, Pen penBk)
        {
            //
            _tmpPoint1.X = point.X - ConstTrack_Radius2;
            _tmpPoint1.Y = point.Y;
            _tmpPoint2.X = point.X - ConstTrack_Radius;
            _tmpPoint2.Y = point.Y;
            dc.DrawLine(penBk, _tmpPoint1, _tmpPoint2);
            dc.DrawLine(penFg, _tmpPoint1, _tmpPoint2);

            _tmpPoint1.X = point.X + ConstTrack_Radius2;
            _tmpPoint1.Y = point.Y;
            _tmpPoint2.X = point.X + ConstTrack_Radius;
            _tmpPoint2.Y = point.Y;
            dc.DrawLine(penBk, _tmpPoint1, _tmpPoint2);
            dc.DrawLine(penFg, _tmpPoint1, _tmpPoint2);

            //
            _tmpPoint1.X = point.X;
            _tmpPoint1.Y = point.Y - ConstTrack_Radius2;
            _tmpPoint2.X = point.X;
            _tmpPoint2.Y = point.Y - ConstTrack_Radius;
            dc.DrawLine(penBk, _tmpPoint1, _tmpPoint2);
            dc.DrawLine(penFg, _tmpPoint1, _tmpPoint2);

            _tmpPoint1.X = point.X;
            _tmpPoint1.Y = point.Y + ConstTrack_Radius2;
            _tmpPoint2.X = point.X;
            _tmpPoint2.Y = point.Y + ConstTrack_Radius;
            dc.DrawLine(penBk, _tmpPoint1, _tmpPoint2);
            dc.DrawLine(penFg, _tmpPoint1, _tmpPoint2);
        }

        public static void DrawTrack(DrawingContext dc, Point point, Pen penFg)
        {
            //
            _tmpPoint1.X = point.X - ConstTrack_Radius2;
            _tmpPoint1.Y = point.Y;
            _tmpPoint2.X = point.X - ConstTrack_Radius;
            _tmpPoint2.Y = point.Y;
            dc.DrawLine(penFg, _tmpPoint1, _tmpPoint2);

            _tmpPoint1.X = point.X + ConstTrack_Radius2;
            _tmpPoint1.Y = point.Y;
            _tmpPoint2.X = point.X + ConstTrack_Radius;
            _tmpPoint2.Y = point.Y;
            dc.DrawLine(penFg, _tmpPoint1, _tmpPoint2);

            //
            _tmpPoint1.X = point.X;
            _tmpPoint1.Y = point.Y - ConstTrack_Radius2;
            _tmpPoint2.X = point.X;
            _tmpPoint2.Y = point.Y - ConstTrack_Radius;
            dc.DrawLine(penFg, _tmpPoint1, _tmpPoint2);

            _tmpPoint1.X = point.X;
            _tmpPoint1.Y = point.Y + ConstTrack_Radius2;
            _tmpPoint2.X = point.X;
            _tmpPoint2.Y = point.Y + ConstTrack_Radius;
            dc.DrawLine(penFg, _tmpPoint1, _tmpPoint2);
        }
    }
}
