using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;

namespace YoseenPTZ.SDKDef
{
    public enum EPtzConn
    {
        None    =   0,//no ptz
        IR,
        VIS,
        VIS_ADV,
    }

    public enum EPtzAction
    {
        Stop,

        MoveUp,
        MoveDown,
        MoveLeft,
        MoveRight,

        MoveLeftUp,
        MoveRightUp,
        MoveLeftDown,
        MoveRightDown,

        ZoomIn,
        ZoomOut,

        FocusFar,
        FocusNear,

        IrisOpen,
        IrisClose,

        PresetSet,
        PresetClear,
        PresetGoto,


        GetPTZ,
        SetPTZ,

        SwitchLightPowerOn,
        SwitchLightPowerOff,

        SwitchWiperPowerOn,
        SwitchWiperPowerOff,

        //add20230209
        PtzAction_GetPan,
        PtzAction_SetPan,

        PtzAction_GetTilt,
        PtzAction_SetTilt,

        PtzAction_GetZoom,
        PtzAction_SetZoom,

        PtzAction_B160_Backlight,
        PtzAction_B160_GetVersion,

        /*
         * pelcod custom req+resp
         *
         * cmd0+cmd1+data0+data1
         *
         * req-pan, resp-tilt
         *
         * */
        PtzAction_B160_W4R4,

        /*
         * DiaoCang
         *
         */
        PtzAction_DC_SuiDong,
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct DiscoverCameraResp2
    {
        public CameraBasicInfo BasicInfo;
        public UInt32 CameraIp;
        public IntPtr pNext;
    }

    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi, Size = 216)]
    public struct CameraBasicInfo
    {
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
        public string CameraId;
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
        public string CameraName;

        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 16)]
        public string CameraType;

        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
        public string FPAId;

        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
        public string HardwareId;

        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
        public string SoftwareId;

        public UInt16 DataWidth;
        public UInt16 DataHeight;
        public UInt16 DataFps;
        public UInt16 DataRatio;

        //
        public UInt16 SendRatio;
        public byte DataTransform;
        public byte FixDist_TempScaleInc;

        //
        public ushort Denoise_IntraFrameTempDelta;
        public byte FixDist_TempScaleDec;
        public byte Filter_Median;

        //
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 20)]
        byte[] pad;

        //
        public ushort VideoWidth;
        public ushort VideoHeight;

        public override string ToString()
        {
            return string.Format("{0}, {1}, {2}, {3}, {4}-{5}-{6}\n",
                CameraId, CameraType, FPAId, SoftwareId,
                DataRatio, SendRatio, DataTransform);
        }
    }

    [StructLayout(LayoutKind.Sequential, Size = 52)]
    public struct CameraNetworkInfo
    {
        [MarshalAs(UnmanagedType.I1)]
        public bool UseStaticIp;

        Byte pad1;

        public UInt16 MulticastPort;
        public UInt32 StaticIp;
        public UInt32 SubnetMask;
        public UInt32 Gateway;
        public UInt32 MulticastIp;

        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 6)]
        public Byte[] MacAddr;

        Byte pad2;
        Byte pad3;

        public UInt32 Dns;
        public UInt32 Dns2;

        public static CameraNetworkInfo create()
        {
            CameraNetworkInfo a = new CameraNetworkInfo();
            a.MacAddr = new byte[6];
            return a;
        }

        public override string ToString()
        {
            string macStr = string.Format("{0:x2}:{1:x2}:{2:x2}:{3:x2}:{4:x2}:{5:x2}",
                MacAddr[0], MacAddr[1], MacAddr[2],
                MacAddr[3], MacAddr[4], MacAddr[5]);

            return string.Format("{0}; {1}, {2}, {3}; {4},{5}; {6}\n",
                UseStaticIp ? "static" : "dhcp",
                YoseenUtil.uint2str(StaticIp), YoseenUtil.uint2str(SubnetMask), YoseenUtil.uint2str(Gateway),
                YoseenUtil.uint2str(Dns), YoseenUtil.uint2str(Dns2),
                macStr);
        }
    }

    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
    public struct FPAInfo
    {
        public const double AD5625R_SENSITIVITY = 5.0 / 4096.0;

        public UInt16 gsk;
        public UInt16 gfid;
        public UInt16 vsk;
        public UInt16 vbus;

        public UInt16 tint;
        public xxxfpacint cint;
        Byte pad;

        public override string ToString()
        {
            double gsk2 = gsk * AD5625R_SENSITIVITY;
            double gfid2 = gfid * AD5625R_SENSITIVITY;
            double vsk2 = vsk * AD5625R_SENSITIVITY;
            double vbus2 = vbus * AD5625R_SENSITIVITY;
            return string.Format("gsk {0:F3}, gfid {1:F3}, vsk {2:F3}, vbus {3:F3}, tint {4}, cint {5}\n",
                gsk2, gfid2, vsk2, vbus2,
                tint, (byte)cint);
        }
    }

    [StructLayout(LayoutKind.Sequential, Size = 16)]
    public struct FFCInfo
    {
        public Byte frames_skipped_after_close;
        public Byte frames_accumlated_when_closed;
        public Byte frames_skipped_after_open;

        public byte nst_enable;
        public UInt16 time_interval;
        public UInt16 temp_interval;

        public sbyte af_rebound;

        public byte fpa_shutter;
        public short nst_delta;
    }

    [StructLayout(LayoutKind.Sequential, Size = 72)]
    public struct FixInfo
    {
        public float AtmosphericTemperature;
        public float RelativeHumidity;
        public float Visibility;
        public float RainfallIntensity;
        public float SnowfallIntensity;
        public float TargetDistance;

        public float GlobalEmissivity;
        public float InfraredWindowTrans;

        public float TempOffset;
        public byte EnableAtmFix;

        public void Reset()
        {
            EnableAtmFix = 0;
            AtmosphericTemperature = 20;
            RelativeHumidity = 50;
            Visibility = 20;
            RainfallIntensity = 0;
            SnowfallIntensity = 0;
            TargetDistance = 200;

            GlobalEmissivity = 0.97f;
            InfraredWindowTrans = 1.0f;
            TempOffset = 0f;

        }
    }

    public enum XuiDisplayFlags
    {
        XDF_Palette = 0x0001,
        XDF_TrackHigh = 0x0002,
        XDF_TrackLow = 0x0004,

        XDF_NoGlobalMax = 0x0008,
        XDF_NoGlobalMin = 0x0010,
        XDF_NoLocalMeasures = 0x0020,
    };

    public enum HDMIPreset : byte
    {
        HDMIPreset_720x576 = 0,
        HDMIPreset_1280x720,
        HDMIPreset_1280x720_960x720,
    };

    [StructLayout(LayoutKind.Sequential, Size = 40)]
    public struct TvoutInfo
    {
        [MarshalAs(UnmanagedType.I1)]
        public bool EnableTvout;

        public xxxpalette PaletteType;

        public short hw_lowDelta;
        public byte hw_lowPercent;


        public byte Zoom;

        public ushort XuiDisplayFlags;

        public float Gain;
        public uint H264_Bitrate;
        public ushort H264_GopSize;
        public strech_type StrechType;
        public byte DDELevel;

        public short man_temp0;
        public short man_temp1;
        public byte man_enable;
        byte pad;
        public HDMIPreset HMDI;

        public ColorTempType CT_Type;
        public short CT_Temp0;
        public short CT_Temp1;
        public int CT_Color0;
        public int CT_Color1;
    }

    [StructLayout(LayoutKind.Sequential, Size = 16)]
    public struct SerialPortInfo
    {
        public xxxspusage Usage;
        public byte PelcoAddr;
        public xxxspbaudrate BaudRate;
        public xxxspdatabits DataBits;
        public xxxspstopbits StopBits;
        public xxxspparity Parity;
    }

    [StructLayout(LayoutKind.Sequential, Size = 16)]
    public struct GpioInfo
    {
        public xxxgpioinputtype Input0;
        public xxxgpioinputtype Input1;

        public xxxgpiooutputtype Output0;
        public xxxgpiooutputtype Output1;
    }

    [StructLayout(LayoutKind.Sequential, Size = 128)]
    public struct CameraTimeInfo
    {
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
        public string NtpServer;
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
        public string NtpServer2;
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
        public string TimeZone;
    }

    public enum CtlType : ushort
    {
        CtlType_Debug = 0,
        CtlType_ChangeDataType,
        CtlType_MoveShutter,
        CtlType_StoreFactory,

        CtlType_RestartCamera,
        CtlType_ManualFFC = 32,
        CtlType_RestoreFactory,
        CtlType_FocusManual,
        CtlType_FocusAuto,

        CtlType_SetAlarm,
        CtlType_DisableFFC,
        CtlType_FocusManual2,

        //add20210708
        CtlType_ZoomType,               ///< 0 stop, 1 in, 2 out
        CtlType_ZoomDelta				///< >0 in, <0 out; unit 5ms
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct GpioAlarm
    {
        public xxxgpioalarmvalue value0;
        public xxxgpioalarmtype type0;
        public byte time0;

        public xxxgpioalarmvalue value1;
        public xxxgpioalarmtype type1;
        public byte time1;
    }

    [StructLayout(LayoutKind.Explicit, Size = 10)]
    public struct Ctl
    {
        [FieldOffset(0)]
        public CtlType Type;

        [FieldOffset(2)]
        public Byte ShutterState;

        [FieldOffset(2)]
        public byte DataType;

        [FieldOffset(2)]
        public Int16 FocusDelta;

        [FieldOffset(2)]
        public xxxfocusrect FocusRect;

        [FieldOffset(2)]
        public GpioAlarm Alarm;

        [FieldOffset(2)]
        public byte DisableFFC;

        [FieldOffset(2)]
        public byte FocusType;

        //add20210708
        [FieldOffset(2)]
        public Int16 ZoomDelta;
        [FieldOffset(2)]
        public byte ZoomType;
    }


    public enum CtlXType : int
    {
        CtlXType_GetTime = 0,
        CtlXType_SetTime,
        CtlXType_GetGear,
        CtlXType_SetGear,
        CtlXType_AutoFocus,

        //add20180921
        CtlXType_XfGetConfig,
        CtlXType_XfSetConfig,
        CtlXType_XfGetCur,
        CtlXType_XfMove,
        CtlXType_XfReset,
        CtlXType_XfCheckDelta,

        //add20200123
        CtlXType_GetExtBbConfig,
        CtlXType_SetExtBbConfig,

        //add20200619
        CtlXType_SyncNTP,

        //add20210607
        CtlXType_ExecutePtz,

        //card20190801
        CtlXType_SetGpioOutput = 128,
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct ExtBbConfig
    {
        public ushort enable;
        public short temp;
        public ushort x;
        public ushort y;
        public ushort radius;
    }

    [StructLayout(LayoutKind.Sequential, Size = 8)]
    public struct xxxgpiooutput
    {
        #region static
        public const int ConstFlags_Light = 1 << 0;
        public const int ConstFlags_Ledy = 1 << 1;
        public const int ConstFlags_Ledb = 1 << 2;
        public const int ConstFlags_Alarm = 1 << 3;
        public const int ConstFlags_Buzz = 1 << 4;
        #endregion

        public int flags;
        public int value;
    }

    [StructLayout(LayoutKind.Sequential, Size = 16)]
    public struct xxxptzcmd
    {
        public byte act;
        public byte arg;
        short pad;

        //
        public int pan;
        public int tilt;
        public int zoom;
    }

    [StructLayout(LayoutKind.Explicit, Size = 68)]
    public struct CtlX
    {
        [FieldOffset(0)]
        public CtlXType Type;

        [FieldOffset(4)]
        public int Error;

        [FieldOffset(4)]
        public xxxdatetime Time;

        [FieldOffset(4)]
        public int GearLevel;

        [FieldOffset(4)]
        public xxxfocusrect FocusRect;

        [FieldOffset(4)]
        public xf_config XfConfig;

        [FieldOffset(4)]
        public int XfMove;

        [FieldOffset(4)]
        public int XfCurType;

        [FieldOffset(4)]
        public xxxgpiooutput GpioOutput;

        [FieldOffset(4)]
        public short OemHWYZ_Wendu;
        [FieldOffset(6)]
        public short OemHWYZ_Shidu;

        [FieldOffset(4)]
        public ExtBbConfig BbConfig;

        [FieldOffset(4)]
        public xxxptzcmd PtzCmd;
    }

    [StructLayout(LayoutKind.Sequential, Size = 128)]
    public struct DataFrameHeader
    {
        public UInt16 Width;
        public UInt16 Height;

        public UInt32 ComSize;
        public byte DataType;
        public byte ComType;
        public UInt16 Index;

        public UInt16 Slope;
        public Int16 Offset;

        public Int32 FPATemp;
        public Int32 ShellTemp;

        public byte Fixed;

        public byte GpioInput0;
        public byte GpioInput1;

        byte pad1;
        int pad2;
        public Int64 Timestamp;

        public Int32 c1CaliTemp;
        public Int32 c1ShellTemp;
        public Int32 c1ShellTempDelta;
    }


    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
    public struct YoseenLoginInfo
    {
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 128)]
        public string CameraAddr;

        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
        public string Username;

        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
        public string Password;
    }

    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
    public struct YoseenLoginInfoV2
    {
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 128)]
        public string CameraAddr;

        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
        public string Username;

        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
        public string Password;

        public ushort PortConfig;

        public ushort PortTemp;

        public ushort PortTempSingle;

        public ushort PortVideo;

        public ushort PortMix;
    }


    [StructLayout(LayoutKind.Sequential, Size = 256)]
    public struct H264FrameStart
    {
        public uint EncDataSize;

        public ushort Width;

        public ushort Height;

        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 120)]
        public byte[] EncData;

        public ushort FpsNum;

        public ushort FpsDen;
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct DataFrame
    {
        public IntPtr Head;

        public IntPtr Temp;

        public IntPtr Com;

        public IntPtr Bmp;

        public IntPtr H264;

        public IntPtr prev;

        public void Reset()
        {
            Head = IntPtr.Zero;
            Temp = IntPtr.Zero;
            Bmp = IntPtr.Zero;
            H264 = IntPtr.Zero;
            Com = IntPtr.Zero;
            prev = IntPtr.Zero;
        }
    }

    public delegate void YoseenPreviewCallback(int errorCode, ref DataFrame dataFrame, IntPtr customData);

    [StructLayout(LayoutKind.Sequential)]
    public struct YoseenPreviewInfo
    {
        public int DataType;

        public IntPtr Hwnd;

        public YoseenPreviewCallback CustomCallback;

        public IntPtr CustomData;

        public ushort OutputWidth;

        public ushort OutputHeight;
    }

    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
    public struct YoseenRtspInfo
    {
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 256)]
        public string Url;

        public byte TransMode;
        public byte CacheTime;
        public byte CopyY;
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 5)]
        byte[] pad;

        //
        public ushort DataWidth;
        public ushort DataHeight;
    }

    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
    public struct ConfigIPReq
    {
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
        public string CameraId;

        public CameraNetworkInfo NetworkInfo;
    }

    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi, Size = 64)]
    public struct AuthInfo
    {
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 16)]
        public string AccessKey;

        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 16)]
        public string RtspUsername;

        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 16)]
        public string RtspPassword;
    }

    public enum xxxdatatype
    {
        temp = 2,
        video = 3,
        video_rtsp = 4,
        video_mix = 5,
    }

    public enum xxxmediafile
    {
        bmpx = 0,
        pngx,
        stream,
        mp4,
        jpgx,
    }

    public enum xxxcamerafile
    {
        bin = 0,
        cali,
        com,

        log,
        cali2,
        cali3,

        bad,

        c2m,
        c2m2,

        cust,
        cust2,

        gaowen,
    }

    public enum xxxpalette : byte
    {
        Autumn = 0,
        BlackHot,
        GlowBow,
        HighContrast,
        HotMetal,
        IronBow,
        Jet,
        RainBow,
        RedSaturation,
        WhiteHot,
        Winter,
        IronBow2,
    }

    public enum xxxfpacint : byte
    {
        fpacint_0 = 0,
        fpacint_1,
        fpacint_2,
        fpacint_3,
        fpacint_4,
        fpacint_5,
        fpacint_6,
        fpacint_7,
    };

    [StructLayout(LayoutKind.Sequential)]
    public struct xxxpoint
    {
        public ushort x;
        public ushort y;
        public ushort radius;
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct xxxline
    {
        public ushort x0;
        public ushort y0;
        public ushort x1;
        public ushort y1;
        public ushort radius;
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct xxxrectangle
    {
        public ushort xmin;
        public ushort ymin;
        public ushort xmax;
        public ushort ymax;
    }

    public enum xxxmeasuretype : byte
    {
        point = 0,

        line = 1,
        rectangle = 2,
        ellipse = 3,
        polyline,
        polygon
    };

    public enum xxxalarmtype : byte
    {
        none = 0,

        max,
        min,
        mid,
        exmid,
        maxmid,
    };

    [Flags]
    public enum xxxmeasureflags : byte
    {
        track_max = 0x01,
        track_min = 0x02,

        plot_max = 0x08,
        plot_min = 0x10,
        plot_avg = 0x20
    }


    public enum xxxtextpos : byte
    {
        RightBottom = 0,
        RightTop,
        LeftBottom,
        LeftTop,
    };

    [StructLayout(LayoutKind.Sequential)]
    public struct xxxmeasure_result
    {
        public float amin;
        public float amax;
        public float aavg;

        public short min;
        public short max;
        public short avg;

        public ushort max_x;
        public ushort max_y;

        public ushort min_x;
        public ushort min_y;
    }

    public enum xxxspdatabits : byte
    {
        databits_5 = 5,
        databits_6,
        databits_7,
        databits_8,
    };
    public enum xxxspparity : byte
    {
        none = 0,
        odd,
        even,
    };
    public enum xxxspstopbits : byte
    {
        stopbits_1 = 0,
        stopbits_2,
    };
    public enum xxxspbaudrate : byte
    {
        baudrate_2400 = 0,
        baudrate_4800,
        baudrate_9600,

        baudrate_19200,
        baudrate_38400,
        baudrate_57600,
        baudrate_115200,
    };
    public enum xxxspusage : byte
    {
        custom = 0,
        pelcod,
        pelcop
    };

    public enum xxxgpioinputtype : byte
    {
        none = 0,
        check,
        capture,
    }
    public enum xxxgpiooutputtype : byte
    {
        close = 0,
        open,
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct xxxfocusrect
    {
        public ushort xmin;
        public ushort ymin;
        public ushort xmax;
        public ushort ymax;
    }

    public enum xxxgpioalarmtype : byte
    {
        manual = 0,
        auto
    }

    public enum xxxgpioalarmvalue : byte
    {
        low = 0,
        high,
        ignore,
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct xxxgpioalarm
    {
        public xxxgpioalarmvalue value0;
        public xxxgpioalarmtype type0;
        public byte time0;

        public xxxgpioalarmvalue value1;
        public xxxgpioalarmtype type1;
        public byte time1;
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct xxxserialportdata
    {
        public byte size;
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 31)]
        public byte[] data;
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct xxxdatetime
    {
        public int year;
        public int mon;
        public int day;

        public int hour;
        public int min;
        public int sec;

        public override string ToString()
        {
            return string.Format("{0:d4}-{1:d2}-{2:d2} {3:d2}:{4:d2}:{5:d2}Z",
                year, mon, day, hour, min, sec);
        }
    }

    public enum TransformType : byte
    {
        None = 0,
        Rotate90,
        Rotate180,
        Rotate270,

        //
        MirrorX,
        MirrorY,
    }

    public enum DivisionType : ushort
    {
        Division_1 = 1,
        Division_2 = 2,
        Division_3 = 3,
        Division_4 = 4,
        Division_5 = 5,
        Division_8 = 8,
        Division_16 = 16,
    }

    public enum ZoomType : byte
    {
        Zoom_1 = 1,
        Zoom_2 = 2,
        Zoom_4 = 4
    }


    public enum GearLevel
    {
        Auto,
        Level1,
        Level2,
        Level3,
    }

    [StructLayout(LayoutKind.Sequential, Size = 16)]
    public struct xf_config
    {
        public short ms_full;//ms, 5000
        public short fc_full;//fc, 3200
        public short fc1;//fc
        public short fc2;//fc

        public short fc_delta;//fc
        public short fc_small;//fc, 300
    };

    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi, Size = 128)]
    public struct FPAInfoHK160
    {
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 80)]
        public byte[] data;

        public byte res64;
        public byte cint;       //5
        public ushort tint;     //160
        public ushort vtemp;    //140
        public byte bias;       //0-7v, 1-5v

        public static FPAInfoHK160 create()
        {
            FPAInfoHK160 x = new FPAInfoHK160();
            x.data = new byte[80];
            return x;
        }

        public bool str2data(string str)
        {
            if (str == null) return false;
            char[] dataStr = str.ToCharArray();
            if (dataStr.Length != 80) return false;

            int i, j;
            for (i = 0, j = 0; i < 40; i++, j += 2)
            {
                int d1 = dataStr[j];
                int d0 = dataStr[j + 1];

                if (d1 < 0x41) d1 = d1 - 0x30;
                else d1 = d1 - 0x41 + 10;

                if (d0 < 0x41) d0 = d0 - 0x30;
                else d0 = d0 - 0x41 + 10;

                int d = (d1 << 4) | d0;
                data[39 - i] = (byte)d;
            }

            return true;
        }

        public string data2str()
        {
            char[] charArray = new char[80];

            int i, j;
            for (i = 39, j = 0; i >= 0; i--, j += 2)
            {
                int d = (data[i] & 0xf0) >> 4;
                if (d < 10) d = d + 0x30;
                else d = (d - 10) + 0x41;
                charArray[j] = Convert.ToChar(d);

                d = data[i] & 0x0f;
                if (d < 10) d = d + 0x30;
                else d = (d - 10) + 0x41;
                charArray[j + 1] = Convert.ToChar(d);
            }

            return new string(charArray);
        }

        public void data2arg()
        {
            //cint, 81-83, 10.1
            int x = data[10] & 0x0e;
            cint = (byte)(x >> 1);

            //tint, 290-299, 36.2
            x = (data[37] << 8) | data[36];
            tint = (ushort)((x & 0x0ffc) >> 2);

            //res64, 100-163, 12.4-20.3
            int count = 0;
            int i, j;
            x = data[12] & 0xf0;
            for (j = 4; j <= 7; j++)
            {
                if ((x & (1 << j)) != 0) count++;
            }
            for (i = 0; i <= 6; i++)
            {
                x = data[13 + i];
                for (j = 0; j <= 7; j++)
                {
                    if ((x & (1 << j)) != 0) count++;
                }
            }
            x = data[20] & 0x0f;
            for (j = 0; j <= 3; j++)
            {
                if ((x & (1 << j)) != 0) count++;
            }
            res64 = (byte)count;

            //lvds, 188,174,40,39; 0101
            //p[23] &= 0xef;//23.4
            //p[21] |= 0x40;//21.6
            //p[5] &= 0xfe;//5.0
            //p[4] |= 0x80;//4.7
            //binary, 202, 25.2
            //p[25] &= 0xfb;

            //vtemp, 225-234, 28.1-29.2
            x = (data[29] << 8) | data[28];
            vtemp = (ushort)((x & 0x07fe) >> 1);
        }

        public override string ToString()
        {
            return data2str() + "\n";
        }
    }

    public enum MixMode
    {
        MixMode_IR = 0,
        MixMode_VIS,
        MixMode_DSX,
        MixMode_BLEND,
        MixMode_PIP,
    }

    public enum MixFlip
    {
        Flip_NN = 0,
        Flip_XN,

        Flip_NY,
        Flip_XY,
    }

    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi, Size = 48)]
    public struct CameraOutputInfo
    {
        public byte MixMode;
        public byte MixRatio;

        public ushort CropX;
        public ushort CropY;
        public ushort CropWidth;
        public ushort CropHeight;

        public byte StrechType;
        public byte DDELevel;
        public float Gain;

        public short man_temp0;
        public short man_temp1;
        public byte man_enable;
        byte pad;


        public byte PaletteType;
        byte Contrast;
        byte Brightness;

        public byte EnableHdmi;


        public ushort H264_GopSize;
        public uint H264_Bitrate;

        public byte FlipIR;
        public byte FlipVIS;
        public ushort XStartVIS;
        public ushort YStartVIS;
        public ushort XuiDisplayFlags;

        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 8)]
        byte[] reserved;
    }

    public enum xxxcameramem
    {
        measure = 0,
    }

    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
    public struct bad_file_header
    {
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
        public string camera_id;

        public int width;
        public int height;

        public int count;
    }

    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
    public struct cust_file_header
    {
        //basic
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
        public string camera_id;

        public int version;

        public int bte_count;
    }
}
