using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;

namespace YoseenPTZ.SDKDef
{
    public static class YoseenFfmpeg
    {
        [DllImport("YoseenFfmpeg.dll", EntryPoint = "H264Enc_Open", CallingConvention = CallingConvention.Cdecl)]
        public extern static IntPtr H264Enc_Open();

        [DllImport("YoseenFfmpeg.dll", EntryPoint = "H264Enc_Close", CallingConvention = CallingConvention.Cdecl)]
        public extern static void H264Enc_Close(ref IntPtr pp);

        [DllImport("YoseenFfmpeg.dll", EntryPoint = "H264Enc_SetConfig", CallingConvention = CallingConvention.Cdecl)]
        public extern static int H264Enc_SetConfig(IntPtr hem, ref H264Info info);

        [DllImport("YoseenFfmpeg.dll", EntryPoint = "H264Enc_EncFrame", CallingConvention = CallingConvention.Cdecl)]
        public extern static int H264Enc_EncFrame(IntPtr hem, IntPtr input, ref IntPtr h264, ref int h264Size);

        [DllImport("YoseenFfmpeg.dll", EntryPoint = "H264Enc_MuxBegin", CallingConvention = CallingConvention.Cdecl)]
        public extern static int H264Enc_MuxBegin(IntPtr context, string fn);

        [DllImport("YoseenFfmpeg.dll", EntryPoint = "H264Enc_MuxFrame", CallingConvention = CallingConvention.Cdecl)]
        public extern static int H264Enc_MuxFrame(IntPtr context, IntPtr h264, int h264Size);

        [DllImport("YoseenFfmpeg.dll", EntryPoint = "H264Enc_MuxEnd", CallingConvention = CallingConvention.Cdecl)]
        public extern static int H264Enc_MuxEnd(IntPtr context);
    }

    [StructLayout(LayoutKind.Sequential)]
    public struct H264Info
    {
        //
        public int config_hwType;

        //
        public ushort width;
        public ushort height;
        public ushort fpsNum;
        public ushort fpsDen;
        public ushort gopSize;
        public ushort bitrate;//kbps

        //
        public int encDataSize;

        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 64)]
        public byte[] encData;
    }
}
