using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;

namespace YoseenPTZ.SDKDef
{
    [StructLayout(LayoutKind.Sequential)]
    public struct TempFrameFile
    {
        public IntPtr ffh;

        public IntPtr custom;

        public IntPtr dfh;

        public IntPtr dfd;

        public IntPtr visiImage;

        public IntPtr coverImage;

        public int visiImageSize;

        public int coverImageSize;
    }

    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi, Size = 128)]
    public struct frame_file_header
    {
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
        public string camera_id;

        public Int64 captured_time;

        public UInt16 width;

        public UInt16 height;

        public FixInfo fix_info;

        public byte palette;
    }

    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi, Size = 128)]
    public struct stream_file_header
    {
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
        public string camera_id;

        public Int64 captured_time;

        public UInt16 width;
        public UInt16 height;

        public FixInfo fix_info;

        public ushort fps_num;
        public ushort fps_den;

        public UInt32 frame_count;

        public byte palette;
        public byte pad;
        public short record_ratio;
    }


    /// <summary>
    /// ptc_custom
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    public struct ptc_custom
    {
        public const int Const_Version = 20191204;

        public int version;
        public int palette;
        public strech_control sc;
        public MeasureTemplate mt;

        public static ptc_custom Create()
        {
            ptc_custom x = new ptc_custom();
            x.version = Const_Version;
            x.palette = (int)xxxpalette.IronBow;
            x.sc.Reset();
            x.mt = MeasureTemplate.Create();
            return x;
        }
    }

    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi, Size = 128)]
    public struct bs_file_header
    {
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
        public string camera_id;
        public Int64 captured_time;
        public UInt16 width;
        public UInt16 height;

        public Int32 env_temp;
        public Int32 blackbody_temp;

        public Byte frames_acced;
    }


}
