using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;

namespace YoseenPTZ.SDKDef
{
    public static class YoseenSDK
    {
        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_InitSDK", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_InitSDK();

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_FreeSDK", CallingConvention = CallingConvention.Cdecl)]
        public extern static void Yoseen_FreeSDK();

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_SetTimeout", CallingConvention = CallingConvention.Cdecl)]
        public extern static void Yoseen_SetTimeout(int connectTimeout, int sendTimeout, int recvTimeout);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_ExportText", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_ExportText(IntPtr dfh, IntPtr dfd, string fn);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_Login", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_Login(ref YoseenLoginInfo loginInfo, ref CameraBasicInfo cameraBasicInfo);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_LoginV2", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_LoginV2(ref YoseenLoginInfoV2 loginInfo, ref CameraBasicInfo cameraBasicInfo);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_Logout", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_Logout(int userHandle);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_SaveFrame", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_SaveFrame(int userHandle, string fileName, int withTemp);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_SaveFrameToMem", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_SaveFrameToMem(int userHandle, ref TempFrameFile frameFile);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_StartPreview", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_StartPreview(int userHandle, ref YoseenPreviewInfo previewInfo);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_StartPreviewTempScale", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_StartPreviewTempScale(int userHandle, ref YoseenPreviewInfo previewInfo, int tempScale);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_StartPreviewTempTransform", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_StartPreviewTempTransform(int userHandle, ref YoseenPreviewInfo previewInfo, int tempTransform);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_StartPreviewRtsp", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_StartPreviewRtsp(ref YoseenRtspInfo rtspInfo, ref YoseenPreviewInfo previewInfo);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_StopPreview", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_StopPreview(int previewHandle);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_PausePreview", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_PausePreview(int previewHandle, int pause);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_BeginSave", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_BeginSave(int previewHandle, string fileName, int fileType);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_BeginSaveStream", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_BeginSaveStream(int previewHandle, string fileName, int timeDelta);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_EndSave", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_EndSave(int previewHandle, int fileType);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_PreviewSetImage", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_PreviewSetImage(int previewHandle, ref strech_control strechControl, int paletteType);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_PreviewEnableMask", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_PreviewEnableMask(int previewHandle, int enable);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_DiscoverCameras", CallingConvention = CallingConvention.Cdecl)]
        public extern static IntPtr Yoseen_DiscoverCameras(int discoverFlags);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_DiscoverCamerasFree", CallingConvention = CallingConvention.Cdecl)]
        public extern static void Yoseen_DiscoverCamerasFree(ref IntPtr pp);

        public static DiscoverCameraResp2[] Yoseen_DiscoverCameras2(int discoverFlags)
        {
            List<DiscoverCameraResp2> result = new List<DiscoverCameraResp2>();
            IntPtr pHead = Yoseen_DiscoverCameras(discoverFlags);
            IntPtr p = pHead;
            while (p != IntPtr.Zero)
            {
                DiscoverCameraResp2 dcr = (DiscoverCameraResp2)Marshal.PtrToStructure(p, typeof(DiscoverCameraResp2));
                result.Add(dcr);
                p = dcr.pNext;
            }

            if (pHead != IntPtr.Zero)
            {
                Yoseen_DiscoverCamerasFree(ref pHead);
            }
            return result.ToArray();
        }

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_GetCameraBasicInfo", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_GetCameraBasicInfo(int userHandle, ref CameraBasicInfo cameraBasicInfo);
        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_SetCameraBasicInfo", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_SetCameraBasicInfo(int userHandle, ref CameraBasicInfo cameraBasicInfo);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_GetCameraNetworkInfo", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_GetCameraNetworkInfo(int userHandle, ref CameraNetworkInfo cameraNetworkInfo);
        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_SetCameraNetworkInfo", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_SetCameraNetworkInfo(int userHandle, ref CameraNetworkInfo cameraNetworkInfo);


        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_GetFPAInfo", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_GetFPAInfo(int userHandle, ref FPAInfo fpaInfo, int index);
        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_SetFPAInfo", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_SetFPAInfo(int userHandle, ref FPAInfo fpaInfo, int index);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_GetFFCInfo", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_GetFFCInfo(int userHandle, ref FFCInfo ffcInfo);
        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_SetFFCInfo", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_SetFFCInfo(int userHandle, ref FFCInfo ffcInfo);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_GetTvoutInfo", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_GetTvoutInfo(int userHandle, ref TvoutInfo tvoutInfo);
        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_SetTvoutInfo", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_SetTvoutInfo(int userHandle, ref TvoutInfo tvoutInfo);


        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_GetFixInfo", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_GetFixInfo(int userHandle, ref FixInfo fixInfo);
        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_SetFixInfo", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_SetFixInfo(int userHandle, ref FixInfo fixInfo);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_GetCameraTimeInfo", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_GetCameraTimeInfo(int userHandle, ref CameraTimeInfo cameraTimeInfo);
        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_SetCameraTimeInfo", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_SetCameraTimeInfo(int userHandle, ref CameraTimeInfo cameraTimeInfo);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_GetGpioInfo", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_GetGpioInfo(int userHandle, ref GpioInfo gpioInfo);
        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_SetGpioInfo", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_SetGpioInfo(int userHandle, ref GpioInfo gpioInfo);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_GetSerialPortInfo", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_GetSerialPortInfo(int userHandle, ref SerialPortInfo serialPortInfo);
        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_SetSerialPortInfo", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_SetSerialPortInfo(int userHandle, ref SerialPortInfo serialPortInfo);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_GetFPAInfoHK160", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_GetFPAInfoHK160(int userHandle, ref FPAInfoHK160 info);
        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_SetFPAInfoHK160", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_SetFPAInfoHK160(int userHandle, ref FPAInfoHK160 info);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_SendControl", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_SendControl(int userHandle, ref Ctl ctl);
        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_SendControl", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_SendControl(int userHandle, IntPtr ctl);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_SendControlX", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_SendControlX(int userHandle, ref CtlX ctlx);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_SendControlX", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_SendControlX(int userHandle, IntPtr ctlx);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_WriteSerialPortData", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_WriteSerialPortData(int userHandle, ref xxxserialportdata spd);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_UploadFile", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_UploadFile(int userHandle, string fn, int fileType);
        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_DownloadFile", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_DownloadFile(int userHandle, string fn, int fileType);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_GetCameraOutputInfo", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_GetCameraOutputInfo(int userHandle, ref CameraOutputInfo info);
        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_SetCameraOutputInfo", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_SetCameraOutputInfo(int userHandle, ref CameraOutputInfo info);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_GetAuthInfo", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_GetAuthInfo(int userHandle, ref AuthInfo info);
        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_SetAuthInfo", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_SetAuthInfo(int userHandle, ref AuthInfo info);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_UploadMem", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_UploadMem(int userHandle, int memType, IntPtr memData, int memSize);
        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_DownloadMem", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_DownloadMem(int userHandle, int memType, IntPtr memData, ref int memSize);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_DiscoverConfigIP", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_DiscoverConfigIP(ref ConfigIPReq req);
        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_DiscoverConfigIP", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Yoseen_DiscoverConfigIP2(IntPtr req);
    }

    public static class YoseenPlayback
    {
        public const int JpgDataMaxSize = 256 + 1280 * 1024 * 4;

        [DllImport("YoseenSDK.dll", EntryPoint = "YoseenPlayback_Create", CallingConvention = CallingConvention.Cdecl)]
        public extern static IntPtr YoseenPlayback_Create();
        [DllImport("YoseenSDK.dll", EntryPoint = "YoseenPlayback_Free", CallingConvention = CallingConvention.Cdecl)]
        public extern static void YoseenPlayback_Free(ref IntPtr pp);

        [DllImport("YoseenSDK.dll", EntryPoint = "YoseenPlayback_GetImage", CallingConvention = CallingConvention.Cdecl)]
        public extern static void YoseenPlayback_GetImage(IntPtr ctx, ref strech_control sc, ref int paletteType);
        [DllImport("YoseenSDK.dll", EntryPoint = "YoseenPlayback_SetImage", CallingConvention = CallingConvention.Cdecl)]
        public extern static void YoseenPlayback_SetImage(IntPtr ctx, ref strech_control sc, ref int paletteType);

        [DllImport("YoseenSDK.dll", EntryPoint = "YoseenPlayback_OpenFile", CallingConvention = CallingConvention.Cdecl)]
        public extern static int YoseenPlayback_OpenFile(IntPtr ctx, string fileName, int fileType);

        [DllImport("YoseenSDK.dll", EntryPoint = "YoseenPlayback_OpenMem", CallingConvention = CallingConvention.Cdecl)]
        public extern static int YoseenPlayback_OpenMem(IntPtr ctx, IntPtr dfh, IntPtr dfd);

        [DllImport("YoseenSDK.dll", EntryPoint = "YoseenPlayback_CloseFile", CallingConvention = CallingConvention.Cdecl)]
        public extern static void YoseenPlayback_CloseFile(IntPtr ctx);

        [DllImport("YoseenSDK.dll", EntryPoint = "YoseenPlayback_SaveFile", CallingConvention = CallingConvention.Cdecl)]
        public extern static int YoseenPlayback_SaveFile(IntPtr ctx, ref TempFrameFile tff, string fileName);

        [DllImport("YoseenSDK.dll", EntryPoint = "YoseenPlayback_ReadCover", CallingConvention = CallingConvention.Cdecl)]
        public extern static int YoseenPlayback_ReadCover(IntPtr ctx, ref TempFrameFile tff);

        [DllImport("YoseenSDK.dll", EntryPoint = "YoseenPlayback_ReadFrame", CallingConvention = CallingConvention.Cdecl)]
        public extern static int YoseenPlayback_ReadFrame(IntPtr ctx, int frameIndex, ref DataFrame dataFrame);
    }

    public static class YoseenAlg
    {
        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_AllocPaletteData", CallingConvention = CallingConvention.Cdecl)]
        public extern static IntPtr Yoseen_AllocPaletteData(ref int paletteCount);

        [DllImport("YoseenSDK.dll", EntryPoint = "Yoseen_FreePaletteData", CallingConvention = CallingConvention.Cdecl)]
        public extern static void Yoseen_FreePaletteData(ref IntPtr pp);

        [DllImport("YoseenSDK.dll", EntryPoint = "mtGetResult", CallingConvention = CallingConvention.Cdecl)]
        public extern static int mtGetResult(IntPtr dfh, IntPtr dfd, ref xxxmeasure mea, ref xxxresult result);

        [DllImport("YoseenSDK.dll", EntryPoint = "mtGetResult_GMO", CallingConvention = CallingConvention.Cdecl)]
        public extern static int mtGetResult_GMO(IntPtr dfh, IntPtr dfd, ref xxxresult result);

        [DllImport("YoseenSDK.dll", EntryPoint = "mtCreate", CallingConvention = CallingConvention.Cdecl)]
        public extern static IntPtr mtCreate(int width, int height);

        [DllImport("YoseenSDK.dll", EntryPoint = "mtFree", CallingConvention = CallingConvention.Cdecl)]
        public extern static void mtFree(ref IntPtr pp);

        [DllImport("YoseenSDK.dll", EntryPoint = "mtReload", CallingConvention = CallingConvention.Cdecl)]
        public extern static int mtReload(IntPtr context, IntPtr ptrMT);

        [DllImport("YoseenSDK.dll", EntryPoint = "mtReload", CallingConvention = CallingConvention.Cdecl)]
        public extern static int mtReload2(IntPtr context, ref MeasureTemplate mt);

        [DllImport("YoseenSDK.dll", EntryPoint = "mtCheck", CallingConvention = CallingConvention.Cdecl)]
        public extern static int mtCheck(IntPtr context, IntPtr dfh, IntPtr dfd, IntPtr ptrMTR);

        [DllImport("YoseenSDK.dll", EntryPoint = "mtCheck", CallingConvention = CallingConvention.Cdecl)]
        public extern static int mtCheck2(IntPtr context, IntPtr dfh, IntPtr dfd, ref MeasureTemplateResult mtr);

        [DllImport("YoseenSDK.dll", EntryPoint = "Alg_ScaleTemp", CallingConvention = CallingConvention.Cdecl)]
        public extern static int Alg_ScaleTemp(int scale, ushort srcWidth, ushort srcHeight, IntPtr srcData, IntPtr dstData);

        [DllImport("YoseenSDK.dll", EntryPoint = "Alg_Transform", CallingConvention = CallingConvention.Cdecl)]
        public extern static void Alg_Transform(IntPtr dfh, IntPtr dfd, IntPtr tmp, int transformType);


        [DllImport("YoseenSDK.dll", EntryPoint = "caliVerify", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
        public extern static int caliVerify(string filename, string camera_id);

        [DllImport("YoseenSDK.dll", EntryPoint = "caliVerifyBad", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
        public extern static int caliVerifyBad(string filename, ref bad_file_header bfh);

        [DllImport("YoseenSDK.dll", EntryPoint = "caliVerifyCust", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
        public extern static int caliVerifyCust(string filename, string camera_id);

        [DllImport("YoseenSDK.dll", EntryPoint = "caliVerifyC2m", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
        public extern static int caliVerifyC2m(string filename, string camera_id);


        [DllImport("YoseenSDK.dll", EntryPoint = "caliVerifyGaoWen", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
        public extern static int caliVerifyGaoWen(string filename, string camera_id);
    }
}
